/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.FloatMath;
import android.util.Log;
import java.util.ArrayList;

public class PointCloud {
    private static final float MIN_POINT_SIZE = 2.0f;
    private static final float MAX_POINT_SIZE = 4.0f;
    private static final int INNER_POINTS = 8;
    private static final String TAG = "PointCloud";
    private ArrayList<Point> mPointCloud = new ArrayList();
    private Drawable mDrawable;
    private float mCenterX;
    private float mCenterY;
    private Paint mPaint;
    private float mScale = 1.0f;
    private static final float PI = (float)Math.PI;
    WaveManager waveManager = new WaveManager();
    GlowManager glowManager = new GlowManager();
    private float mOuterRadius;

    public PointCloud(Drawable drawable2) {
        this.mPaint = new Paint();
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setColor(Color.rgb(255, 255, 255));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mDrawable = drawable2;
        if (this.mDrawable != null) {
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        }
    }

    public void setCenter(float x, float y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public void makePointCloud(float innerRadius, float outerRadius) {
        if (innerRadius == 0.0f) {
            Log.w(TAG, "Must specify an inner radius");
            return;
        }
        this.mOuterRadius = outerRadius;
        this.mPointCloud.clear();
        float pointAreaRadius = outerRadius - innerRadius;
        float ds = (float)Math.PI * 2 * innerRadius / 8.0f;
        int bands = Math.round(pointAreaRadius / ds);
        float dr = pointAreaRadius / (float)bands;
        float r = innerRadius;
        int b = 0;
        while (b <= bands) {
            float circumference = (float)Math.PI * 2 * r;
            int pointsInBand = (int)(circumference / ds);
            float eta = 1.5707964f;
            float dEta = (float)Math.PI * 2 / (float)pointsInBand;
            for (int i = 0; i < pointsInBand; ++i) {
                float x = r * FloatMath.cos(eta);
                float y = r * FloatMath.sin(eta);
                eta += dEta;
                this.mPointCloud.add(new Point(x, y, r));
            }
            ++b;
            r += dr;
        }
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public float getScale() {
        return this.mScale;
    }

    private static float hypot(float x, float y) {
        return FloatMath.sqrt(x * x + y * y);
    }

    private static float max(float a, float b) {
        return a > b ? a : b;
    }

    public int getAlphaForPoint(Point point) {
        float glowDistance = PointCloud.hypot(this.glowManager.x - point.x, this.glowManager.y - point.y);
        float glowAlpha = 0.0f;
        if (glowDistance < this.glowManager.radius) {
            float cosf = FloatMath.cos(0.7853982f * glowDistance / this.glowManager.radius);
            glowAlpha = this.glowManager.alpha * PointCloud.max(0.0f, (float)Math.pow(cosf, 10.0));
        }
        float radius = PointCloud.hypot(point.x, point.y);
        float waveAlpha = 0.0f;
        if (radius < this.waveManager.radius * 2.0f) {
            float distanceToWaveRing = radius - this.waveManager.radius;
            float cosf = FloatMath.cos(1.5707964f * distanceToWaveRing / this.waveManager.radius);
            waveAlpha = this.waveManager.alpha * PointCloud.max(0.0f, (float)Math.pow(cosf, 6.0));
        }
        return (int)(PointCloud.max(glowAlpha, waveAlpha) * 255.0f);
    }

    private float interp(float min, float max, float f) {
        return min + (max - min) * f;
    }

    public void draw(Canvas canvas) {
        ArrayList<Point> points = this.mPointCloud;
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale, this.mCenterX, this.mCenterY);
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            float pointSize = this.interp(4.0f, 2.0f, point.radius / this.mOuterRadius);
            float px = point.x + this.mCenterX;
            float py = point.y + this.mCenterY;
            int alpha = this.getAlphaForPoint(point);
            if (alpha == 0) continue;
            if (this.mDrawable != null) {
                canvas.save(1);
                float cx = (float)this.mDrawable.getIntrinsicWidth() * 0.5f;
                float cy = (float)this.mDrawable.getIntrinsicHeight() * 0.5f;
                float s = pointSize / 4.0f;
                canvas.scale(s, s, px, py);
                canvas.translate(px - cx, py - cy);
                this.mDrawable.setAlpha(alpha);
                this.mDrawable.draw(canvas);
                canvas.restore();
                continue;
            }
            this.mPaint.setAlpha(alpha);
            canvas.drawCircle(px, py, pointSize, this.mPaint);
        }
        canvas.restore();
    }

    class Point {
        float x;
        float y;
        float radius;

        public Point(float x2, float y2, float r) {
            this.x = x2;
            this.y = y2;
            this.radius = r;
        }
    }

    public class GlowManager {
        private float x;
        private float y;
        private float radius = 0.0f;
        private float alpha = 0.0f;

        public void setX(float x1) {
            this.x = x1;
        }

        public float getX() {
            return this.x;
        }

        public void setY(float y1) {
            this.y = y1;
        }

        public float getY() {
            return this.y;
        }

        public void setAlpha(float a) {
            this.alpha = a;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setRadius(float r) {
            this.radius = r;
        }

        public float getRadius() {
            return this.radius;
        }
    }

    public class WaveManager {
        private float radius = 50.0f;
        private float alpha = 0.0f;

        public void setRadius(float r) {
            this.radius = r;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setAlpha(float a) {
            this.alpha = a;
        }

        public float getAlpha() {
            return this.alpha;
        }
    }
}

