/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.ILockSettingsObserver;

public class LockPatternUtilsCache
implements ILockSettings {
    private static final String HAS_LOCK_PATTERN_CACHE_KEY = "LockPatternUtils.Cache.HasLockPatternCacheKey";
    private static final String HAS_LOCK_PASSWORD_CACHE_KEY = "LockPatternUtils.Cache.HasLockPasswordCacheKey";
    private static LockPatternUtilsCache sInstance;
    private final ILockSettings mService;
    private final ArrayMap<CacheKey, Object> mCache = new ArrayMap();
    private final CacheKey mCacheKey = new CacheKey();
    private final ILockSettingsObserver mObserver = new ILockSettingsObserver.Stub(){

        @Override
        public void onLockSettingChanged(String key, int userId) throws RemoteException {
            LockPatternUtilsCache.this.invalidateCache(key, userId);
        }
    };

    public static synchronized LockPatternUtilsCache getInstance(ILockSettings service) {
        if (sInstance == null) {
            sInstance = new LockPatternUtilsCache(service);
        }
        return sInstance;
    }

    private LockPatternUtilsCache(ILockSettings service) {
        this.mService = service;
        try {
            service.registerObserver(this.mObserver);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        this.invalidateCache(key, userId);
        this.mService.setBoolean(key, value, userId);
        this.putCache(key, userId, value);
    }

    @Override
    public void setLong(String key, long value, int userId) throws RemoteException {
        this.invalidateCache(key, userId);
        this.mService.setLong(key, value, userId);
        this.putCache(key, userId, value);
    }

    @Override
    public void setString(String key, String value, int userId) throws RemoteException {
        this.invalidateCache(key, userId);
        this.mService.setString(key, value, userId);
        this.putCache(key, userId, value);
    }

    @Override
    public long getLong(String key, long defaultValue, int userId) throws RemoteException {
        Object value = this.peekCache(key, userId);
        if (value instanceof Long) {
            return (Long)value;
        }
        long result = this.mService.getLong(key, defaultValue, userId);
        this.putCache(key, userId, result);
        return result;
    }

    @Override
    public String getString(String key, String defaultValue, int userId) throws RemoteException {
        Object value = this.peekCache(key, userId);
        if (value instanceof String) {
            return (String)value;
        }
        String result = this.mService.getString(key, defaultValue, userId);
        this.putCache(key, userId, result);
        return result;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
        Object value = this.peekCache(key, userId);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean result = this.mService.getBoolean(key, defaultValue, userId);
        this.putCache(key, userId, result);
        return result;
    }

    @Override
    public void setLockPattern(String pattern, int userId) throws RemoteException {
        this.invalidateCache(HAS_LOCK_PATTERN_CACHE_KEY, userId);
        this.mService.setLockPattern(pattern, userId);
        this.putCache(HAS_LOCK_PATTERN_CACHE_KEY, userId, pattern != null);
    }

    @Override
    public boolean checkPattern(String pattern, int userId) throws RemoteException {
        return this.mService.checkPattern(pattern, userId);
    }

    @Override
    public void setLockPassword(String password, int userId) throws RemoteException {
        this.invalidateCache(HAS_LOCK_PASSWORD_CACHE_KEY, userId);
        this.mService.setLockPassword(password, userId);
        this.putCache(HAS_LOCK_PASSWORD_CACHE_KEY, userId, password != null);
    }

    @Override
    public boolean checkPassword(String password, int userId) throws RemoteException {
        return this.mService.checkPassword(password, userId);
    }

    @Override
    public boolean checkVoldPassword(int userId) throws RemoteException {
        return this.mService.checkVoldPassword(userId);
    }

    @Override
    public boolean havePattern(int userId) throws RemoteException {
        Object value = this.peekCache(HAS_LOCK_PATTERN_CACHE_KEY, userId);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean result = this.mService.havePattern(userId);
        this.putCache(HAS_LOCK_PATTERN_CACHE_KEY, userId, result);
        return result;
    }

    @Override
    public boolean havePassword(int userId) throws RemoteException {
        Object value = this.peekCache(HAS_LOCK_PASSWORD_CACHE_KEY, userId);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean result = this.mService.havePassword(userId);
        this.putCache(HAS_LOCK_PASSWORD_CACHE_KEY, userId, result);
        return result;
    }

    @Override
    public void removeUser(int userId) throws RemoteException {
        this.mService.removeUser(userId);
    }

    @Override
    public void registerObserver(ILockSettingsObserver observer) throws RemoteException {
        this.mService.registerObserver(observer);
    }

    @Override
    public void unregisterObserver(ILockSettingsObserver observer) throws RemoteException {
        this.mService.unregisterObserver(observer);
    }

    @Override
    public IBinder asBinder() {
        return this.mService.asBinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object peekCache(String key, int userId) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            return this.mCache.get(this.mCacheKey.set(key, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCache(String key, int userId, Object value) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            this.mCache.put(new CacheKey().set(key, userId), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCache(String key, int userId) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            this.mCache.remove(this.mCacheKey.set(key, userId));
        }
    }

    private static final class CacheKey {
        String key;
        int userId;

        private CacheKey() {
        }

        public CacheKey set(String key, int userId) {
            this.key = key;
            this.userId = userId;
            return this;
        }

        public CacheKey copy() {
            return new CacheKey().set(this.key, this.userId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey o = (CacheKey)obj;
            return this.userId == o.userId && this.key.equals(o.key);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.userId;
        }
    }
}

