/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class BatteryStatsHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = BatteryStatsHelper.class.getSimpleName();
    private static BatteryStats sStatsXfer;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private final Context mContext;
    private final boolean mCollectBatteryBroadcast;
    private final boolean mWifiOnly;
    private IBatteryStats mBatteryInfo;
    private BatteryStats mStats;
    private Intent mBatteryBroadcast;
    private PowerProfile mPowerProfile;
    private final List<BatterySipper> mUsageList = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mWifiSippers = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mBluetoothSippers = new ArrayList<BatterySipper>();
    private final SparseArray<List<BatterySipper>> mUserSippers = new SparseArray();
    private final SparseArray<Double> mUserPower = new SparseArray();
    private final List<BatterySipper> mMobilemsppList = new ArrayList<BatterySipper>();
    private int mStatsType = 0;
    long mRawRealtime;
    long mRawUptime;
    long mBatteryRealtime;
    long mBatteryUptime;
    long mTypeBatteryRealtime;
    long mTypeBatteryUptime;
    long mBatteryTimeRemaining;
    long mChargeTimeRemaining;
    private long mStatsPeriod = 0L;
    private double mMaxPower = 1.0;
    private double mMaxRealPower = 1.0;
    private double mComputedPower;
    private double mTotalPower;
    private double mWifiPower;
    private double mBluetoothPower;
    private double mMinDrainedPower;
    private double mMaxDrainedPower;
    private long mAppMobileActive;
    private long mAppWifiRunning;

    public BatteryStatsHelper(Context context) {
        this(context, true);
    }

    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast) {
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = BatteryStatsHelper.checkWifiOnly(context);
    }

    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast, boolean wifiOnly) {
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = wifiOnly;
    }

    public static boolean checkWifiOnly(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return !cm.isNetworkSupported(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStatsHistoryInFile(String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            File path = BatteryStatsHelper.makeFilePath(this.mContext, fname);
            sFileXfer.put(path, this.getStats());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                Parcel hist = Parcel.obtain();
                this.getStats().writeToParcelWithoutUids(hist, 0);
                byte[] histData = hist.marshall();
                fout.write(histData);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to write history to file", e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatteryStats statsFromFile(Context context, String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            block15: {
                BatteryStats batteryStats;
                File path = BatteryStatsHelper.makeFilePath(context, fname);
                BatteryStats stats = sFileXfer.get(path);
                if (stats != null) {
                    return stats;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(path);
                    byte[] data = BatteryStatsHelper.readFully(fin);
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    batteryStats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read history to file", e);
                    break block15;
                }
                return batteryStats;
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
            return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
        }
    }

    public static void dropFile(Context context, String fname) {
        BatteryStatsHelper.makeFilePath(context, fname).delete();
    }

    private static File makeFilePath(Context context, String fname) {
        return new File(context.getFilesDir(), fname);
    }

    public void clearStats() {
        this.mStats = null;
    }

    public BatteryStats getStats() {
        if (this.mStats == null) {
            this.load();
        }
        return this.mStats;
    }

    public Intent getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    public PowerProfile getPowerProfile() {
        return this.mPowerProfile;
    }

    public void create(BatteryStats stats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = stats;
    }

    public void create(Bundle icicle) {
        if (icicle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    public void storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    public static String makemAh(double power) {
        if (power < 1.0E-5) {
            return String.format("%.8f", power);
        }
        if (power < 1.0E-4) {
            return String.format("%.7f", power);
        }
        if (power < 0.001) {
            return String.format("%.6f", power);
        }
        if (power < 0.01) {
            return String.format("%.5f", power);
        }
        if (power < 0.1) {
            return String.format("%.4f", power);
        }
        if (power < 1.0) {
            return String.format("%.3f", power);
        }
        if (power < 10.0) {
            return String.format("%.2f", power);
        }
        if (power < 100.0) {
            return String.format("%.1f", power);
        }
        return String.format("%.0f", power);
    }

    public void refreshStats(int statsType, int asUser) {
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(1);
        users.put(asUser, new UserHandle(asUser));
        this.refreshStats(statsType, users);
    }

    public void refreshStats(int statsType, List<UserHandle> asUsers) {
        int n = asUsers.size();
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(n);
        for (int i = 0; i < n; ++i) {
            UserHandle userHandle = asUsers.get(i);
            users.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(statsType, users);
    }

    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers) {
        this.refreshStats(statsType, asUsers, SystemClock.elapsedRealtime() * 1000L, SystemClock.uptimeMillis() * 1000L);
    }

    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers, long rawRealtimeUs, long rawUptimeUs) {
        int i;
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mWifiPower = 0.0;
        this.mBluetoothPower = 0.0;
        this.mAppMobileActive = 0L;
        this.mAppWifiRunning = 0L;
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.mUserSippers.clear();
        this.mUserPower.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        this.mStatsType = statsType;
        this.mRawUptime = rawUptimeUs;
        this.mRawRealtime = rawRealtimeUs;
        this.mBatteryUptime = this.mStats.getBatteryUptime(rawUptimeUs);
        this.mBatteryRealtime = this.mStats.getBatteryRealtime(rawRealtimeUs);
        this.mTypeBatteryUptime = this.mStats.computeBatteryUptime(rawUptimeUs, this.mStatsType);
        this.mTypeBatteryRealtime = this.mStats.computeBatteryRealtime(rawRealtimeUs, this.mStatsType);
        this.mBatteryTimeRemaining = this.mStats.computeBatteryTimeRemaining(rawRealtimeUs);
        this.mChargeTimeRemaining = this.mStats.computeChargeTimeRemaining(rawRealtimeUs);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(asUsers);
        for (i = 0; i < this.mUsageList.size(); ++i) {
            BatterySipper bs = this.mUsageList.get(i);
            bs.computeMobilemspp();
            if (bs.mobilemspp == 0.0) continue;
            this.mMobilemsppList.add(bs);
        }
        for (i = 0; i < this.mUserSippers.size(); ++i) {
            List<BatterySipper> user = this.mUserSippers.valueAt(i);
            for (int j = 0; j < user.size(); ++j) {
                BatterySipper bs = user.get(j);
                bs.computeMobilemspp();
                if (bs.mobilemspp == 0.0) continue;
                this.mMobilemsppList.add(bs);
            }
        }
        Collections.sort(this.mMobilemsppList, new Comparator<BatterySipper>(){

            @Override
            public int compare(BatterySipper lhs, BatterySipper rhs) {
                if (lhs.mobilemspp < rhs.mobilemspp) {
                    return 1;
                }
                if (lhs.mobilemspp > rhs.mobilemspp) {
                    return -1;
                }
                return 0;
            }
        });
        this.processMiscUsage();
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            if (this.mMinDrainedPower > this.mComputedPower) {
                double amount = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.UNACCOUNTED, 0L, amount);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                double amount = this.mComputedPower - this.mMaxDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.OVERCOUNTED, 0L, amount);
            }
        }
        Collections.sort(this.mUsageList);
    }

    private void processAppUsage(SparseArray<UserHandle> asUsers) {
        boolean forAllUsers = asUsers.get(-1) != null;
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        int which = this.mStatsType;
        int speedSteps = this.mPowerProfile.getNumSpeedSteps();
        double[] powerCpuNormal = new double[speedSteps];
        long[] cpuSpeedStepTimes = new long[speedSteps];
        for (int p = 0; p < speedSteps; ++p) {
            powerCpuNormal[p] = this.mPowerProfile.getAveragePower("cpu.active", p);
        }
        double mobilePowerPerPacket = this.getMobilePowerPerPacket();
        double mobilePowerPerMs = this.getMobilePowerPerMs();
        double wifiPowerPerPacket = this.getWifiPowerPerPacket();
        long appWakelockTimeUs = 0L;
        BatterySipper osApp = null;
        this.mStatsPeriod = this.mTypeBatteryRealtime;
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        int NU = uidStats.size();
        for (int iu = 0; iu < NU; ++iu) {
            BatteryStats.Uid u = uidStats.valueAt(iu);
            double power = 0.0;
            double highestDrain = 0.0;
            String packageWithHighestDrain = null;
            Map<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
            long cpuTime = 0L;
            long cpuFgTime = 0L;
            long wakelockTime = 0L;
            long gpsTime = 0L;
            if (processStats.size() > 0) {
                for (Map.Entry<String, ? extends BatteryStats.Uid.Proc> ent : processStats.entrySet()) {
                    BatteryStats.Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    long foregroundTime = ps.getForegroundTime(which);
                    cpuFgTime += foregroundTime * 10L;
                    long tmpCpuTime = (userTime + systemTime) * 10L;
                    int totalTimeAtSpeeds = 0;
                    for (int step = 0; step < speedSteps; ++step) {
                        cpuSpeedStepTimes[step] = ps.getTimeAtCpuSpeedStep(step, which);
                        totalTimeAtSpeeds = (int)((long)totalTimeAtSpeeds + cpuSpeedStepTimes[step]);
                    }
                    if (totalTimeAtSpeeds == 0) {
                        totalTimeAtSpeeds = 1;
                    }
                    double processPower = 0.0;
                    for (int step = 0; step < speedSteps; ++step) {
                        double ratio = (double)cpuSpeedStepTimes[step] / (double)totalTimeAtSpeeds;
                        processPower += ratio * (double)tmpCpuTime * powerCpuNormal[step];
                    }
                    cpuTime += tmpCpuTime;
                    power += processPower;
                    if (packageWithHighestDrain == null || packageWithHighestDrain.startsWith("*")) {
                        highestDrain = processPower;
                        packageWithHighestDrain = ent.getKey();
                        continue;
                    }
                    if (!(highestDrain < processPower) || ent.getKey().startsWith("*")) continue;
                    highestDrain = processPower;
                    packageWithHighestDrain = ent.getKey();
                }
            }
            if (cpuFgTime > cpuTime) {
                cpuTime = cpuFgTime;
            }
            power /= 3600000.0;
            Map<String, ? extends BatteryStats.Uid.Wakelock> wakelockStats = u.getWakelockStats();
            for (Map.Entry<String, ? extends BatteryStats.Uid.Wakelock> wakelockEntry : wakelockStats.entrySet()) {
                BatteryStats.Uid.Wakelock wakelock = wakelockEntry.getValue();
                BatteryStats.Timer timer = wakelock.getWakeTime(0);
                if (timer == null) continue;
                wakelockTime += timer.getTotalTimeLocked(this.mRawRealtime, which);
            }
            appWakelockTimeUs += wakelockTime;
            double p = (double)(wakelockTime /= 1000L) * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
            power += p;
            long mobileRx = u.getNetworkActivityPackets(0, this.mStatsType);
            long mobileTx = u.getNetworkActivityPackets(1, this.mStatsType);
            long mobileRxB = u.getNetworkActivityBytes(0, this.mStatsType);
            long mobileTxB = u.getNetworkActivityBytes(1, this.mStatsType);
            long mobileActive = u.getMobileRadioActiveTime(this.mStatsType);
            if (mobileActive > 0L) {
                this.mAppMobileActive += mobileActive;
                p = mobilePowerPerMs * (double)mobileActive / 1000.0;
            } else {
                p = (double)(mobileRx + mobileTx) * mobilePowerPerPacket;
            }
            power += p;
            long wifiRx = u.getNetworkActivityPackets(2, this.mStatsType);
            long wifiTx = u.getNetworkActivityPackets(3, this.mStatsType);
            long wifiRxB = u.getNetworkActivityBytes(2, this.mStatsType);
            long wifiTxB = u.getNetworkActivityBytes(3, this.mStatsType);
            p = (double)(wifiRx + wifiTx) * wifiPowerPerPacket;
            power += p;
            long wifiRunningTimeMs = u.getWifiRunningTime(this.mRawRealtime, which) / 1000L;
            this.mAppWifiRunning += wifiRunningTimeMs;
            p = (double)wifiRunningTimeMs * this.mPowerProfile.getAveragePower("wifi.on") / 3600000.0;
            power += p;
            long wifiScanTimeMs = u.getWifiScanTime(this.mRawRealtime, which) / 1000L;
            p = (double)wifiScanTimeMs * this.mPowerProfile.getAveragePower("wifi.scan") / 3600000.0;
            power += p;
            for (int bin = 0; bin < 5; ++bin) {
                long batchScanTimeMs = u.getWifiBatchedScanTime(bin, this.mRawRealtime, which) / 1000L;
                p = (double)batchScanTimeMs * this.mPowerProfile.getAveragePower("wifi.batchedscan", bin) / 3600000.0;
                power += p;
            }
            SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
            int NSE = sensorStats.size();
            for (int ise = 0; ise < NSE; ++ise) {
                BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
                int sensorHandle = sensorStats.keyAt(ise);
                BatteryStats.Timer timer = sensor.getSensorTime();
                long sensorTime = timer.getTotalTimeLocked(this.mRawRealtime, which) / 1000L;
                double multiplier = 0.0;
                block0 : switch (sensorHandle) {
                    case -10000: {
                        multiplier = this.mPowerProfile.getAveragePower("gps.on");
                        gpsTime = sensorTime;
                        break;
                    }
                    default: {
                        List<Sensor> sensorList = sensorManager.getSensorList(-1);
                        for (Sensor s : sensorList) {
                            if (s.getHandle() != sensorHandle) continue;
                            multiplier = s.getPower();
                            break block0;
                        }
                    }
                }
                p = multiplier * (double)sensorTime / 3600000.0;
                power += p;
            }
            int userId = UserHandle.getUserId(u.getUid());
            if (power == 0.0 && u.getUid() != 0) continue;
            BatterySipper app = new BatterySipper(BatterySipper.DrainType.APP, u, new double[]{power});
            app.cpuTime = cpuTime;
            app.gpsTime = gpsTime;
            app.wifiRunningTime = wifiRunningTimeMs;
            app.cpuFgTime = cpuFgTime;
            app.wakeLockTime = wakelockTime;
            app.mobileRxPackets = mobileRx;
            app.mobileTxPackets = mobileTx;
            app.mobileActive = mobileActive / 1000L;
            app.mobileActiveCount = u.getMobileRadioActiveCount(this.mStatsType);
            app.wifiRxPackets = wifiRx;
            app.wifiTxPackets = wifiTx;
            app.mobileRxBytes = mobileRxB;
            app.mobileTxBytes = mobileTxB;
            app.wifiRxBytes = wifiRxB;
            app.wifiTxBytes = wifiTxB;
            app.packageWithHighestDrain = packageWithHighestDrain;
            if (u.getUid() == 1010) {
                this.mWifiSippers.add(app);
                this.mWifiPower += power;
            } else if (u.getUid() == 1002) {
                this.mBluetoothSippers.add(app);
                this.mBluetoothPower += power;
            } else if (!forAllUsers && asUsers.get(userId) == null && UserHandle.getAppId(u.getUid()) >= 10000) {
                List<BatterySipper> list = this.mUserSippers.get(userId);
                if (list == null) {
                    list = new ArrayList<BatterySipper>();
                    this.mUserSippers.put(userId, list);
                }
                list.add(app);
                if (power != 0.0) {
                    Double userPower = this.mUserPower.get(userId);
                    userPower = userPower == null ? Double.valueOf(power) : Double.valueOf(userPower + power);
                    this.mUserPower.put(userId, userPower);
                }
            } else {
                this.mUsageList.add(app);
                if (power > this.mMaxPower) {
                    this.mMaxPower = power;
                }
                if (power > this.mMaxRealPower) {
                    this.mMaxRealPower = power;
                }
                this.mComputedPower += power;
            }
            if (u.getUid() != 0) continue;
            osApp = app;
        }
        if (osApp != null) {
            long wakeTimeMillis = this.mBatteryUptime / 1000L;
            if ((wakeTimeMillis -= appWakelockTimeUs / 1000L + this.mStats.getScreenOnTime(this.mRawRealtime, which) / 1000L) > 0L) {
                double power = (double)wakeTimeMillis * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
                osApp.wakeLockTime += wakeTimeMillis;
                osApp.value += power;
                osApp.values[0] = osApp.values[0] + power;
                if (osApp.value > this.mMaxPower) {
                    this.mMaxPower = osApp.value;
                }
                if (osApp.value > this.mMaxRealPower) {
                    this.mMaxRealPower = osApp.value;
                }
                this.mComputedPower += power;
            }
        }
    }

    private void addPhoneUsage() {
        long phoneOnTimeMs = this.mStats.getPhoneOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double phoneOnPower = this.mPowerProfile.getAveragePower("radio.active") * (double)phoneOnTimeMs / 3600000.0;
        if (phoneOnPower != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.PHONE, phoneOnTimeMs, phoneOnPower);
        }
    }

    private void addScreenUsage() {
        double power = 0.0;
        long screenOnTimeMs = this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        power += (double)screenOnTimeMs * this.mPowerProfile.getAveragePower("screen.on");
        double screenFullPower = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            double screenBinPower = screenFullPower * (double)((float)i + 0.5f) / 5.0;
            long brightnessTime = this.mStats.getScreenBrightnessTime(i, this.mRawRealtime, this.mStatsType) / 1000L;
            double p = screenBinPower * (double)brightnessTime;
            power += p;
        }
        if ((power /= 3600000.0) != 0.0) {
            this.addEntry(BatterySipper.DrainType.SCREEN, screenOnTimeMs, power);
        }
    }

    private void addRadioUsage() {
        double power = 0.0;
        int BINS = 5;
        long signalTimeMs = 0L;
        long noCoverageTimeMs = 0L;
        for (int i = 0; i < 5; ++i) {
            long strengthTimeMs = this.mStats.getPhoneSignalStrengthTime(i, this.mRawRealtime, this.mStatsType) / 1000L;
            double p = (double)strengthTimeMs * this.mPowerProfile.getAveragePower("radio.on", i) / 3600000.0;
            power += p;
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            noCoverageTimeMs = strengthTimeMs;
        }
        long scanningTimeMs = this.mStats.getPhoneSignalScanningTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double p = (double)scanningTimeMs * this.mPowerProfile.getAveragePower("radio.scanning") / 3600000.0;
        power += p;
        long radioActiveTimeUs = this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType);
        long remainingActiveTime = (radioActiveTimeUs - this.mAppMobileActive) / 1000L;
        if (remainingActiveTime > 0L) {
            power += this.getMobilePowerPerMs() * (double)remainingActiveTime;
        }
        if (power != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.CELL, signalTimeMs, power);
            if (signalTimeMs != 0L) {
                bs.noCoveragePercent = (double)noCoverageTimeMs * 100.0 / (double)signalTimeMs;
            }
            bs.mobileActive = remainingActiveTime;
            bs.mobileActiveCount = this.mStats.getMobileRadioActiveUnknownCount(this.mStatsType);
        }
    }

    private void aggregateSippers(BatterySipper bs, List<BatterySipper> from, String tag) {
        for (int i = 0; i < from.size(); ++i) {
            BatterySipper wbs = from.get(i);
            bs.cpuTime += wbs.cpuTime;
            bs.gpsTime += wbs.gpsTime;
            bs.wifiRunningTime += wbs.wifiRunningTime;
            bs.cpuFgTime += wbs.cpuFgTime;
            bs.wakeLockTime += wbs.wakeLockTime;
            bs.mobileRxPackets += wbs.mobileRxPackets;
            bs.mobileTxPackets += wbs.mobileTxPackets;
            bs.mobileActive += wbs.mobileActive;
            bs.mobileActiveCount += wbs.mobileActiveCount;
            bs.wifiRxPackets += wbs.wifiRxPackets;
            bs.wifiTxPackets += wbs.wifiTxPackets;
            bs.mobileRxBytes += wbs.mobileRxBytes;
            bs.mobileTxBytes += wbs.mobileTxBytes;
            bs.wifiRxBytes += wbs.wifiRxBytes;
            bs.wifiTxBytes += wbs.wifiTxBytes;
        }
        bs.computeMobilemspp();
    }

    private void addWiFiUsage() {
        double wifiPower;
        long onTimeMs = this.mStats.getWifiOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        long runningTimeMs = this.mStats.getGlobalWifiRunningTime(this.mRawRealtime, this.mStatsType) / 1000L;
        if ((runningTimeMs -= this.mAppWifiRunning) < 0L) {
            runningTimeMs = 0L;
        }
        if ((wifiPower = ((double)(onTimeMs * 0L) * this.mPowerProfile.getAveragePower("wifi.on") + (double)runningTimeMs * this.mPowerProfile.getAveragePower("wifi.on")) / 3600000.0) + this.mWifiPower != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.WIFI, runningTimeMs, wifiPower + this.mWifiPower);
            this.aggregateSippers(bs, this.mWifiSippers, "WIFI");
        }
    }

    private void addIdleUsage() {
        long idleTimeMs = (this.mTypeBatteryRealtime - this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType)) / 1000L;
        double idlePower = (double)idleTimeMs * this.mPowerProfile.getAveragePower("cpu.idle") / 3600000.0;
        if (idlePower != 0.0) {
            this.addEntry(BatterySipper.DrainType.IDLE, idleTimeMs, idlePower);
        }
    }

    private void addBluetoothUsage() {
        long btOnTimeMs = this.mStats.getBluetoothOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double btPower = (double)btOnTimeMs * this.mPowerProfile.getAveragePower("bluetooth.on") / 3600000.0;
        int btPingCount = this.mStats.getBluetoothPingCount();
        double pingPower = (double)btPingCount * this.mPowerProfile.getAveragePower("bluetooth.at") / 3600000.0;
        if ((btPower += pingPower) + this.mBluetoothPower != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.BLUETOOTH, btOnTimeMs, btPower + this.mBluetoothPower);
            this.aggregateSippers(bs, this.mBluetoothSippers, "Bluetooth");
        }
    }

    private void addFlashlightUsage() {
        long flashlightOnTimeMs = this.mStats.getFlashlightOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double flashlightPower = (double)flashlightOnTimeMs * this.mPowerProfile.getAveragePower("camera.flashlight") / 3600000.0;
        if (flashlightPower != 0.0) {
            this.addEntry(BatterySipper.DrainType.FLASHLIGHT, flashlightOnTimeMs, flashlightPower);
        }
    }

    private void addUserUsage() {
        for (int i = 0; i < this.mUserSippers.size(); ++i) {
            int userId = this.mUserSippers.keyAt(i);
            List<BatterySipper> sippers = this.mUserSippers.valueAt(i);
            Double userPower = this.mUserPower.get(userId);
            double power = userPower != null ? userPower : 0.0;
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.USER, 0L, power);
            bs.userId = userId;
            this.aggregateSippers(bs, sippers, "User");
        }
    }

    private double getMobilePowerPerPacket() {
        long MOBILE_BPS = 200000L;
        double MOBILE_POWER = this.mPowerProfile.getAveragePower("radio.active") / 3600.0;
        long mobileRx = this.mStats.getNetworkActivityPackets(0, this.mStatsType);
        long mobileTx = this.mStats.getNetworkActivityPackets(1, this.mStatsType);
        long mobileData = mobileRx + mobileTx;
        long radioDataUptimeMs = this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double mobilePps = mobileData != 0L && radioDataUptimeMs != 0L ? (double)mobileData / (double)radioDataUptimeMs : 12.20703125;
        return MOBILE_POWER / mobilePps / 3600.0;
    }

    private double getMobilePowerPerMs() {
        return this.mPowerProfile.getAveragePower("radio.active") / 3600000.0;
    }

    private double getWifiPowerPerPacket() {
        long WIFI_BPS = 1000000L;
        double WIFI_POWER = this.mPowerProfile.getAveragePower("wifi.active") / 3600.0;
        return WIFI_POWER / 61.03515625 / 3600.0;
    }

    private void processMiscUsage() {
        this.addUserUsage();
        this.addPhoneUsage();
        this.addScreenUsage();
        this.addFlashlightUsage();
        this.addWiFiUsage();
        this.addBluetoothUsage();
        this.addIdleUsage();
        if (!this.mWifiOnly) {
            this.addRadioUsage();
        }
    }

    private BatterySipper addEntry(BatterySipper.DrainType drainType, long time, double power) {
        this.mComputedPower += power;
        if (power > this.mMaxRealPower) {
            this.mMaxRealPower = power;
        }
        return this.addEntryNoTotal(drainType, time, power);
    }

    private BatterySipper addEntryNoTotal(BatterySipper.DrainType drainType, long time, double power) {
        if (power > this.mMaxPower) {
            this.mMaxPower = power;
        }
        BatterySipper bs = new BatterySipper(drainType, null, new double[]{power});
        bs.usageTime = time;
        this.mUsageList.add(bs);
        return bs;
    }

    public List<BatterySipper> getUsageList() {
        return this.mUsageList;
    }

    public List<BatterySipper> getMobilemsppList() {
        return this.mMobilemsppList;
    }

    public long getStatsPeriod() {
        return this.mStatsPeriod;
    }

    public int getStatsType() {
        return this.mStatsType;
    }

    public double getMaxPower() {
        return this.mMaxPower;
    }

    public double getMaxRealPower() {
        return this.mMaxRealPower;
    }

    public double getTotalPower() {
        return this.mTotalPower;
    }

    public double getComputedPower() {
        return this.mComputedPower;
    }

    public double getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    public double getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    public long getBatteryTimeRemaining() {
        return this.mBatteryTimeRemaining;
    }

    public long getChargeTimeRemaining() {
        return this.mChargeTimeRemaining;
    }

    public static byte[] readFully(FileInputStream stream) throws IOException {
        return BatteryStatsHelper.readFully(stream, stream.available());
    }

    public static byte[] readFully(FileInputStream stream, int avail) throws IOException {
        int pos = 0;
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy((byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
        return data;
    }

    private void load() {
        if (this.mBatteryInfo == null) {
            return;
        }
        this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo);
        if (this.mCollectBatteryBroadcast) {
            this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    private static BatteryStatsImpl getStats(IBatteryStats service) {
        try {
            ParcelFileDescriptor pfd = service.getStatisticsStream();
            if (pfd != null) {
                ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
                try {
                    byte[] data = BatteryStatsHelper.readFully(fis, MemoryFile.getSize(pfd.getFileDescriptor()));
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    BatteryStatsImpl stats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                    stats.distributeWorkLocked(0);
                    return stats;
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read statistics stream", e);
                }
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException:", e);
        }
        return new BatteryStatsImpl();
    }

    static {
        sFileXfer = new ArrayMap();
    }
}

