/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePickerController;
import android.widget.ListView;
import android.widget.OnDateChangedListener;
import android.widget.TextViewWithCircularIndicator;

class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
OnDateChangedListener {
    private DatePickerController mController;
    private YearAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private int mSelectedPosition = -1;
    private int mYearSelectedCircleColor;

    public YearPickerView(Context context) {
        this(context, null);
    }

    public YearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842868);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        AbsListView.LayoutParams frame = new AbsListView.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(17105036);
        this.mChildSize = res.getDimensionPixelOffset(17105038);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        int paddingTop = res.getDimensionPixelSize(17105037);
        this.setPadding(0, paddingTop, 0, 0);
        this.setOnItemClickListener(this);
        this.setDividerHeight(0);
    }

    public void init(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mAdapter = new YearAdapter(this.getContext(), 17367279);
        this.updateAdapterData();
        this.setAdapter(this.mAdapter);
        this.onDateChanged();
    }

    public void setYearSelectedCircleColor(int color2) {
        if (color2 != this.mYearSelectedCircleColor) {
            this.mYearSelectedCircleColor = color2;
        }
        this.requestLayout();
    }

    public int getYearSelectedCircleColor() {
        return this.mYearSelectedCircleColor;
    }

    private void updateAdapterData() {
        this.mAdapter.clear();
        int maxYear = this.mController.getMaxYear();
        for (int year = this.mController.getMinYear(); year <= maxYear; ++year) {
            this.mAdapter.add(year);
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        if (position != this.mSelectedPosition) {
            this.mSelectedPosition = position;
            this.mAdapter.notifyDataSetChanged();
        }
        this.mController.onYearSelected((Integer)this.mAdapter.getItem(position));
    }

    void setItemTextAppearance(int resId) {
        this.mAdapter.setItemTextAppearance(resId);
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelectionFromTop(position, offset);
                YearPickerView.this.requestLayout();
            }
        });
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.updateAdapterData();
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().get(1) - this.mController.getMinYear());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    private class YearAdapter
    extends ArrayAdapter<Integer> {
        int mItemTextAppearanceResId;

        public YearAdapter(Context context, int resource) {
            super(context, resource);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextViewWithCircularIndicator v = (TextViewWithCircularIndicator)super.getView(position, convertView, parent);
            v.setTextAppearance(this.getContext(), this.mItemTextAppearanceResId);
            v.requestLayout();
            int year = (Integer)this.getItem(position);
            boolean selected = YearPickerView.this.mController.getSelectedDay().get(1) == year;
            v.setDrawIndicator(selected);
            if (selected) {
                v.setCircleColor(YearPickerView.this.mYearSelectedCircleColor);
            }
            return v;
        }

        public void setItemTextAppearance(int resId) {
            this.mItemTextAppearanceResId = resId;
        }
    }
}

