/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RadialTimePickerView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

class TimePickerSpinnerDelegate
extends TimePicker.AbstractTimePickerDelegate
implements RadialTimePickerView.OnValueSelectedListener {
    private static final String TAG = "TimePickerDelegate";
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int AMPM_INDEX = 2;
    private static final int ENABLE_PICKER_INDEX = 3;
    private static final int AM = 0;
    private static final int PM = 1;
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private boolean mIsEnabled = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private View mHeaderView;
    private TextView mHourView;
    private TextView mMinuteView;
    private TextView mAmPmTextView;
    private RadialTimePickerView mRadialTimePickerView;
    private TextView mSeparatorView;
    private String mAmText;
    private String mPmText;
    private boolean mAllowAutoAdvance;
    private int mInitialHourOfDay;
    private int mInitialMinute;
    private boolean mIs24HourView;
    private char mPlaceholderText;
    private String mDoublePlaceholderText;
    private String mDeletedKeyFormat;
    private boolean mInKbMode;
    private ArrayList<Integer> mTypedTimes = new ArrayList();
    private Node mLegalTimesTree;
    private int mAmKeyCode;
    private int mPmKeyCode;
    private String mHourPickerDescription;
    private String mSelectHours;
    private String mMinutePickerDescription;
    private String mSelectMinutes;
    private Calendar mTempCalendar;
    private final View.OnKeyListener mKeyListener = new View.OnKeyListener(){

        @Override
        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 1) {
                return TimePickerSpinnerDelegate.this.processKeyUp(keyCode);
            }
            return false;
        }
    };
    private final View.OnFocusChangeListener mFocusListener = new View.OnFocusChangeListener(){

        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            if (!hasFocus && TimePickerSpinnerDelegate.this.mInKbMode && TimePickerSpinnerDelegate.this.isTypedTimeFullyLegal()) {
                TimePickerSpinnerDelegate.this.finishKbMode();
                if (TimePickerSpinnerDelegate.this.mOnTimeChangedListener != null) {
                    TimePickerSpinnerDelegate.this.mOnTimeChangedListener.onTimeChanged(TimePickerSpinnerDelegate.this.mDelegator, TimePickerSpinnerDelegate.this.mRadialTimePickerView.getCurrentHour(), TimePickerSpinnerDelegate.this.mRadialTimePickerView.getCurrentMinute());
                }
            }
        }
    };

    public TimePickerSpinnerDelegate(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mHourPickerDescription = res.getString(17040995);
        this.mSelectHours = res.getString(17040997);
        this.mMinutePickerDescription = res.getString(17040996);
        this.mSelectMinutes = res.getString(17040998);
        String[] amPmStrings = TimePickerClockDelegate.getAmPmStrings(context);
        this.mAmText = amPmStrings[0];
        this.mPmText = amPmStrings[1];
        int layoutResourceId = a.getResourceId(9, 17367264);
        View mainView = inflater.inflate(layoutResourceId, null);
        this.mDelegator.addView(mainView);
        this.mHourView = (TextView)mainView.findViewById(16909230);
        this.mSeparatorView = (TextView)mainView.findViewById(16909231);
        this.mMinuteView = (TextView)mainView.findViewById(16909232);
        this.mAmPmTextView = (TextView)mainView.findViewById(16909233);
        int headerTimeTextAppearance = a.getResourceId(1, 0);
        if (headerTimeTextAppearance != 0) {
            this.mHourView.setTextAppearance(context, headerTimeTextAppearance);
            this.mSeparatorView.setTextAppearance(context, headerTimeTextAppearance);
            this.mMinuteView.setTextAppearance(context, headerTimeTextAppearance);
        }
        int headerSelectedTextColor = a.getColor(11, res.getColor(17170669));
        this.mHourView.setTextColor(ColorStateList.addFirstIfMissing(this.mHourView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        this.mMinuteView.setTextColor(ColorStateList.addFirstIfMissing(this.mMinuteView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int headerAmPmTextAppearance = a.getResourceId(2, 0);
        if (headerAmPmTextAppearance != 0) {
            this.mAmPmTextView.setTextAppearance(context, headerAmPmTextAppearance);
        }
        this.mHeaderView = mainView.findViewById(16909229);
        this.mHeaderView.setBackground(a.getDrawable(0));
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(16909235);
        this.setupListeners();
        this.mAllowAutoAdvance = true;
        this.mDoublePlaceholderText = res.getString(17041006);
        this.mDeletedKeyFormat = res.getString(17041004);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        Calendar calendar = Calendar.getInstance(this.mCurrentLocale);
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.initialize(currentHour, currentMinute, false, 0);
    }

    private void initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.mInKbMode = false;
        this.updateUI(index);
    }

    private void setupListeners() {
        this.mHeaderView.setOnKeyListener(this.mKeyListener);
        this.mHeaderView.setOnFocusChangeListener(this.mFocusListener);
        this.mHeaderView.setFocusable(true);
        this.mRadialTimePickerView.setOnValueSelectedListener(this);
        this.mHourView.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                TimePickerSpinnerDelegate.this.setCurrentItemShowing(0, true, true);
                TimePickerSpinnerDelegate.this.tryVibrate();
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                TimePickerSpinnerDelegate.this.setCurrentItemShowing(1, true, true);
                TimePickerSpinnerDelegate.this.tryVibrate();
            }
        });
    }

    private void updateUI(int index) {
        this.updateRadialPicker(index);
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mInitialHourOfDay, true);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mInitialMinute);
        this.mDelegator.invalidate();
    }

    private void updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mInitialHourOfDay, this.mInitialMinute, this.mIs24HourView);
        this.setCurrentItemShowing(index, false, true);
    }

    private int computeMaxWidthOfNumbers(int max) {
        TextView tempView = new TextView(this.mContext);
        tempView.setTextAppearance(this.mContext, 16974879);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        tempView.setLayoutParams(lp);
        int maxWidth = 0;
        for (int minutes = 0; minutes < max; ++minutes) {
            String text = String.format("%02d", minutes);
            tempView.setText(text);
            tempView.measure(0, 0);
            maxWidth = Math.max(maxWidth, tempView.getMeasuredWidth());
        }
        return maxWidth;
    }

    private void updateHeaderAmPm() {
        if (this.mIs24HourView) {
            this.mAmPmTextView.setVisibility(8);
        } else {
            this.mAmPmTextView.setVisibility(0);
            String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm");
            boolean amPmOnLeft = bestDateTimePattern.startsWith("a");
            if (TextUtils.getLayoutDirectionFromLocale(this.mCurrentLocale) == 1) {
                amPmOnLeft = !amPmOnLeft;
            }
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mAmPmTextView.getLayoutParams();
            if (amPmOnLeft) {
                layoutParams.rightMargin = this.computeMaxWidthOfNumbers(12);
                layoutParams.removeRule(1);
                layoutParams.addRule(0, 16909231);
            } else {
                layoutParams.leftMargin = this.computeMaxWidthOfNumbers(60);
                layoutParams.removeRule(0);
                layoutParams.addRule(1, 16909231);
            }
            this.updateAmPmDisplay(this.mInitialHourOfDay < 12 ? 0 : 1);
            this.mAmPmTextView.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    TimePickerSpinnerDelegate.this.tryVibrate();
                    int amOrPm = TimePickerSpinnerDelegate.this.mRadialTimePickerView.getAmOrPm();
                    if (amOrPm == 0) {
                        amOrPm = 1;
                    } else if (amOrPm == 1) {
                        amOrPm = 0;
                    }
                    TimePickerSpinnerDelegate.this.updateAmPmDisplay(amOrPm);
                    TimePickerSpinnerDelegate.this.mRadialTimePickerView.setAmOrPm(amOrPm);
                }
            });
        }
    }

    @Override
    public void setCurrentHour(Integer currentHour) {
        if (this.mInitialHourOfDay == currentHour) {
            return;
        }
        this.mInitialHourOfDay = currentHour;
        this.updateHeaderHour(currentHour, true);
        this.updateHeaderAmPm();
        this.mRadialTimePickerView.setCurrentHour(currentHour);
        this.mRadialTimePickerView.setAmOrPm(this.mInitialHourOfDay < 12 ? 0 : 1);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public Integer getCurrentHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24HourView) {
            return currentHour;
        }
        switch (this.mRadialTimePickerView.getAmOrPm()) {
            case 1: {
                return currentHour % 12 + 12;
            }
        }
        return currentHour % 12;
    }

    @Override
    public void setCurrentMinute(Integer currentMinute) {
        if (this.mInitialMinute == currentMinute) {
            return;
        }
        this.mInitialMinute = currentMinute;
        this.updateHeaderMinute(currentMinute);
        this.mRadialTimePickerView.setCurrentMinute(currentMinute);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public Integer getCurrentMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    @Override
    public void setIs24HourView(Boolean is24HourView) {
        int hour;
        if (is24HourView == this.mIs24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        this.generateLegalTimesTree();
        this.mInitialHourOfDay = hour = this.mRadialTimePickerView.getCurrentHour();
        this.updateHeaderHour(hour, false);
        this.updateHeaderAmPm();
        this.updateRadialPicker(this.mRadialTimePickerView.getCurrentItemShowing());
        this.mDelegator.invalidate();
    }

    @Override
    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener callback) {
        this.mOnTimeChangedListener = callback;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmPmTextView.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute(), this.is24HourView(), this.inKbMode(), this.getTypedTimes(), this.getCurrentItemShowing());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setInKbMode(ss.inKbMode());
        this.setTypedTimes(ss.getTypesTimes());
        this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
        this.mRadialTimePickerView.invalidate();
        if (this.mInKbMode) {
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        }
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDate = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDate);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(TimePicker.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setClassName(TimePicker.class.getName());
    }

    private void setInKbMode(boolean inKbMode) {
        this.mInKbMode = inKbMode;
    }

    private boolean inKbMode() {
        return this.mInKbMode;
    }

    private void setTypedTimes(ArrayList<Integer> typeTimes) {
        this.mTypedTimes = typeTimes;
    }

    private ArrayList<Integer> getTypedTimes() {
        return this.mTypedTimes;
    }

    private int getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private void updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 0) {
            this.mAmPmTextView.setText(this.mAmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mAmText);
        } else if (amOrPm == 1) {
            this.mAmPmTextView.setText(this.mPmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mPmText);
        } else {
            this.mAmPmTextView.setText(this.mDoublePlaceholderText);
        }
    }

    @Override
    public void onValueSelected(int pickerIndex, int newValue, boolean autoAdvance) {
        if (pickerIndex == 0) {
            this.updateHeaderHour(newValue, false);
            String announcement = String.format("%d", newValue);
            if (this.mAllowAutoAdvance && autoAdvance) {
                this.setCurrentItemShowing(1, true, false);
                announcement = announcement + ". " + this.mSelectMinutes;
            } else {
                this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + newValue);
            }
            this.mRadialTimePickerView.announceForAccessibility(announcement);
        } else if (pickerIndex == 1) {
            this.updateHeaderMinute(newValue);
            this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + newValue);
        } else if (pickerIndex == 2) {
            this.updateAmPmDisplay(newValue);
        } else if (pickerIndex == 3) {
            if (!this.isTypedTimeFullyLegal()) {
                this.mTypedTimes.clear();
            }
            this.finishKbMode();
        }
    }

    private void updateHeaderHour(int value, boolean announce) {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean hourWithTwoDigit = false;
        char hourFormat = '\u0000';
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            hourWithTwoDigit = true;
            break;
        }
        String format = hourWithTwoDigit ? "%02d" : "%d";
        if (this.mIs24HourView) {
            if (hourFormat == 'k' && value == 0) {
                value = 24;
            }
        } else {
            value = TimePickerSpinnerDelegate.modulo12(value, hourFormat == 'K');
        }
        String text = String.format(format, value);
        this.mHourView.setText(text);
        if (announce) {
            this.mRadialTimePickerView.announceForAccessibility(text);
        }
    }

    private static int modulo12(int n, boolean startWithZero) {
        int value = n % 12;
        if (value == 0 && !startWithZero) {
            value = 12;
        }
        return value;
    }

    private void updateHeaderSeparator() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
        int hIndex = TimePickerSpinnerDelegate.lastIndexOfAny(bestDateTimePattern, hourFormats);
        String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
        this.mSeparatorView.setText(separatorText);
    }

    private static int lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void updateHeaderMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(this.mCurrentLocale, "%02d", value);
        this.mRadialTimePickerView.announceForAccessibility(text);
        this.mMinuteView.setText(text);
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            int hours = this.mRadialTimePickerView.getCurrentHour();
            if (!this.mIs24HourView) {
                hours %= 12;
            }
            this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + hours);
            if (announce) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectHours);
            }
        } else {
            int minutes = this.mRadialTimePickerView.getCurrentMinute();
            this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + minutes);
            if (announce) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectMinutes);
            }
        }
        this.mHourView.setSelected(index == 0);
        this.mMinuteView.setSelected(index == 1);
    }

    private boolean processKeyUp(int keyCode) {
        if (keyCode == 67) {
            if (this.mInKbMode && !this.mTypedTimes.isEmpty()) {
                int deleted = this.deleteLastTypedKey();
                String deletedKeyStr = deleted == this.getAmOrPmKeyCode(0) ? this.mAmText : (deleted == this.getAmOrPmKeyCode(1) ? this.mPmText : String.format("%d", this.getValFromKeyCode(deleted)));
                this.mRadialTimePickerView.announceForAccessibility(String.format(this.mDeletedKeyFormat, deletedKeyStr));
                this.updateDisplay(true);
            }
        } else if (keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16 || !this.mIs24HourView && (keyCode == this.getAmOrPmKeyCode(0) || keyCode == this.getAmOrPmKeyCode(1))) {
            if (!this.mInKbMode) {
                if (this.mRadialTimePickerView == null) {
                    Log.e(TAG, "Unable to initiate keyboard mode, TimePicker was null.");
                    return true;
                }
                this.mTypedTimes.clear();
                this.tryStartingKbMode(keyCode);
                return true;
            }
            if (this.addKeyIfLegal(keyCode)) {
                this.updateDisplay(false);
            }
            return true;
        }
        return false;
    }

    private void tryStartingKbMode(int keyCode) {
        if (keyCode == -1 || this.addKeyIfLegal(keyCode)) {
            this.mInKbMode = true;
            this.onValidationChanged(false);
            this.updateDisplay(false);
            this.mRadialTimePickerView.setInputEnabled(false);
        }
    }

    private boolean addKeyIfLegal(int keyCode) {
        if (this.mIs24HourView && this.mTypedTimes.size() == 4 || !this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(keyCode);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int val = this.getValFromKeyCode(keyCode);
        this.mRadialTimePickerView.announceForAccessibility(String.format("%d", val));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourView && this.mTypedTimes.size() <= 3) {
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
            }
            this.onValidationChanged(true);
        }
        return true;
    }

    private boolean isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        for (int keyCode : this.mTypedTimes) {
            if ((node = node.canReach(keyCode)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isTypedTimeFullyLegal() {
        if (this.mIs24HourView) {
            int[] values = this.getEnteredTime(null);
            return values[0] >= 0 && values[1] >= 0 && values[1] < 60;
        }
        return this.mTypedTimes.contains(this.getAmOrPmKeyCode(0)) || this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
    }

    private int deleteLastTypedKey() {
        int deleted = this.mTypedTimes.remove(this.mTypedTimes.size() - 1);
        if (!this.isTypedTimeFullyLegal()) {
            this.onValidationChanged(false);
        }
        return deleted;
    }

    private void finishKbMode() {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] values = this.getEnteredTime(null);
            this.mRadialTimePickerView.setCurrentHour(values[0]);
            this.mRadialTimePickerView.setCurrentMinute(values[1]);
            if (!this.mIs24HourView) {
                this.mRadialTimePickerView.setAmOrPm(values[2]);
            }
            this.mTypedTimes.clear();
        }
        this.updateDisplay(false);
        this.mRadialTimePickerView.setInputEnabled(true);
    }

    private void updateDisplay(boolean allowEmptyDisplay) {
        if (!allowEmptyDisplay && this.mTypedTimes.isEmpty()) {
            int hour = this.mRadialTimePickerView.getCurrentHour();
            int minute = this.mRadialTimePickerView.getCurrentMinute();
            this.updateHeaderHour(hour, true);
            this.updateHeaderMinute(minute);
            if (!this.mIs24HourView) {
                this.updateAmPmDisplay(hour < 12 ? 0 : 1);
            }
            this.setCurrentItemShowing(this.mRadialTimePickerView.getCurrentItemShowing(), true, true);
            this.onValidationChanged(true);
        } else {
            boolean[] enteredZeros = new boolean[]{false, false};
            int[] values = this.getEnteredTime(enteredZeros);
            String hourFormat = enteredZeros[0] ? "%02d" : "%2d";
            String minuteFormat = enteredZeros[1] ? "%02d" : "%2d";
            String hourStr = values[0] == -1 ? this.mDoublePlaceholderText : String.format(hourFormat, values[0]).replace(' ', this.mPlaceholderText);
            String minuteStr = values[1] == -1 ? this.mDoublePlaceholderText : String.format(minuteFormat, values[1]).replace(' ', this.mPlaceholderText);
            this.mHourView.setText(hourStr);
            this.mHourView.setSelected(false);
            this.mMinuteView.setText(minuteStr);
            this.mMinuteView.setSelected(false);
            if (!this.mIs24HourView) {
                this.updateAmPmDisplay(values[2]);
            }
        }
    }

    private int getValFromKeyCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 9;
            }
        }
        return -1;
    }

    private int[] getEnteredTime(boolean[] enteredZeros) {
        int amOrPm = -1;
        int startIndex = 1;
        if (!this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            int keyCode = this.mTypedTimes.get(this.mTypedTimes.size() - 1);
            if (keyCode == this.getAmOrPmKeyCode(0)) {
                amOrPm = 0;
            } else if (keyCode == this.getAmOrPmKeyCode(1)) {
                amOrPm = 1;
            }
            startIndex = 2;
        }
        int minute = -1;
        int hour = -1;
        for (int i = startIndex; i <= this.mTypedTimes.size(); ++i) {
            int val = this.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - i));
            if (i == startIndex) {
                minute = val;
                continue;
            }
            if (i == startIndex + 1) {
                minute += 10 * val;
                if (enteredZeros == null || val != 0) continue;
                enteredZeros[1] = true;
                continue;
            }
            if (i == startIndex + 2) {
                hour = val;
                continue;
            }
            if (i != startIndex + 3) continue;
            hour += 10 * val;
            if (enteredZeros == null || val != 0) continue;
            enteredZeros[0] = true;
        }
        return new int[]{hour, minute, amOrPm};
    }

    private int getAmOrPmKeyCode(int amOrPm) {
        if (this.mAmKeyCode == -1 || this.mPmKeyCode == -1) {
            KeyCharacterMap kcm = KeyCharacterMap.load(-1);
            for (int i = 0; i < Math.max(this.mAmText.length(), this.mPmText.length()); ++i) {
                char pmChar;
                char amChar = this.mAmText.toLowerCase(this.mCurrentLocale).charAt(i);
                if (amChar == (pmChar = this.mPmText.toLowerCase(this.mCurrentLocale).charAt(i))) continue;
                KeyEvent[] events = kcm.getEvents(new char[]{amChar, pmChar});
                if (events != null && events.length == 4) {
                    this.mAmKeyCode = events[0].getKeyCode();
                    this.mPmKeyCode = events[2].getKeyCode();
                    break;
                }
                Log.e(TAG, "Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (amOrPm == 0) {
            return this.mAmKeyCode;
        }
        if (amOrPm == 1) {
            return this.mPmKeyCode;
        }
        return -1;
    }

    private void generateLegalTimesTree() {
        int k0 = 7;
        int k1 = 8;
        int k2 = 9;
        int k3 = 10;
        int k4 = 11;
        int k5 = 12;
        int k6 = 13;
        int k7 = 14;
        int k8 = 15;
        int k9 = 16;
        this.mLegalTimesTree = new Node(new int[0]);
        if (this.mIs24HourView) {
            Node minuteFirstDigit = new Node(7, 8, 9, 10, 11, 12);
            Node minuteSecondDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            minuteFirstDigit.addChild(minuteSecondDigit);
            Node firstDigit = new Node(7, 8);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            Node thirdDigit = new Node(13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            secondDigit = new Node(13, 14, 15, 16);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            firstDigit = new Node(9);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(7, 8, 9, 10);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            secondDigit = new Node(11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteSecondDigit);
            firstDigit = new Node(10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(minuteFirstDigit);
        } else {
            Node ampm = new Node(this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node firstDigit = new Node(8);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(7, 8, 9);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            Node thirdDigit = new Node(7, 8, 9, 10, 11, 12);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            Node fourthDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            thirdDigit.addChild(fourthDigit);
            fourthDigit.addChild(ampm);
            thirdDigit = new Node(13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            secondDigit = new Node(10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            firstDigit = new Node(9, 10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            secondDigit = new Node(7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
        }
    }

    private class Node {
        private int[] mLegalKeys;
        private ArrayList<Node> mChildren;

        public Node(int ... legalKeys) {
            this.mLegalKeys = legalKeys;
            this.mChildren = new ArrayList();
        }

        public void addChild(Node child) {
            this.mChildren.add(child);
        }

        public boolean containsKey(int key) {
            for (int i = 0; i < this.mLegalKeys.length; ++i) {
                if (this.mLegalKeys[i] != key) continue;
                return true;
            }
            return false;
        }

        public Node canReach(int key) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node child : this.mChildren) {
                if (!child.containsKey(key)) continue;
                return child;
            }
            return null;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        private final boolean mIs24HourMode;
        private final boolean mInKbMode;
        private final ArrayList<Integer> mTypedTimes;
        private final int mCurrentItemShowing;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute, boolean is24HourMode, boolean isKbMode, ArrayList<Integer> typedTimes, int currentItemShowing) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
            this.mIs24HourMode = is24HourMode;
            this.mInKbMode = isKbMode;
            this.mTypedTimes = typedTimes;
            this.mCurrentItemShowing = currentItemShowing;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
            this.mIs24HourMode = in.readInt() == 1;
            this.mInKbMode = in.readInt() == 1;
            this.mTypedTimes = in.readArrayList(this.getClass().getClassLoader());
            this.mCurrentItemShowing = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public boolean is24HourMode() {
            return this.mIs24HourMode;
        }

        public boolean inKbMode() {
            return this.mInKbMode;
        }

        public ArrayList<Integer> getTypesTimes() {
            return this.mTypedTimes;
        }

        public int getCurrentItemShowing() {
            return this.mCurrentItemShowing;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
            dest.writeInt(this.mIs24HourMode ? 1 : 0);
            dest.writeInt(this.mInKbMode ? 1 : 0);
            dest.writeList(this.mTypedTimes);
            dest.writeInt(this.mCurrentItemShowing);
        }
    }
}

