/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewFactoryProvider;
import com.android.server.LocalServices;
import dalvik.system.VMRuntime;
import java.io.File;
import java.util.Arrays;

public final class WebViewFactory {
    private static final String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static final String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    public static final String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static final long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static final String LOGTAG = "WebViewFactory";
    private static final boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static final Object sProviderLock;
    private static boolean sAddressSpaceReserved;
    private static PackageInfo sPackageInfo;

    public static String getWebViewPackageName() {
        return AppGlobals.getInitialApplication().getString(17039430);
    }

    public static PackageInfo getLoadedPackageInfo() {
        return sPackageInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    static WebViewFactoryProvider getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass;
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewFactory.loadNativeLibrary();
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "WebViewFactory.getFactoryClass()");
                try {
                    providerClass = WebViewFactory.getFactoryClass();
                }
                catch (ClassNotFoundException e) {
                    Log.e(LOGTAG, "error loading provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                }
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                Trace.traceBegin(16L, "providerClass.newInstance()");
                try {
                    webViewFactoryProvider = sProviderInstance = providerClass.newInstance();
                }
                catch (Exception e) {
                    Log.e(LOGTAG, "error instantiating provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                    StrictMode.setThreadPolicy(oldPolicy);
                }
                return webViewFactoryProvider;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<WebViewFactoryProvider> getFactoryClass() throws ClassNotFoundException {
        Class<WebViewFactoryProvider> clazz;
        Application initialApplication = AppGlobals.getInitialApplication();
        String packageName = WebViewFactory.getWebViewPackageName();
        sPackageInfo = initialApplication.getPackageManager().getPackageInfo(packageName, 0);
        Log.i(LOGTAG, "Loading " + packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
        Context webViewContext = initialApplication.createPackageContext(packageName, 3);
        initialApplication.getAssets().addAssetPath(webViewContext.getApplicationInfo().sourceDir);
        ClassLoader clazzLoader = webViewContext.getClassLoader();
        Trace.traceBegin(16L, "Class.forName()");
        try {
            clazz = Class.forName(CHROMIUM_WEBVIEW_FACTORY, true, clazzLoader);
        }
        catch (Throwable throwable) {
            try {
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException e) {
                try {
                    return Class.forName(NULL_WEBVIEW_FACTORY);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.e(LOGTAG, "Chromium WebView package does not exist", e);
                    throw new AndroidRuntimeException(e);
                }
            }
        }
        Trace.traceEnd(16L);
        return clazz;
    }

    public static void prepareWebViewInZygote() {
        try {
            System.loadLibrary("webviewchromium_loader");
            long addressSpaceToReserve = SystemProperties.getLong(CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY, 0x6400000L);
            sAddressSpaceReserved = WebViewFactory.nativeReserveAddressSpace(addressSpaceToReserve);
            if (!sAddressSpaceReserved) {
                Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing native loader", t);
        }
    }

    public static void prepareWebViewInSystemServer() {
        String[] nativePaths = null;
        try {
            nativePaths = WebViewFactory.getWebViewNativeLibraryPaths();
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing webview native library", t);
        }
        WebViewFactory.prepareWebViewInSystemServer(nativePaths);
    }

    private static void prepareWebViewInSystemServer(String[] nativeLibraryPaths) {
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(false, nativeLibraryPaths);
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(true, nativeLibraryPaths);
        }
    }

    public static void onWebViewUpdateInstalled() {
        String[] nativeLibs = null;
        try {
            nativeLibs = WebViewFactory.getWebViewNativeLibraryPaths();
            if (nativeLibs != null) {
                long newVmSize = 0L;
                for (String path : nativeLibs) {
                    long length;
                    File f;
                    if (path == null || !(f = new File(path)).exists() || (length = f.length()) <= newVmSize) continue;
                    newVmSize = length;
                }
                newVmSize = Math.max(2L * newVmSize, 0x6400000L);
                Log.d(LOGTAG, "Setting new address space to " + newVmSize);
                SystemProperties.set(CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY, Long.toString(newVmSize));
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing webview native library", t);
        }
        WebViewFactory.prepareWebViewInSystemServer(nativeLibs);
    }

    private static String[] getWebViewNativeLibraryPaths() throws PackageManager.NameNotFoundException {
        String path32;
        String path64;
        String NATIVE_LIB_FILE_NAME = "libwebviewchromium.so";
        PackageManager pm = AppGlobals.getInitialApplication().getPackageManager();
        ApplicationInfo ai = pm.getApplicationInfo(WebViewFactory.getWebViewPackageName(), 0);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi((String)ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32)) {
            path32 = path32 + "/libwebviewchromium.so";
        }
        if (!TextUtils.isEmpty(path64)) {
            path64 = path64 + "/libwebviewchromium.so";
        }
        return new String[]{path32, path64};
    }

    private static void createRelroFile(final boolean is64Bit, String[] nativeLibraryPaths) {
        final String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e(WebViewFactory.LOGTAG, "relro file creator for " + abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(is64Bit, false);
                }
                catch (RemoteException e) {
                    Log.e(WebViewFactory.LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static void loadNativeLibrary() {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return;
        }
        try {
            WebViewFactory.getUpdateService().waitForRelroCreationCompleted(VMRuntime.getRuntime().is64Bit());
        }
        catch (RemoteException e) {
            Log.e(LOGTAG, "error waiting for relro creation, proceeding without", e);
            return;
        }
        try {
            String[] args = WebViewFactory.getWebViewNativeLibraryPaths();
            boolean result = WebViewFactory.nativeLoadWithRelroFile(args[0], args[1], CHROMIUM_WEBVIEW_NATIVE_RELRO_32, CHROMIUM_WEBVIEW_NATIVE_RELRO_64);
            if (!result) {
                Log.w(LOGTAG, "failed to load with relro file, proceeding without");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Failed to list WebView package libraries for loadNativeLibrary", e);
        }
    }

    private static IWebViewUpdateService getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService("webviewupdate"));
    }

    private static native boolean nativeReserveAddressSpace(long var0);

    private static native boolean nativeCreateRelroFile(String var0, String var1, String var2, String var3);

    private static native boolean nativeLoadWithRelroFile(String var0, String var1, String var2, String var3);

    static {
        sProviderLock = new Object();
        sAddressSpaceReserved = false;
    }

    private static class RelroFileCreator {
        private RelroFileCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e(WebViewFactory.LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(WebViewFactory.LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "), " + " 32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e(WebViewFactory.LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewFactory.nativeCreateRelroFile(args[0], args[1], WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_32, WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_64);
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(is64Bit, result);
                }
                catch (RemoteException e) {
                    Log.e(WebViewFactory.LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }
    }
}

