/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;

class GLES20Canvas
extends HardwareCanvas {
    private final boolean mOpaque;
    protected long mRenderer = GLES20Canvas.nCreateDisplayListRenderer();
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private float[] mPoint;
    private float[] mLine;
    private Rect mClipBounds;
    private RectF mPathBounds;
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();

    private static native boolean nIsAvailable();

    static boolean isAvailable() {
        return sIsAvailable;
    }

    protected GLES20Canvas() {
        this.mOpaque = false;
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0L) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    private static native long nCreateDisplayListRenderer();

    private static native void nResetDisplayListRenderer(long var0);

    private static native void nDestroyRenderer(long var0);

    public static void setProperty(String name, String value) {
        GLES20Canvas.nSetProperty(name, value);
    }

    private static native void nSetProperty(String var0, String var1);

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static native int nGetMaximumTextureWidth();

    private static native int nGetMaximumTextureHeight();

    long getRenderer() {
        return this.mRenderer;
    }

    @Override
    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static native void nSetViewport(long var0, int var2, int var3);

    @Override
    public void setHighContrastText(boolean highContrastText) {
        GLES20Canvas.nSetHighContrastText(this.mRenderer, highContrastText);
    }

    private static native void nSetHighContrastText(long var0, boolean var2);

    @Override
    public void insertReorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, true);
    }

    @Override
    public void insertInorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, false);
    }

    private static native void nInsertReorderBarrier(long var0, boolean var2);

    @Override
    public int onPreDraw(Rect dirty) {
        if (dirty != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    private static native int nPrepare(long var0, boolean var2);

    private static native int nPrepareDirty(long var0, int var2, int var3, int var4, int var5, boolean var6);

    @Override
    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static native void nFinish(long var0);

    @Override
    public int callDrawGLFunction(long drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static native int nCallDrawGLFunction(long var0, long var2);

    protected static native long nFinishRecording(long var0);

    @Override
    public int drawRenderNode(RenderNode renderNode, Rect dirty, int flags) {
        return GLES20Canvas.nDrawRenderNode(this.mRenderer, renderNode.getNativeDisplayList(), dirty, flags);
    }

    private static native int nDrawRenderNode(long var0, long var2, Rect var4, int var5);

    @Override
    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        GLES20Canvas.nDrawLayer(this.mRenderer, layer.getLayer(), x, y);
    }

    private static native void nDrawLayer(long var0, long var2, float var4, float var5);

    private Rect getInternalClipBounds() {
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect();
        }
        return this.mClipBounds;
    }

    private RectF getPathBounds() {
        if (this.mPathBounds == null) {
            this.mPathBounds = new RectF();
        }
        return this.mPathBounds;
    }

    private float[] getPointStorage() {
        if (this.mPoint == null) {
            this.mPoint = new float[2];
        }
        return this.mPoint;
    }

    private float[] getLineStorage() {
        if (this.mLine == null) {
            this.mLine = new float[4];
        }
        return this.mLine;
    }

    @Override
    public boolean clipPath(Path path) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipPath(Path path, Region.Op op) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, op.nativeInt);
    }

    private static native boolean nClipPath(long var0, long var2, int var4);

    @Override
    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(long var0, float var2, float var3, float var4, float var5, int var6);

    @Override
    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    @Override
    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(long var0, int var2, int var3, int var4, int var5, int var6);

    @Override
    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region, Region.Op op) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, op.nativeInt);
    }

    private static native boolean nClipRegion(long var0, long var2, int var4);

    @Override
    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static native boolean nGetClipBounds(long var0, Rect var2);

    @Override
    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom);
    }

    private static native boolean nQuickReject(long var0, float var2, float var3, float var4, float var5);

    @Override
    public boolean quickReject(Path path, Canvas.EdgeType type) {
        RectF pathBounds = this.getPathBounds();
        path.computeBounds(pathBounds, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, pathBounds.left, pathBounds.top, pathBounds.right, pathBounds.bottom);
    }

    @Override
    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom);
    }

    @Override
    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static native void nTranslate(long var0, float var2, float var3);

    @Override
    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static native void nSkew(long var0, float var2, float var3);

    @Override
    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static native void nRotate(long var0, float var2);

    @Override
    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static native void nScale(long var0, float var2, float var3);

    @Override
    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix == null ? 0L : matrix.native_instance);
    }

    private static native void nSetMatrix(long var0, long var2);

    @Override
    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static native void nGetMatrix(long var0, long var2);

    @Override
    public void concat(Matrix matrix) {
        if (matrix != null) {
            GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
        }
    }

    private static native void nConcatMatrix(long var0, long var2);

    @Override
    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    @Override
    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static native int nSave(long var0, int var2);

    @Override
    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        return GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
    }

    private static native int nSaveLayer(long var0, long var2, int var4);

    @Override
    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            return GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayer(long var0, float var2, float var3, float var4, float var5, long var6, int var8);

    @Override
    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static native int nSaveLayerAlpha(long var0, int var2, int var3);

    @Override
    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayerAlpha(long var0, float var2, float var3, float var4, float var5, int var6, int var7);

    @Override
    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static native void nRestore(long var0);

    @Override
    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static native void nRestoreToCount(long var0, int var2);

    @Override
    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static native int nGetSaveCount(long var0);

    @Override
    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
        if (filter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
        } else if (filter instanceof PaintFlagsDrawFilter) {
            PaintFlagsDrawFilter flagsFilter = (PaintFlagsDrawFilter)filter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, flagsFilter.clearBits, flagsFilter.setBits);
        }
    }

    private static native void nResetPaintFilter(long var0);

    private static native void nSetupPaintFilter(long var0, int var2, int var3);

    @Override
    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        GLES20Canvas.nDrawArc(this.mRenderer, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    private static native void nDrawArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static native void nDrawPatch(long var0, long var2, byte[] var4, long var5, float var7, float var8, float var9, float var10, long var11);

    @Override
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
    }

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, float var5, float var6, long var7);

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
    }

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, long var5, long var7);

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, long var13);

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, colors, offset, stride, x, y, width, height, hasAlpha, nativePaint);
    }

    private static native void nDrawBitmap(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    @Override
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            GLES20Canvas.checkRange(colors.length, colorOffset, count);
        }
        long nativePaint = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
    }

    private static native void nDrawBitmapMesh(long var0, long var2, byte[] var4, int var5, int var6, float[] var7, int var8, int[] var9, int var10, long var11);

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
    }

    private static native void nDrawCircle(long var0, float var2, float var3, float var4, long var5);

    @Override
    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        GLES20Canvas.nDrawCircle(this.mRenderer, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    @Override
    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @Override
    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    @Override
    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static native void nDrawColor(long var0, int var2, int var3);

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        float[] line = this.getLineStorage();
        line[0] = startX;
        line[1] = startY;
        line[2] = stopX;
        line[3] = stopY;
        this.drawLines(line, 0, 4, paint);
    }

    @Override
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if (count < 4) {
            return;
        }
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
    }

    private static native void nDrawLines(long var0, float[] var2, int var3, int var4, long var5);

    @Override
    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, Paint paint) {
        GLES20Canvas.nDrawOval(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
    }

    private static native void nDrawOval(long var0, float var2, float var3, float var4, float var5, long var6);

    @Override
    public void drawPaint(Paint paint) {
        Rect r = this.getInternalClipBounds();
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath) {
            if (path.rects != null) {
                GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
            }
        } else {
            GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
        }
    }

    private static native void nDrawPath(long var0, long var2, long var4);

    private static native void nDrawRects(long var0, long var2, long var4);

    @Override
    public void drawPicture(Picture picture) {
        picture.endRecording();
    }

    @Override
    public void drawPoint(float x, float y, Paint paint) {
        float[] point = this.getPointStorage();
        point[0] = x;
        point[1] = y;
        this.drawPoints(point, 0, 2, paint);
    }

    @Override
    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Override
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        if (count < 2) {
            return;
        }
        GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
    }

    private static native void nDrawPoints(long var0, float[] var2, int var3, int var4, long var5);

    @Override
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        if (left == right || top == bottom) {
            return;
        }
        GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
    }

    private static native void nDrawRect(long var0, float var2, float var3, float var4, float var5, long var6);

    @Override
    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, left, top, right, bottom, rx, ry, paint.mNativePaint);
    }

    private static native void nDrawRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    @Override
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static native void nDrawText(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    @Override
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            GLES20Canvas.nDrawText(this.mRenderer, text.toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static native void nDrawText(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    @Override
    public void drawText(String text, float x, float y, Paint paint) {
        GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, index, count, path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static native void nDrawTextOnPath(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    @Override
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() == 0) {
            return;
        }
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, 0, text.length(), path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static native void nDrawTextOnPath(long var0, String var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    @Override
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
    }

    private static native void nDrawTextRun(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    @Override
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.mNativePaint, paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    private static native void nDrawTextRun(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    @Override
    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private static final class CanvasFinalizer {
        private final long mRenderer;

        public CanvasFinalizer(long renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

