/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    private static final Property<Drawable, PointF> DRAWABLE_ORIGIN_PROPERTY = new Property<Drawable, PointF>(PointF.class, "boundsOrigin"){
        private Rect mBounds = new Rect();

        @Override
        public void set(Drawable object, PointF value) {
            object.copyBounds(this.mBounds);
            this.mBounds.offsetTo(Math.round(value.x), Math.round(value.y));
            object.setBounds(this.mBounds);
        }

        @Override
        public PointF get(Drawable object) {
            object.copyBounds(this.mBounds);
            return new PointF(this.mBounds.left, this.mBounds.top);
        }
    };
    int[] tempLocation = new int[2];
    boolean mResizeClip = false;
    boolean mReparent = false;
    private static final String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator = new RectEvaluator();

    public ChangeBounds() {
    }

    public ChangeBounds(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (view.isLaidOut() || view.getWidth() != 0 || view.getHeight() != 0) {
            values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            values.values.put(PROPNAME_PARENT, values.view.getParent());
            if (this.mReparent) {
                values.view.getLocationInWindow(this.tempLocation);
                values.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
                values.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
            }
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private boolean parentMatches(View startParent, View endParent) {
        boolean parentMatches = true;
        if (this.mReparent) {
            TransitionValues endValues = this.getMatchedTransitionValues(startParent, true);
            parentMatches = endValues == null ? startParent == endParent : endParent == endValues.view;
        }
        return parentMatches;
    }

    @Override
    public Animator createAnimator(final ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view = endValues.view;
        if (this.parentMatches(startParent, endParent)) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 || endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft || startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight || startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    Animator anim2;
                    if (startWidth == endWidth && startHeight == endHeight) {
                        view.offsetLeftAndRight(startLeft - view.getLeft());
                        view.offsetTopAndBottom(startTop - view.getTop());
                        Path positionPath = this.getPathMotion().getPath(0.0f, 0.0f, endLeft - startLeft, endTop - startTop);
                        anim2 = ObjectAnimator.ofInt(view, new HorizontalOffsetProperty(), new VerticalOffsetProperty(), positionPath);
                    } else {
                        if (startLeft != endLeft) {
                            view.setLeft(startLeft);
                        }
                        if (startTop != endTop) {
                            view.setTop(startTop);
                        }
                        if (startRight != endRight) {
                            view.setRight(startRight);
                        }
                        if (startBottom != endBottom) {
                            view.setBottom(startBottom);
                        }
                        ObjectAnimator topLeftAnimator = null;
                        if (startLeft != endLeft || startTop != endTop) {
                            Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                            topLeftAnimator = ObjectAnimator.ofInt((Object)view, "left", "top", topLeftPath);
                        }
                        ObjectAnimator bottomRightAnimator = null;
                        if (startRight != endRight || startBottom != endBottom) {
                            Path bottomRightPath = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                            bottomRightAnimator = ObjectAnimator.ofInt((Object)view, "right", "bottom", bottomRightPath);
                        }
                        anim2 = TransitionUtils.mergeAnimators(topLeftAnimator, bottomRightAnimator);
                    }
                    if (view.getParent() instanceof ViewGroup) {
                        final ViewGroup parent = (ViewGroup)view.getParent();
                        parent.suppressLayout(true);
                        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                            boolean mCanceled = false;

                            @Override
                            public void onTransitionCancel(Transition transition2) {
                                parent.suppressLayout(false);
                                this.mCanceled = true;
                            }

                            @Override
                            public void onTransitionEnd(Transition transition2) {
                                if (!this.mCanceled) {
                                    parent.suppressLayout(false);
                                }
                            }

                            @Override
                            public void onTransitionPause(Transition transition2) {
                                parent.suppressLayout(false);
                            }

                            @Override
                            public void onTransitionResume(Transition transition2) {
                                parent.suppressLayout(true);
                            }
                        };
                        this.addListener(transitionListener);
                    }
                    return anim2;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX(startLeft - endLeft);
                }
                if (startTop != endTop) {
                    view.setTranslationY(startTop - endTop);
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                numChanges = 0;
                if (transXDelta != 0.0f) {
                    ++numChanges;
                }
                if (transYDelta != 0.0f) {
                    ++numChanges;
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    ++numChanges;
                }
                ObjectAnimator translationAnimator = null;
                if (transXDelta != 0.0f || transYDelta != 0.0f) {
                    Path topLeftPath = this.getPathMotion().getPath(0.0f, 0.0f, transXDelta, transYDelta);
                    translationAnimator = ObjectAnimator.ofFloat(view, View.TRANSLATION_X, View.TRANSLATION_Y, topLeftPath);
                }
                ObjectAnimator clipAnimator = null;
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect tempEndBounds = new Rect(0, 0, endWidth, endHeight);
                    clipAnimator = ObjectAnimator.ofObject((Object)view, "clipBounds", (TypeEvaluator)sRectEvaluator, tempStartBounds, tempEndBounds);
                }
                Animator anim3 = TransitionUtils.mergeAnimators(translationAnimator, clipAnimator);
                if (view.getParent() instanceof ViewGroup) {
                    final ViewGroup parent = (ViewGroup)view.getParent();
                    parent.suppressLayout(true);
                    Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        @Override
                        public void onTransitionCancel(Transition transition2) {
                            parent.suppressLayout(false);
                            this.mCanceled = true;
                        }

                        @Override
                        public void onTransitionEnd(Transition transition2) {
                            if (!this.mCanceled) {
                                parent.suppressLayout(false);
                            }
                        }

                        @Override
                        public void onTransitionPause(Transition transition2) {
                            parent.suppressLayout(false);
                        }

                        @Override
                        public void onTransitionResume(Transition transition2) {
                            parent.suppressLayout(true);
                        }
                    };
                    this.addListener(transitionListener);
                }
                anim3.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        view.setClipBounds(null);
                    }
                });
                return anim3;
            }
        } else {
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X);
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y);
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X);
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y);
            if (startX != endX || startY != endY) {
                sceneRoot.getLocationInWindow(this.tempLocation);
                Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                final BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                final float transitionAlpha = view.getTransitionAlpha();
                view.setTransitionAlpha(0.0f);
                sceneRoot.getOverlay().add(drawable2);
                Path topLeftPath = this.getPathMotion().getPath(startX - this.tempLocation[0], startY - this.tempLocation[1], endX - this.tempLocation[0], endY - this.tempLocation[1]);
                PropertyValuesHolder origin = PropertyValuesHolder.ofObject(DRAWABLE_ORIGIN_PROPERTY, null, topLeftPath);
                ObjectAnimator anim4 = ObjectAnimator.ofPropertyValuesHolder(drawable2, origin);
                anim4.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        sceneRoot.getOverlay().remove(drawable2);
                        view.setTransitionAlpha(transitionAlpha);
                    }
                });
                return anim4;
            }
        }
        return null;
    }

    private static class VerticalOffsetProperty
    extends OffsetProperty {
        public VerticalOffsetProperty() {
            super("offsetTopAndBottom");
        }

        @Override
        protected void offsetBy(View view, int by) {
            view.offsetTopAndBottom(by);
        }
    }

    private static class HorizontalOffsetProperty
    extends OffsetProperty {
        public HorizontalOffsetProperty() {
            super("offsetLeftAndRight");
        }

        @Override
        protected void offsetBy(View view, int by) {
            view.offsetLeftAndRight(by);
        }
    }

    private static abstract class OffsetProperty
    extends IntProperty<View> {
        int mPreviousValue;

        public OffsetProperty(String name) {
            super(name);
        }

        @Override
        public void setValue(View view, int value) {
            int offset = value - this.mPreviousValue;
            this.offsetBy(view, offset);
            this.mPreviousValue = value;
        }

        @Override
        public Integer get(View object) {
            return null;
        }

        protected abstract void offsetBy(View var1, int var2);
    }
}

