/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Selection;
import android.text.SpannableStringBuilder;
import java.text.BreakIterator;
import java.util.Locale;

public class WordIterator
implements Selection.PositionIterator {
    private static final int WINDOW_WIDTH = 50;
    private String mString;
    private int mOffsetShift;
    private BreakIterator mIterator;

    public WordIterator() {
        this(Locale.getDefault());
    }

    public WordIterator(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    public void setCharSequence(CharSequence charSequence, int start, int end) {
        this.mOffsetShift = Math.max(0, start - 50);
        int windowEnd = Math.min(charSequence.length(), end + 50);
        this.mString = charSequence instanceof SpannableStringBuilder ? ((SpannableStringBuilder)charSequence).substring(this.mOffsetShift, windowEnd) : charSequence.subSequence(this.mOffsetShift, windowEnd).toString();
        this.mIterator.setText(this.mString);
    }

    @Override
    public int preceding(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        do {
            if ((shiftedOffset = this.mIterator.preceding(shiftedOffset)) != -1) continue;
            return -1;
        } while (!this.isOnLetterOrDigit(shiftedOffset));
        return shiftedOffset + this.mOffsetShift;
    }

    @Override
    public int following(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        do {
            if ((shiftedOffset = this.mIterator.following(shiftedOffset)) != -1) continue;
            return -1;
        } while (!this.isAfterLetterOrDigit(shiftedOffset));
        return shiftedOffset + this.mOffsetShift;
    }

    public int getBeginning(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        this.checkOffsetIsValid(shiftedOffset);
        if (this.isOnLetterOrDigit(shiftedOffset)) {
            if (this.mIterator.isBoundary(shiftedOffset)) {
                return shiftedOffset + this.mOffsetShift;
            }
            return this.mIterator.preceding(shiftedOffset) + this.mOffsetShift;
        }
        if (this.isAfterLetterOrDigit(shiftedOffset)) {
            return this.mIterator.preceding(shiftedOffset) + this.mOffsetShift;
        }
        return -1;
    }

    public int getEnd(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        this.checkOffsetIsValid(shiftedOffset);
        if (this.isAfterLetterOrDigit(shiftedOffset)) {
            if (this.mIterator.isBoundary(shiftedOffset)) {
                return shiftedOffset + this.mOffsetShift;
            }
            return this.mIterator.following(shiftedOffset) + this.mOffsetShift;
        }
        if (this.isOnLetterOrDigit(shiftedOffset)) {
            return this.mIterator.following(shiftedOffset) + this.mOffsetShift;
        }
        return -1;
    }

    private boolean isAfterLetterOrDigit(int shiftedOffset) {
        int codePoint;
        return shiftedOffset >= 1 && shiftedOffset <= this.mString.length() && Character.isLetterOrDigit(codePoint = this.mString.codePointBefore(shiftedOffset));
    }

    private boolean isOnLetterOrDigit(int shiftedOffset) {
        int codePoint;
        return shiftedOffset >= 0 && shiftedOffset < this.mString.length() && Character.isLetterOrDigit(codePoint = this.mString.codePointAt(shiftedOffset));
    }

    private void checkOffsetIsValid(int shiftedOffset) {
        if (shiftedOffset < 0 || shiftedOffset > this.mString.length()) {
            throw new IllegalArgumentException("Invalid offset: " + (shiftedOffset + this.mOffsetShift) + ". Valid range is [" + this.mOffsetShift + ", " + (this.mString.length() + this.mOffsetShift) + "]");
        }
    }
}

