/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelephonyManager {
    private static final String TAG = "TelephonyManager";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private static String multiSimConfig;
    private static TelephonyManager sInstance;
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_RINGING;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static final String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static final String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static final String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static final String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static final String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    public static final String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static final String EXTRA_DATA_STATE = "state";
    public static final String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_DATA_APN_TYPE = "apnType";
    public static final String EXTRA_DATA_APN = "apn";
    public static final String EXTRA_DATA_CHANGE_REASON = "reason";
    public static final String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static final String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_SIP = 3;
    private static final String sKernelCmdLine;
    private static final Pattern sProductTypePattern;
    private static final String sLteOnCdmaProductType;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_GSM = 16;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_CARD_IO_ERROR = 6;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_UNKNOWN = -1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;
    public static final int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static final int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static final int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static final int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;

    public TelephonyManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private TelephonyManager() {
        this.mContext = null;
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    public MultiSimVariants getMultiSimConfiguration() {
        String mSimConfig = SystemProperties.get("persist.radio.multisim.config");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    public int getPhoneCount() {
        int phoneCount = 1;
        switch (this.getMultiSimConfiguration()) {
            case DSDS: 
            case DSDA: {
                phoneCount = 2;
                break;
            }
            case TSTS: {
                phoneCount = 3;
            }
        }
        return phoneCount;
    }

    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public boolean isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    public String getDeviceSoftwareVersion() {
        try {
            return this.getSubscriberInfo().getDeviceSvn();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getDeviceId() {
        return this.getDeviceId(this.getDefaultSim());
    }

    public String getDeviceId(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        try {
            return this.getSubscriberInfo().getDeviceIdForSubscriber(subId[0]);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getImei() {
        return this.getImei(this.getDefaultSim());
    }

    public String getImei(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        try {
            return this.getSubscriberInfo().getImeiForSubscriber(subId[0]);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public CellLocation getCellLocation() {
        try {
            Bundle bundle = this.getITelephony().getCellLocation();
            if (bundle.isEmpty()) {
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void enableLocationUpdates() {
        this.enableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    public void enableLocationUpdates(long subId) {
        try {
            this.getITelephony().enableLocationUpdatesForSubscriber(subId);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableLocationUpdates() {
        this.disableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    public void disableLocationUpdates(long subId) {
        try {
            this.getITelephony().disableLocationUpdatesForSubscriber(subId);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            return this.getITelephony().getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getCurrentPhoneType() {
        return this.getCurrentPhoneType(TelephonyManager.getDefaultSubscription());
    }

    public int getCurrentPhoneType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSubscriber(subId);
            }
            return this.getPhoneTypeFromProperty(subId);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(subId);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(subId);
        }
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private int getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(TelephonyManager.getDefaultSubscription());
    }

    private int getPhoneTypeFromProperty(long subId) {
        String type = TelephonyManager.getTelephonyProperty("gsm.current.phone-type", subId, null);
        if (type != null) {
            return Integer.parseInt(type);
        }
        return this.getPhoneTypeFromNetworkType(subId);
    }

    private int getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(TelephonyManager.getDefaultSubscription());
    }

    private int getPhoneTypeFromNetworkType(long subId) {
        String mode = TelephonyManager.getTelephonyProperty("ro.telephony.default_network", subId, null);
        if (mode != null) {
            return TelephonyManager.getPhoneType(Integer.parseInt(mode));
        }
        return 0;
    }

    public static int getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d(TAG, "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d(TAG, "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    public static int getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d(TAG, "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    public String getNetworkOperatorName() {
        return this.getNetworkOperatorName(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkOperatorName(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.alpha", subId, "");
    }

    public String getNetworkOperator() {
        return this.getNetworkOperator(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkOperator(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.numeric", subId, "");
    }

    public boolean isNetworkRoaming() {
        return this.isNetworkRoaming(TelephonyManager.getDefaultSubscription());
    }

    public boolean isNetworkRoaming(long subId) {
        return "true".equals(TelephonyManager.getTelephonyProperty("gsm.operator.isroaming", subId, null));
    }

    public String getNetworkCountryIso() {
        return this.getNetworkCountryIso(TelephonyManager.getDefaultSubscription());
    }

    public String getNetworkCountryIso(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.iso-country", subId, "");
    }

    public int getNetworkType() {
        return this.getDataNetworkType();
    }

    public int getNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataNetworkType() {
        return this.getDataNetworkType(TelephonyManager.getDefaultSubscription());
    }

    public int getDataNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getVoiceNetworkType() {
        return this.getVoiceNetworkType(TelephonyManager.getDefaultSubscription());
    }

    public int getVoiceNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public static int getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
        }
        return "UNKNOWN";
    }

    public boolean hasIccCard() {
        return this.hasIccCard(this.getDefaultSim());
    }

    public boolean hasIccCard(long slotId) {
        try {
            return this.getITelephony().hasIccCardUsingSlotId(slotId);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public int getSimState() {
        return this.getSimState(this.getDefaultSim());
    }

    public int getSimState(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        if (subId == null) {
            return 1;
        }
        String prop = TelephonyManager.getTelephonyProperty("gsm.sim.state", subId[0], "");
        if ("ABSENT".equals(prop)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(prop)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(prop)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(prop)) {
            return 4;
        }
        if ("READY".equals(prop)) {
            return 5;
        }
        if ("CARD_IO_ERROR".equals(prop)) {
            return 6;
        }
        return 0;
    }

    public String getSimOperator() {
        long subId = TelephonyManager.getDefaultSubscription();
        Rlog.d(TAG, "getSimOperator(): default subId=" + subId);
        return this.getSimOperator(subId);
    }

    public String getSimOperator(long subId) {
        String operator = TelephonyManager.getTelephonyProperty("gsm.sim.operator.numeric", subId, "");
        Rlog.d(TAG, "getSimOperator: subId=" + subId + " operator=" + operator);
        return operator;
    }

    public String getSimOperatorName() {
        return this.getSimOperatorName(TelephonyManager.getDefaultSubscription());
    }

    public String getSimOperatorName(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.alpha", subId, "");
    }

    public String getSimCountryIso() {
        return this.getSimCountryIso(TelephonyManager.getDefaultSubscription());
    }

    public String getSimCountryIso(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.iso-country", subId, "");
    }

    public String getSimSerialNumber() {
        return this.getSimSerialNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getSimSerialNumber(long subId) {
        try {
            return this.getSubscriberInfo().getIccSerialNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(TelephonyManager.getDefaultSubscription());
    }

    public int getLteOnCdmaMode(long subId) {
        try {
            return this.getITelephony().getLteOnCdmaModeForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getSubscriberId() {
        return this.getSubscriberId(TelephonyManager.getDefaultSubscription());
    }

    public String getSubscriberId(long subId) {
        try {
            return this.getSubscriberInfo().getSubscriberIdForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1() {
        try {
            return this.getSubscriberInfo().getGroupIdLevel1();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1(long subId) {
        try {
            return this.getSubscriberInfo().getGroupIdLevel1ForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1Number() {
        return this.getLine1NumberForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    public String getLine1NumberForSubscriber(long subId) {
        String number = null;
        try {
            number = this.getITelephony().getLine1NumberForDisplay(subId);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            return this.getSubscriberInfo().getLine1NumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void setLine1NumberForDisplay(String alphaTag, String number) {
        this.setLine1NumberForDisplayForSubscriber(TelephonyManager.getDefaultSubscription(), alphaTag, number);
    }

    public void setLine1NumberForDisplayForSubscriber(long subId, String alphaTag, String number) {
        try {
            this.getITelephony().setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public String getLine1AlphaTag() {
        return this.getLine1AlphaTagForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    public String getLine1AlphaTagForSubscriber(long subId) {
        String alphaTag = null;
        try {
            alphaTag = this.getITelephony().getLine1AlphaTagForDisplay(subId);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            return this.getSubscriberInfo().getLine1AlphaTagForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getMsisdn() {
        return this.getMsisdn(TelephonyManager.getDefaultSubscription());
    }

    public String getMsisdn(long subId) {
        try {
            return this.getSubscriberInfo().getMsisdnForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        return this.getVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getVoiceMailNumber(long subId) {
        try {
            return this.getSubscriberInfo().getVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    public String getCompleteVoiceMailNumber(long subId) {
        try {
            return this.getSubscriberInfo().getCompleteVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getVoiceMessageCount() {
        return this.getVoiceMessageCount(TelephonyManager.getDefaultSubscription());
    }

    public int getVoiceMessageCount(long subId) {
        try {
            return this.getITelephony().getVoiceMessageCountForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(TelephonyManager.getDefaultSubscription());
    }

    public String getVoiceMailAlphaTag(long subId) {
        try {
            return this.getSubscriberInfo().getVoiceMailAlphaTagForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimImpi() {
        try {
            return this.getSubscriberInfo().getIsimImpi();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimDomain() {
        try {
            return this.getSubscriberInfo().getIsimDomain();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimImpu() {
        try {
            return this.getSubscriberInfo().getIsimImpu();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public int getCallState() {
        try {
            return this.getTelecomService().getCallState();
        }
        catch (RemoteException | NullPointerException e) {
            return 0;
        }
    }

    public int getCallState(long subId) {
        try {
            return this.getITelephony().getCallStateForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            return this.getITelephony().getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            return this.getITelephony().getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    public void listen(PhoneStateListener listener, int events) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            Boolean notifyNow = this.getITelephony() != null;
            sRegistry.listenForSubscriber(listener.mSubId, pkgForDebug, listener.callback, events, notifyNow);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public int getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(TelephonyManager.getDefaultSubscription());
    }

    public int getCdmaEriIconIndex(long subId) {
        try {
            return this.getITelephony().getCdmaEriIconIndexForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(TelephonyManager.getDefaultSubscription());
    }

    public int getCdmaEriIconMode(long subId) {
        try {
            return this.getITelephony().getCdmaEriIconModeForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        return this.getCdmaEriText(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaEriText(long subId) {
        try {
            return this.getITelephony().getCdmaEriTextForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956931);
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956932);
    }

    public List<CellInfo> getAllCellInfo() {
        try {
            return this.getITelephony().getAllCellInfo();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void setCellInfoListRate(int rateInMillis) {
        try {
            this.getITelephony().setCellInfoListRate(rateInMillis);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039409);
    }

    public String getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039410);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID) {
        try {
            return this.getITelephony().iccOpenLogicalChannel(AID);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public boolean iccCloseLogicalChannel(int channel) {
        try {
            return this.getITelephony().iccCloseLogicalChannel(channel);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            return this.getITelephony().iccTransmitApduLogicalChannel(channel, cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        return "";
    }

    public String iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            return this.getITelephony().iccTransmitApduBasicChannel(cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        return "";
    }

    public byte[] iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            return this.getITelephony().iccExchangeSimIO(fileID, command, p1, p2, p3, filePath);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        return null;
    }

    public String sendEnvelopeWithStatus(String content) {
        try {
            return this.getITelephony().sendEnvelopeWithStatus(content);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public String nvReadItem(int itemID) {
        try {
            return this.getITelephony().nvReadItem(itemID);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvReadItem NPE", ex);
        }
        return "";
    }

    public boolean nvWriteItem(int itemID, String itemValue) {
        try {
            return this.getITelephony().nvWriteItem(itemID, itemValue);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteItem NPE", ex);
        }
        return false;
    }

    public boolean nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            return this.getITelephony().nvWriteCdmaPrl(preferredRoamingList);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    public boolean nvResetConfig(int resetType) {
        try {
            return this.getITelephony().nvResetConfig(resetType);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvResetConfig NPE", ex);
        }
        return false;
    }

    private static long getDefaultSubscription() {
        return SubscriptionManager.getDefaultSubId();
    }

    public int getDefaultSim() {
        return 0;
    }

    public static void setTelephonyProperty(String property, long subId, String value) {
        int i;
        String propVal = "";
        String[] p = null;
        String prop = SystemProperties.get(property);
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (value == null) {
            value = "";
        }
        if (prop != null) {
            p = prop.split(",");
        }
        if (phoneId < 0) {
            return;
        }
        for (i = 0; i < phoneId; ++i) {
            String str = "";
            if (p != null && i < p.length) {
                str = p[i];
            }
            propVal = propVal + str + ",";
        }
        propVal = propVal + value;
        if (p != null) {
            for (i = phoneId + 1; i < p.length; ++i) {
                propVal = propVal + "," + p[i];
            }
        }
        if (property.length() > 31 || propVal.length() > 91) {
            Rlog.d(TAG, "setTelephonyProperty length too long:" + property + ", " + propVal);
            return;
        }
        Rlog.d(TAG, "setTelephonyProperty property=" + property + " propVal=" + propVal);
        SystemProperties.set(property, propVal);
    }

    public static int getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    public static boolean putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    public static String getTelephonyProperty(String property, long subId, String defaultVal) {
        String propVal = null;
        int phoneId = SubscriptionManager.getPhoneId(subId);
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    public int getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    public String getIsimIst() {
        try {
            return this.getSubscriberInfo().getIsimIst();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimPcscf() {
        try {
            return this.getSubscriberInfo().getIsimPcscf();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimChallengeResponse(String nonce) {
        try {
            return this.getSubscriberInfo().getIsimChallengeResponse(nonce);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIccSimChallengeResponse(long subId, int appType, String data) {
        try {
            return this.getSubscriberInfo().getIccSimChallengeResponse(subId, appType, data);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIccSimChallengeResponse(int appType, String data) {
        return this.getIccSimChallengeResponse(TelephonyManager.getDefaultSubscription(), appType, data);
    }

    public String[] getPcscfAddress(String apnType) {
        try {
            return this.getITelephony().getPcscfAddress(apnType);
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public void setImsRegistrationState(boolean registered) {
        try {
            this.getITelephony().setImsRegistrationState(registered);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getPreferredNetworkType() {
        try {
            return this.getITelephony().getPreferredNetworkType();
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPreferredNetworkType NPE", ex);
        }
        return -1;
    }

    public boolean setPreferredNetworkType(int networkType) {
        try {
            return this.getITelephony().setPreferredNetworkType(networkType);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setPreferredNetworkType NPE", ex);
        }
        return false;
    }

    public boolean setGlobalPreferredNetworkType() {
        return this.setPreferredNetworkType(10);
    }

    public int hasCarrierPrivileges() {
        try {
            return this.getITelephony().hasCarrierPrivileges();
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", ex);
        }
        return 0;
    }

    public boolean setOperatorBrandOverride(String brand) {
        try {
            return this.getITelephony().setOperatorBrandOverride(brand);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    public String getCdmaMdn() {
        return this.getCdmaMdn(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaMdn(long subId) {
        try {
            return this.getITelephony().getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCdmaMin() {
        return this.getCdmaMin(TelephonyManager.getDefaultSubscription());
    }

    public String getCdmaMin(long subId) {
        try {
            return this.getITelephony().getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int checkCarrierPrivilegesForPackage(String pkgname) {
        try {
            return this.getITelephony().checkCarrierPrivilegesForPackage(pkgname);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", ex);
        }
        return 0;
    }

    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        try {
            return this.getITelephony().getCarrierPackageNamesForIntent(intent);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntent RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntent NPE", ex);
        }
        return null;
    }

    public void dial(String number) {
        try {
            this.getITelephony().dial(number);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#dial", e);
        }
    }

    public void call(String callingPackage, String number) {
        try {
            this.getITelephony().call(callingPackage, number);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#call", e);
        }
    }

    public boolean endCall() {
        try {
            return this.getITelephony().endCall();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#endCall", e);
            return false;
        }
    }

    public void answerRingingCall() {
        try {
            this.getITelephony().answerRingingCall();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#answerRingingCall", e);
        }
    }

    public void silenceRinger() {
        try {
            this.getTelecomService().silenceRinger();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", e);
        }
    }

    public boolean isOffhook() {
        try {
            return this.getITelephony().isOffhook();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isOffhook", e);
            return false;
        }
    }

    public boolean isRinging() {
        try {
            return this.getITelephony().isRinging();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRinging", e);
            return false;
        }
    }

    public boolean isIdle() {
        try {
            return this.getITelephony().isIdle();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isIdle", e);
            return true;
        }
    }

    public boolean isRadioOn() {
        try {
            return this.getITelephony().isRadioOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRadioOn", e);
            return false;
        }
    }

    public boolean isSimPinEnabled() {
        try {
            return this.getITelephony().isSimPinEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isSimPinEnabled", e);
            return false;
        }
    }

    public boolean supplyPin(String pin) {
        try {
            return this.getITelephony().supplyPin(pin);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPin", e);
            return false;
        }
    }

    public boolean supplyPuk(String puk, String pin) {
        try {
            return this.getITelephony().supplyPuk(puk, pin);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPuk", e);
            return false;
        }
    }

    public int[] supplyPinReportResult(String pin) {
        try {
            return this.getITelephony().supplyPinReportResult(pin);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPinReportResult", e);
            return new int[0];
        }
    }

    public int[] supplyPukReportResult(String puk, String pin) {
        try {
            return this.getITelephony().supplyPukReportResult(puk, pin);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#]", e);
            return new int[0];
        }
    }

    public boolean handlePinMmi(String dialString) {
        try {
            return this.getITelephony().handlePinMmi(dialString);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
            return false;
        }
    }

    public void toggleRadioOnOff() {
        try {
            this.getITelephony().toggleRadioOnOff();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    public boolean setRadio(boolean turnOn) {
        try {
            return this.getITelephony().setRadio(turnOn);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadio", e);
            return false;
        }
    }

    public boolean setRadioPower(boolean turnOn) {
        try {
            return this.getITelephony().setRadioPower(turnOn);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadioPower", e);
            return false;
        }
    }

    public void updateServiceLocation() {
        try {
            this.getITelephony().updateServiceLocation();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#updateServiceLocation", e);
        }
    }

    public boolean enableDataConnectivity() {
        try {
            return this.getITelephony().enableDataConnectivity();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableDataConnectivity", e);
            return false;
        }
    }

    public boolean disableDataConnectivity() {
        try {
            return this.getITelephony().disableDataConnectivity();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#disableDataConnectivity", e);
            return false;
        }
    }

    public boolean isDataConnectivityPossible() {
        try {
            return this.getITelephony().isDataConnectivityPossible();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isDataConnectivityPossible", e);
            return false;
        }
    }

    public boolean needsOtaServiceProvisioning() {
        try {
            return this.getITelephony().needsOtaServiceProvisioning();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#needsOtaServiceProvisioning", e);
            return false;
        }
    }

    public void setDataEnabled(boolean enable) {
        try {
            this.getITelephony().setDataEnabled(enable);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setDataEnabled", e);
        }
    }

    public boolean getDataEnabled() {
        try {
            return this.getITelephony().getDataEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getDataEnabled", e);
            return false;
        }
    }

    public void enableSimplifiedNetworkSettings(boolean enable) {
        this.enableSimplifiedNetworkSettingsForSubscriber(TelephonyManager.getDefaultSubscription(), enable);
    }

    public void enableSimplifiedNetworkSettingsForSubscriber(long subId, boolean enable) {
        try {
            this.getITelephony().enableSimplifiedNetworkSettingsForSubscriber(subId, enable);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public boolean getSimplifiedNetworkSettingsEnabled() {
        return this.getSimplifiedNetworkSettingsEnabledForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    public boolean getSimplifiedNetworkSettingsEnabledForSubscriber(long subId) {
        try {
            return this.getITelephony().getSimplifiedNetworkSettingsEnabledForSubscriber(subId);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            return this.getITelephony().invokeOemRilRequestRaw(oemReq, oemResp);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    static {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    public static enum MultiSimVariants {
        DSDS,
        DSDA,
        TSTS,
        UNKNOWN;

    }

    public static interface WifiCallingChoices {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

