/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TelecomManager {
    public static final String ACTION_INCOMING_CALL = "android.telecom.action.INCOMING_CALL";
    public static final String ACTION_NEW_UNKNOWN_CALL = "android.telecom.action.NEW_UNKNOWN_CALL";
    public static final String ACTION_CONNECTION_SERVICE_CONFIGURE = "android.telecom.action.CONNECTION_SERVICE_CONFIGURE";
    public static final String ACTION_SHOW_CALL_SETTINGS = "android.telecom.action.SHOW_CALL_SETTINGS";
    public static final String ACTION_CHANGE_PHONE_ACCOUNTS = "android.telecom.action.CHANGE_PHONE_ACCOUNTS";
    public static final String EXTRA_START_CALL_WITH_SPEAKERPHONE = "android.telecom.extra.START_CALL_WITH_SPEAKERPHONE";
    public static final String EXTRA_START_CALL_WITH_VIDEO_STATE = "android.telecom.extra.START_CALL_WITH_VIDEO_STATE";
    public static final String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telecom.extra.PHONE_ACCOUNT_HANDLE";
    public static final String EXTRA_INCOMING_CALL_EXTRAS = "android.telecom.extra.INCOMING_CALL_EXTRAS";
    public static final String EXTRA_OUTGOING_CALL_EXTRAS = "android.telecom.extra.OUTGOING_CALL_EXTRAS";
    public static final String EXTRA_UNKNOWN_CALL_HANDLE = "android.telecom.extra.UNKNOWN_CALL_HANDLE";
    public static final String EXTRA_CALL_DISCONNECT_CAUSE = "android.telecom.extra.CALL_DISCONNECT_CAUSE";
    public static final String EXTRA_CALL_DISCONNECT_MESSAGE = "android.telecom.extra.CALL_DISCONNECT_MESSAGE";
    public static final String EXTRA_CONNECTION_SERVICE = "android.telecom.extra.CONNECTION_SERVICE";
    public static final String GATEWAY_PROVIDER_PACKAGE = "android.telecom.extra.GATEWAY_PROVIDER_PACKAGE";
    public static final String GATEWAY_ORIGINAL_ADDRESS = "android.telecom.extra.GATEWAY_ORIGINAL_ADDRESS";
    public static final String EXTRA_CALL_BACK_NUMBER = "android.telecom.extra.CALL_BACK_NUMBER";
    public static final char DTMF_CHARACTER_PAUSE = ',';
    public static final char DTMF_CHARACTER_WAIT = ';';
    public static final int TTY_MODE_OFF = 0;
    public static final int TTY_MODE_FULL = 1;
    public static final int TTY_MODE_HCO = 2;
    public static final int TTY_MODE_VCO = 3;
    public static final String ACTION_CURRENT_TTY_MODE_CHANGED = "android.telecom.action.CURRENT_TTY_MODE_CHANGED";
    public static final String EXTRA_CURRENT_TTY_MODE = "android.telecom.intent.extra.CURRENT_TTY_MODE";
    public static final String ACTION_TTY_PREFERRED_MODE_CHANGED = "android.telecom.action.TTY_PREFERRED_MODE_CHANGED";
    public static final String EXTRA_TTY_PREFERRED_MODE = "android.telecom.intent.extra.TTY_PREFERRED";
    public static final int PRESENTATION_ALLOWED = 1;
    public static final int PRESENTATION_RESTRICTED = 2;
    public static final int PRESENTATION_UNKNOWN = 3;
    public static final int PRESENTATION_PAYPHONE = 4;
    private static final String TAG = "TelecomManager";
    private final Context mContext;

    public static TelecomManager from(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    public TelecomManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
    }

    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultOutgoingPhoneAccount(uriScheme);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getDefaultOutgoingPhoneAccount", e);
        }
        return null;
    }

    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getUserSelectedOutgoingPhoneAccount();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getUserSelectedOutgoingPhoneAccount", e);
        }
        return null;
    }

    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setUserSelectedOutgoingPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#setUserSelectedOutgoingPhoneAccount");
        }
    }

    public PhoneAccountHandle getSimCallManager() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManager();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getSimCallManager");
        }
        return null;
    }

    public void setSimCallManager(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setSimCallManager(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#setSimCallManager");
        }
    }

    public List<PhoneAccountHandle> getSimCallManagers() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManagers();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getSimCallManagers");
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsSupportingScheme(uriScheme);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsSupportingScheme", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallCapablePhoneAccounts();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getCallCapablePhoneAccounts", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public boolean hasMultipleCallCapableAccounts() {
        return this.getCallCapablePhoneAccounts().size() > 1;
    }

    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsForPackage(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsForPackage", e);
        }
        return null;
    }

    public PhoneAccount getPhoneAccount(PhoneAccountHandle account) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccount", e);
        }
        return null;
    }

    public int getAllPhoneAccountsCount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountsCount();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountsCount", e);
        }
        return 0;
    }

    public List<PhoneAccount> getAllPhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccounts();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccounts", e);
        }
        return Collections.EMPTY_LIST;
    }

    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountHandles();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountHandles", e);
        }
        return Collections.EMPTY_LIST;
    }

    public void registerPhoneAccount(PhoneAccount account) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().registerPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#registerPhoneAccount", e);
        }
    }

    public void unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().unregisterPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#unregisterPhoneAccount", e);
        }
    }

    public void clearAccounts() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().clearAccounts(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#clearAccounts", e);
        }
    }

    public ComponentName getDefaultPhoneApp() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultPhoneApp();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException attempting to get the default phone app.", e);
        }
        return null;
    }

    public boolean isInCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isInCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException calling isInCall().", e);
        }
        return false;
    }

    public int getCallState() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallState();
            }
        }
        catch (RemoteException e) {
            Log.d(TAG, "RemoteException calling getCallState().", e);
        }
        return 0;
    }

    public boolean isRinging() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isRinging();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException attempting to get ringing state of phone app.", e);
        }
        return false;
    }

    public boolean endCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().endCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#endCall", e);
        }
        return false;
    }

    public void acceptRingingCall() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().acceptRingingCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#acceptRingingCall", e);
        }
    }

    public void silenceRinger() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().silenceRinger();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", e);
        }
    }

    public boolean isTtySupported() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isTtySupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException attempting to get TTY supported state.", e);
        }
        return false;
    }

    public int getCurrentTtyMode() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCurrentTtyMode();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException attempting to get the current TTY mode.", e);
        }
        return 0;
    }

    public void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewIncomingCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException adding a new incoming call: " + phoneAccount, e);
        }
    }

    public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewUnknownCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException adding a new unknown call: " + phoneAccount, e);
        }
    }

    public boolean handleMmi(String dialString) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmi(dialString);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    public void cancelMissedCallsNotification() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.cancelMissedCallsNotification();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#cancelMissedCallsNotification", e);
            }
        }
    }

    public void showInCallScreen(boolean showDialpad) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.showInCallScreen(showDialpad);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#showCallScreen", e);
            }
        }
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    private boolean isServiceConnected() {
        boolean isConnected;
        boolean bl = isConnected = this.getTelecomService() != null;
        if (!isConnected) {
            Log.w(TAG, "Telecom Service not found.");
        }
        return isConnected;
    }
}

