/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import java.util.MissingResourceException;
import java.util.Objects;

public final class StatusHints
implements Parcelable {
    private final ComponentName mPackageName;
    private final CharSequence mLabel;
    private final int mIconResId;
    private final Bundle mExtras;
    public static final Parcelable.Creator<StatusHints> CREATOR = new Parcelable.Creator<StatusHints>(){

        @Override
        public StatusHints createFromParcel(Parcel in) {
            return new StatusHints(in);
        }

        public StatusHints[] newArray(int size) {
            return new StatusHints[size];
        }
    };

    public StatusHints(ComponentName packageName, CharSequence label, int iconResId, Bundle extras) {
        this.mPackageName = packageName;
        this.mLabel = label;
        this.mIconResId = iconResId;
        this.mExtras = extras;
    }

    public ComponentName getPackageName() {
        return this.mPackageName;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public int getIconResId() {
        return this.mIconResId;
    }

    public Drawable getIcon(Context context) {
        return this.getIcon(context, this.mIconResId);
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mPackageName, flags);
        out.writeCharSequence(this.mLabel);
        out.writeInt(this.mIconResId);
        out.writeParcelable(this.mExtras, 0);
    }

    private StatusHints(Parcel in) {
        this.mPackageName = (ComponentName)in.readParcelable(this.getClass().getClassLoader());
        this.mLabel = in.readCharSequence();
        this.mIconResId = in.readInt();
        this.mExtras = (Bundle)in.readParcelable(this.getClass().getClassLoader());
    }

    private Drawable getIcon(Context context, int resId) {
        Context packageContext;
        try {
            packageContext = context.createPackageContext(this.mPackageName.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(this, (Throwable)e, "Cannot find package %s", this.mPackageName.getPackageName());
            return null;
        }
        try {
            return packageContext.getDrawable(resId);
        }
        catch (MissingResourceException e) {
            Log.e(this, (Throwable)e, "Cannot find icon %d in package %s", resId, this.mPackageName.getPackageName());
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof StatusHints) {
            StatusHints otherHints = (StatusHints)other;
            return Objects.equals(otherHints.getPackageName(), this.getPackageName()) && Objects.equals(otherHints.getLabel(), this.getLabel()) && otherHints.getIconResId() == this.getIconResId() && Objects.equals(otherHints.getExtras(), this.getExtras());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.mPackageName) + Objects.hashCode(this.mLabel) + this.mIconResId + Objects.hashCode(this.mExtras);
    }
}

