/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.InCallAdapter;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IInCallAdapter;
import com.android.internal.telecom.IInCallService;

public abstract class InCallService
extends Service {
    public static final String SERVICE_INTERFACE = "android.telecom.InCallService";
    private static final int MSG_SET_IN_CALL_ADAPTER = 1;
    private static final int MSG_ADD_CALL = 2;
    private static final int MSG_UPDATE_CALL = 3;
    private static final int MSG_SET_POST_DIAL_WAIT = 4;
    private static final int MSG_ON_AUDIO_STATE_CHANGED = 5;
    private static final int MSG_BRING_TO_FOREGROUND = 6;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (InCallService.this.mPhone == null && msg.what != 1) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    InCallService.this.mPhone = new Phone(new InCallAdapter((IInCallAdapter)msg.obj));
                    InCallService.this.onPhoneCreated(InCallService.this.mPhone);
                    break;
                }
                case 2: {
                    InCallService.this.mPhone.internalAddCall((ParcelableCall)msg.obj);
                    break;
                }
                case 3: {
                    InCallService.this.mPhone.internalUpdateCall((ParcelableCall)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        String remaining = (String)args.arg2;
                        InCallService.this.mPhone.internalSetPostDialWait(callId, remaining);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    InCallService.this.mPhone.internalAudioStateChanged((AudioState)msg.obj);
                    break;
                }
                case 6: {
                    InCallService.this.mPhone.internalBringToForeground(msg.arg1 == 1);
                    break;
                }
            }
        }
    };
    private Phone mPhone;

    @Override
    public IBinder onBind(Intent intent) {
        return new InCallServiceBinder();
    }

    @Override
    public boolean onUnbind(Intent intent) {
        if (this.mPhone != null) {
            Phone oldPhone = this.mPhone;
            this.mPhone = null;
            oldPhone.destroy();
            this.onPhoneDestroyed(oldPhone);
        }
        return false;
    }

    public Phone getPhone() {
        return this.mPhone;
    }

    public void onPhoneCreated(Phone phone) {
    }

    public void onPhoneDestroyed(Phone phone) {
    }

    public static abstract class VideoCall {
        public abstract void setVideoCallListener(Listener var1);

        public abstract void setCamera(String var1);

        public abstract void setPreviewSurface(Surface var1);

        public abstract void setDisplaySurface(Surface var1);

        public abstract void setDeviceOrientation(int var1);

        public abstract void setZoom(float var1);

        public abstract void sendSessionModifyRequest(VideoProfile var1);

        public abstract void sendSessionModifyResponse(VideoProfile var1);

        public abstract void requestCameraCapabilities();

        public abstract void requestCallDataUsage();

        public abstract void setPauseImage(String var1);

        public static abstract class Listener {
            public abstract void onSessionModifyRequestReceived(VideoProfile var1);

            public abstract void onSessionModifyResponseReceived(int var1, VideoProfile var2, VideoProfile var3);

            public abstract void onCallSessionEvent(int var1);

            public abstract void onPeerDimensionsChanged(int var1, int var2);

            public abstract void onCallDataUsageChanged(int var1);

            public abstract void onCameraCapabilitiesChanged(CameraCapabilities var1);
        }
    }

    private final class InCallServiceBinder
    extends IInCallService.Stub {
        private InCallServiceBinder() {
        }

        @Override
        public void setInCallAdapter(IInCallAdapter inCallAdapter) {
            InCallService.this.mHandler.obtainMessage(1, inCallAdapter).sendToTarget();
        }

        @Override
        public void addCall(ParcelableCall call) {
            InCallService.this.mHandler.obtainMessage(2, call).sendToTarget();
        }

        @Override
        public void updateCall(ParcelableCall call) {
            InCallService.this.mHandler.obtainMessage(3, call).sendToTarget();
        }

        @Override
        public void setPostDial(String callId, String remaining) {
        }

        @Override
        public void setPostDialWait(String callId, String remaining) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = remaining;
            InCallService.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onAudioStateChanged(AudioState audioState) {
            InCallService.this.mHandler.obtainMessage(5, audioState).sendToTarget();
        }

        @Override
        public void bringToForeground(boolean showDialpad) {
            InCallService.this.mHandler.obtainMessage(6, showDialpad ? 1 : 0, 0).sendToTarget();
        }
    }
}

