/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public final class DisconnectCause
implements Parcelable {
    public static final int UNKNOWN = 0;
    public static final int ERROR = 1;
    public static final int LOCAL = 2;
    public static final int REMOTE = 3;
    public static final int CANCELED = 4;
    public static final int MISSED = 5;
    public static final int REJECTED = 6;
    public static final int BUSY = 7;
    public static final int RESTRICTED = 8;
    public static final int OTHER = 9;
    private int mDisconnectCode;
    private CharSequence mDisconnectLabel;
    private CharSequence mDisconnectDescription;
    private String mDisconnectReason;
    private int mToneToPlay;
    public static final Parcelable.Creator<DisconnectCause> CREATOR = new Parcelable.Creator<DisconnectCause>(){

        @Override
        public DisconnectCause createFromParcel(Parcel source) {
            int code = source.readInt();
            CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            CharSequence description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            String reason = source.readString();
            int tone = source.readInt();
            return new DisconnectCause(code, label, description, reason, tone);
        }

        public DisconnectCause[] newArray(int size) {
            return new DisconnectCause[size];
        }
    };

    public DisconnectCause(int code) {
        this(code, null, null, null, -1);
    }

    public DisconnectCause(int code, String reason) {
        this(code, null, null, reason, -1);
    }

    public DisconnectCause(int code, CharSequence label, CharSequence description, String reason) {
        this(code, label, description, reason, -1);
    }

    public DisconnectCause(int code, CharSequence label, CharSequence description, String reason, int toneToPlay) {
        this.mDisconnectCode = code;
        this.mDisconnectLabel = label;
        this.mDisconnectDescription = description;
        this.mDisconnectReason = reason;
        this.mToneToPlay = toneToPlay;
    }

    public int getCode() {
        return this.mDisconnectCode;
    }

    public CharSequence getLabel() {
        return this.mDisconnectLabel;
    }

    public CharSequence getDescription() {
        return this.mDisconnectDescription;
    }

    public String getReason() {
        return this.mDisconnectReason;
    }

    public int getTone() {
        return this.mToneToPlay;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeInt(this.mDisconnectCode);
        TextUtils.writeToParcel(this.mDisconnectLabel, destination, flags);
        TextUtils.writeToParcel(this.mDisconnectDescription, destination, flags);
        destination.writeString(this.mDisconnectReason);
        destination.writeInt(this.mToneToPlay);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.mDisconnectCode) + Objects.hashCode(this.mDisconnectLabel) + Objects.hashCode(this.mDisconnectDescription) + Objects.hashCode(this.mDisconnectReason) + Objects.hashCode(this.mToneToPlay);
    }

    public boolean equals(Object o) {
        if (o instanceof DisconnectCause) {
            DisconnectCause d = (DisconnectCause)o;
            return Objects.equals(this.mDisconnectCode, d.getCode()) && Objects.equals(this.mDisconnectLabel, d.getLabel()) && Objects.equals(this.mDisconnectDescription, d.getDescription()) && Objects.equals(this.mDisconnectReason, d.getReason()) && Objects.equals(this.mToneToPlay, d.getTone());
        }
        return false;
    }

    public String toString() {
        String code = "";
        switch (this.getCode()) {
            case 1: {
                code = "ERROR";
                break;
            }
            case 2: {
                code = "LOCAL";
                break;
            }
            case 3: {
                code = "REMOTE";
                break;
            }
            case 5: {
                code = "MISSED";
                break;
            }
            case 6: {
                code = "REJECTED";
                break;
            }
            case 7: {
                code = "BUSY";
                break;
            }
            case 8: {
                code = "RESTRICTED";
                break;
            }
            case 9: {
                code = "OTHER";
                break;
            }
            default: {
                code = "UNKNOWN";
            }
        }
        String label = this.mDisconnectLabel == null ? "" : this.mDisconnectLabel.toString();
        String description = this.mDisconnectDescription == null ? "" : this.mDisconnectDescription.toString();
        String reason = this.mDisconnectReason == null ? "" : this.mDisconnectReason;
        return "DisconnectCause [ Code: (" + code + ")" + " Label: (" + label + ")" + " Description: (" + description + ")" + " Reason: (" + reason + ")" + " Tone: (" + this.mToneToPlay + ") ]";
    }
}

