/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.PlaybackQueueItem;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

class AudioPlaybackHandler {
    private static final String TAG = "TTS.AudioPlaybackHandler";
    private static final boolean DBG = false;
    private final LinkedBlockingQueue<PlaybackQueueItem> mQueue = new LinkedBlockingQueue();
    private final Thread mHandlerThread = new Thread((Runnable)new MessageLoop(), "TTS.AudioPlaybackThread");
    private volatile PlaybackQueueItem mCurrentWorkItem = null;

    AudioPlaybackHandler() {
    }

    public void start() {
        this.mHandlerThread.start();
    }

    private void stop(PlaybackQueueItem item) {
        if (item == null) {
            return;
        }
        item.stop(-2);
    }

    public void enqueue(PlaybackQueueItem item) {
        try {
            this.mQueue.put(item);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopForApp(Object callerIdentity) {
        this.removeWorkItemsFor(callerIdentity);
        PlaybackQueueItem current = this.mCurrentWorkItem;
        if (current != null && current.getCallerIdentity() == callerIdentity) {
            this.stop(current);
        }
    }

    public void stop() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
    }

    public boolean isSpeaking() {
        return this.mQueue.peek() != null || this.mCurrentWorkItem != null;
    }

    public void quit() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
        this.mHandlerThread.interrupt();
    }

    private void removeAllMessages() {
        this.mQueue.clear();
    }

    private void removeWorkItemsFor(Object callerIdentity) {
        Iterator<PlaybackQueueItem> it = this.mQueue.iterator();
        while (it.hasNext()) {
            PlaybackQueueItem item = it.next();
            if (item.getCallerIdentity() != callerIdentity) continue;
            it.remove();
        }
    }

    private final class MessageLoop
    implements Runnable {
        private MessageLoop() {
        }

        @Override
        public void run() {
            while (true) {
                PlaybackQueueItem item = null;
                try {
                    item = (PlaybackQueueItem)AudioPlaybackHandler.this.mQueue.take();
                }
                catch (InterruptedException ie) {
                    return;
                }
                AudioPlaybackHandler.this.mCurrentWorkItem = item;
                item.run();
                AudioPlaybackHandler.this.mCurrentWorkItem = null;
            }
        }
    }
}

