/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.R;
import android.app.Dialog;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.SoftInputWindow;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.lang.ref.WeakReference;

public abstract class VoiceInteractionSession
implements KeyEvent.Callback {
    static final String TAG = "VoiceInteractionSession";
    static final boolean DEBUG = true;
    final Context mContext;
    final HandlerCaller mHandlerCaller;
    final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();
    IVoiceInteractionManagerService mSystemService;
    IBinder mToken;
    int mTheme = 0;
    LayoutInflater mInflater;
    TypedArray mThemeAttrs;
    View mRootView;
    FrameLayout mContentFrame;
    SoftInputWindow mWindow;
    boolean mInitialized;
    boolean mWindowAdded;
    boolean mWindowVisible;
    boolean mWindowWasVisible;
    boolean mInShowWindow;
    final ArrayMap<IBinder, Request> mActiveRequests = new ArrayMap();
    final Insets mTmpInsets = new Insets();
    final int[] mTmpLocation = new int[2];
    final WeakReference<VoiceInteractionSession> mWeakRef = new WeakReference<VoiceInteractionSession>(this);
    final IVoiceInteractor mInteractor = new IVoiceInteractor.Stub(){

        @Override
        public IVoiceInteractorRequest startConfirmation(String callingPackage, IVoiceInteractorCallback callback, CharSequence prompt, Bundle extras) {
            Request request = VoiceInteractionSession.this.newRequest(callback);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(1, new Caller(callingPackage, Binder.getCallingUid()), request, prompt, extras));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startCompleteVoice(String callingPackage, IVoiceInteractorCallback callback, CharSequence message, Bundle extras) {
            Request request = VoiceInteractionSession.this.newRequest(callback);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(2, new Caller(callingPackage, Binder.getCallingUid()), request, message, extras));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startAbortVoice(String callingPackage, IVoiceInteractorCallback callback, CharSequence message, Bundle extras) {
            Request request = VoiceInteractionSession.this.newRequest(callback);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(3, new Caller(callingPackage, Binder.getCallingUid()), request, message, extras));
            return request.mInterface;
        }

        @Override
        public IVoiceInteractorRequest startCommand(String callingPackage, IVoiceInteractorCallback callback, String command, Bundle extras) {
            Request request = VoiceInteractionSession.this.newRequest(callback);
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageOOOO(4, new Caller(callingPackage, Binder.getCallingUid()), request, command, extras));
            return request.mInterface;
        }

        @Override
        public boolean[] supportsCommands(String callingPackage, String[] commands) {
            Message msg = VoiceInteractionSession.this.mHandlerCaller.obtainMessageIOO(5, 0, new Caller(callingPackage, Binder.getCallingUid()), commands);
            SomeArgs args = VoiceInteractionSession.this.mHandlerCaller.sendMessageAndWait(msg);
            if (args != null) {
                boolean[] res = (boolean[])args.arg1;
                args.recycle();
                return res;
            }
            return new boolean[commands.length];
        }
    };
    final IVoiceInteractionSession mSession = new IVoiceInteractionSession.Stub(){

        @Override
        public void taskStarted(Intent intent, int taskId) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(100, taskId, intent));
        }

        @Override
        public void taskFinished(Intent intent, int taskId) {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessageIO(101, taskId, intent));
        }

        @Override
        public void closeSystemDialogs() {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(102));
        }

        @Override
        public void destroy() {
            VoiceInteractionSession.this.mHandlerCaller.sendMessage(VoiceInteractionSession.this.mHandlerCaller.obtainMessage(103));
        }
    };
    static final int MSG_START_CONFIRMATION = 1;
    static final int MSG_START_COMPLETE_VOICE = 2;
    static final int MSG_START_ABORT_VOICE = 3;
    static final int MSG_START_COMMAND = 4;
    static final int MSG_SUPPORTS_COMMANDS = 5;
    static final int MSG_CANCEL = 6;
    static final int MSG_TASK_STARTED = 100;
    static final int MSG_TASK_FINISHED = 101;
    static final int MSG_CLOSE_SYSTEM_DIALOGS = 102;
    static final int MSG_DESTROY = 103;
    final MyCallbacks mCallbacks = new MyCallbacks();
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

        @Override
        public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo info) {
            VoiceInteractionSession.this.onComputeInsets(VoiceInteractionSession.this.mTmpInsets);
            info.contentInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
            info.visibleInsets.set(VoiceInteractionSession.this.mTmpInsets.contentInsets);
            info.touchableRegion.set(VoiceInteractionSession.this.mTmpInsets.touchableRegion);
            info.setTouchableInsets(VoiceInteractionSession.this.mTmpInsets.touchableInsets);
        }
    };

    public VoiceInteractionSession(Context context) {
        this(context, new Handler());
    }

    public VoiceInteractionSession(Context context, Handler handler) {
        this.mContext = context;
        this.mHandlerCaller = new HandlerCaller(context, handler.getLooper(), this.mCallbacks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request newRequest(IVoiceInteractorCallback callback) {
        VoiceInteractionSession voiceInteractionSession = this;
        synchronized (voiceInteractionSession) {
            Request req = new Request(callback, this);
            this.mActiveRequests.put(req.mInterface.asBinder(), req);
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request removeRequest(IBinder reqInterface) {
        VoiceInteractionSession voiceInteractionSession = this;
        synchronized (voiceInteractionSession) {
            Request req = this.mActiveRequests.get(reqInterface);
            if (req != null) {
                this.mActiveRequests.remove(req);
            }
            return req;
        }
    }

    void doCreate(IVoiceInteractionManagerService service, IBinder token, Bundle args) {
        this.mSystemService = service;
        this.mToken = token;
        this.onCreate(args);
    }

    void doDestroy() {
        this.onDestroy();
        if (this.mInitialized) {
            this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            if (this.mWindowAdded) {
                this.mWindow.dismiss();
                this.mWindowAdded = false;
            }
            this.mInitialized = false;
        }
    }

    void initViews() {
        this.mInitialized = true;
        this.mThemeAttrs = this.mContext.obtainStyledAttributes(R.styleable.VoiceInteractionSession);
        this.mRootView = this.mInflater.inflate(17367272, null);
        this.mRootView.setSystemUiVisibility(768);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mContentFrame = (FrameLayout)this.mRootView.findViewById(0x1020002);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showWindow() {
        Log.v(TAG, "Showing window: mWindowAdded=" + this.mWindowAdded + " mWindowVisible=" + this.mWindowVisible);
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mInShowWindow = true;
            if (!this.mWindowVisible) {
                this.mWindowVisible = true;
                if (!this.mWindowAdded) {
                    this.mWindowAdded = true;
                    View v = this.onCreateContentView();
                    if (v != null) {
                        this.setContentView(v);
                    }
                }
                this.mWindow.show();
            }
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    public void hideWindow() {
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
        }
    }

    public void setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    public void startVoiceActivity(Intent intent) {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess();
            int res = this.mSystemService.startVoiceActivity(this.mToken, intent, intent.resolveType(this.mContext.getContentResolver()));
            Instrumentation.checkStartActivityResult(res, intent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void finish() {
        if (this.mToken == null) {
            throw new IllegalStateException("Can't call before onCreate()");
        }
        this.hideWindow();
        try {
            this.mSystemService.finish(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onCreate(Bundle args) {
        this.mTheme = this.mTheme != 0 ? this.mTheme : 16974982;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this.mContext, TAG, this.mTheme, this.mCallbacks, this, this.mDispatcherState, 2031, 48, true);
        this.mWindow.getWindow().addFlags(0x1000000);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
        this.mWindow.setToken(this.mToken);
    }

    public void onDestroy() {
    }

    public View onCreateContentView() {
        return null;
    }

    public void setContentView(View view) {
        this.mContentFrame.removeAllViews();
        this.mContentFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return false;
    }

    public void onBackPressed() {
        this.finish();
    }

    public void onCloseSystemDialogs() {
        this.finish();
    }

    public void onComputeInsets(Insets outInsets) {
        int[] loc = this.mTmpLocation;
        View decor = this.getWindow().getWindow().getDecorView();
        decor.getLocationInWindow(loc);
        outInsets.contentInsets.top = 0;
        outInsets.contentInsets.left = 0;
        outInsets.contentInsets.right = 0;
        outInsets.contentInsets.bottom = 0;
        outInsets.touchableInsets = 0;
        outInsets.touchableRegion.setEmpty();
    }

    public void onTaskStarted(Intent intent, int taskId) {
    }

    public void onTaskFinished(Intent intent, int taskId) {
        this.finish();
    }

    public boolean[] onGetSupportedCommands(Caller caller, String[] commands) {
        return new boolean[commands.length];
    }

    public abstract void onConfirm(Caller var1, Request var2, CharSequence var3, Bundle var4);

    public void onCompleteVoice(Caller caller, Request request, CharSequence message, Bundle extras) {
        request.sendCompleteVoiceResult(null);
    }

    public void onAbortVoice(Caller caller, Request request, CharSequence message, Bundle extras) {
        request.sendAbortVoiceResult(null);
    }

    public abstract void onCommand(Caller var1, Request var2, String var3, Bundle var4);

    public abstract void onCancel(Request var1);

    public static final class Insets {
        public final Rect contentInsets = new Rect();
        public final Region touchableRegion = new Region();
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;
    }

    class MyCallbacks
    implements HandlerCaller.Callback,
    SoftInputWindow.Callback {
        MyCallbacks() {
        }

        @Override
        public void executeMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onConfirm: req=" + ((Request)args.arg2).mInterface + " prompt=" + args.arg3 + " extras=" + args.arg4);
                    VoiceInteractionSession.this.onConfirm((Caller)args.arg1, (Request)args.arg2, (CharSequence)args.arg3, (Bundle)args.arg4);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCompleteVoice: req=" + ((Request)args.arg2).mInterface + " message=" + args.arg3 + " extras=" + args.arg4);
                    VoiceInteractionSession.this.onCompleteVoice((Caller)args.arg1, (Request)args.arg2, (CharSequence)args.arg3, (Bundle)args.arg4);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onAbortVoice: req=" + ((Request)args.arg2).mInterface + " message=" + args.arg3 + " extras=" + args.arg4);
                    VoiceInteractionSession.this.onAbortVoice((Caller)args.arg1, (Request)args.arg2, (CharSequence)args.arg3, (Bundle)args.arg4);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCommand: req=" + ((Request)args.arg2).mInterface + " command=" + args.arg3 + " extras=" + args.arg4);
                    VoiceInteractionSession.this.onCommand((Caller)args.arg1, (Request)args.arg2, (String)args.arg3, (Bundle)args.arg4);
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onGetSupportedCommands: cmds=" + args.arg2);
                    args.arg1 = VoiceInteractionSession.this.onGetSupportedCommands((Caller)args.arg1, (String[])args.arg2);
                    break;
                }
                case 6: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.d(VoiceInteractionSession.TAG, "onCancel: req=" + ((Request)args.arg1).mInterface);
                    VoiceInteractionSession.this.onCancel((Request)args.arg1);
                    break;
                }
                case 100: {
                    Log.d(VoiceInteractionSession.TAG, "onTaskStarted: intent=" + msg.obj + " taskId=" + msg.arg1);
                    VoiceInteractionSession.this.onTaskStarted((Intent)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    Log.d(VoiceInteractionSession.TAG, "onTaskFinished: intent=" + msg.obj + " taskId=" + msg.arg1);
                    VoiceInteractionSession.this.onTaskFinished((Intent)msg.obj, msg.arg1);
                    break;
                }
                case 102: {
                    Log.d(VoiceInteractionSession.TAG, "onCloseSystemDialogs");
                    VoiceInteractionSession.this.onCloseSystemDialogs();
                    break;
                }
                case 103: {
                    Log.d(VoiceInteractionSession.TAG, "doDestroy");
                    VoiceInteractionSession.this.doDestroy();
                }
            }
        }

        @Override
        public void onBackPressed() {
            VoiceInteractionSession.this.onBackPressed();
        }
    }

    public static class Caller {
        final String packageName;
        final int uid;

        Caller(String _packageName, int _uid) {
            this.packageName = _packageName;
            this.uid = _uid;
        }
    }

    public static class Request {
        final IVoiceInteractorRequest mInterface = new IVoiceInteractorRequest.Stub(){

            @Override
            public void cancel() throws RemoteException {
                VoiceInteractionSession session = (VoiceInteractionSession)Request.this.mSession.get();
                if (session != null) {
                    session.mHandlerCaller.sendMessage(session.mHandlerCaller.obtainMessageO(6, Request.this));
                }
            }
        };
        final IVoiceInteractorCallback mCallback;
        final WeakReference<VoiceInteractionSession> mSession;

        Request(IVoiceInteractorCallback callback, VoiceInteractionSession session) {
            this.mCallback = callback;
            this.mSession = session.mWeakRef;
        }

        void finishRequest() {
            VoiceInteractionSession session = (VoiceInteractionSession)this.mSession.get();
            if (session == null) {
                throw new IllegalStateException("VoiceInteractionSession has been destroyed");
            }
            Request req = session.removeRequest(this.mInterface.asBinder());
            if (req == null) {
                throw new IllegalStateException("Request not active: " + this);
            }
            if (req != this) {
                throw new IllegalStateException("Current active request " + req + " not same as calling request " + this);
            }
        }

        public void sendConfirmResult(boolean confirmed, Bundle result) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendConfirmResult: req=" + this.mInterface + " confirmed=" + confirmed + " result=" + result);
                this.finishRequest();
                this.mCallback.deliverConfirmationResult(this.mInterface, confirmed, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendCompleteVoiceResult(Bundle result) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCompleteVoiceResult: req=" + this.mInterface + " result=" + result);
                this.finishRequest();
                this.mCallback.deliverCompleteVoiceResult(this.mInterface, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendAbortVoiceResult(Bundle result) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendConfirmResult: req=" + this.mInterface + " result=" + result);
                this.finishRequest();
                this.mCallback.deliverAbortVoiceResult(this.mInterface, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendCommandResult(boolean complete, Bundle result) {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCommandResult: req=" + this.mInterface + " result=" + result);
                this.finishRequest();
                this.mCallback.deliverCommandResult(this.mInterface, complete, result);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void sendCancelResult() {
            try {
                Log.d(VoiceInteractionSession.TAG, "sendCancelResult: req=" + this.mInterface);
                this.finishRequest();
                this.mCallback.deliverCancel(this.mInterface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

