/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.ComponentName;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.notification.Condition;
import android.text.TextUtils;
import android.util.Slog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeConfig
implements Parcelable {
    private static String TAG = "ZenModeConfig";
    public static final String SLEEP_MODE_NIGHTS = "nights";
    public static final String SLEEP_MODE_WEEKNIGHTS = "weeknights";
    public static final String SLEEP_MODE_DAYS_PREFIX = "days:";
    public static final int SOURCE_ANYONE = 0;
    public static final int SOURCE_CONTACT = 1;
    public static final int SOURCE_STAR = 2;
    public static final int MAX_SOURCE = 2;
    public static final int[] ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final int[] WEEKNIGHT_DAYS = new int[]{1, 2, 3, 4, 5};
    public static final int[] MINUTE_BUCKETS = new int[]{15, 30, 45, 60, 120, 180, 240, 480};
    private static final int SECONDS_MS = 1000;
    private static final int MINUTES_MS = 60000;
    private static final int ZERO_VALUE_MS = 20000;
    private static final boolean DEFAULT_ALLOW_EVENTS = true;
    private static final int XML_VERSION = 1;
    private static final String ZEN_TAG = "zen";
    private static final String ZEN_ATT_VERSION = "version";
    private static final String ALLOW_TAG = "allow";
    private static final String ALLOW_ATT_CALLS = "calls";
    private static final String ALLOW_ATT_MESSAGES = "messages";
    private static final String ALLOW_ATT_FROM = "from";
    private static final String ALLOW_ATT_EVENTS = "events";
    private static final String SLEEP_TAG = "sleep";
    private static final String SLEEP_ATT_MODE = "mode";
    private static final String SLEEP_ATT_START_HR = "startHour";
    private static final String SLEEP_ATT_START_MIN = "startMin";
    private static final String SLEEP_ATT_END_HR = "endHour";
    private static final String SLEEP_ATT_END_MIN = "endMin";
    private static final String CONDITION_TAG = "condition";
    private static final String CONDITION_ATT_COMPONENT = "component";
    private static final String CONDITION_ATT_ID = "id";
    private static final String CONDITION_ATT_SUMMARY = "summary";
    private static final String CONDITION_ATT_LINE1 = "line1";
    private static final String CONDITION_ATT_LINE2 = "line2";
    private static final String CONDITION_ATT_ICON = "icon";
    private static final String CONDITION_ATT_STATE = "state";
    private static final String CONDITION_ATT_FLAGS = "flags";
    private static final String EXIT_CONDITION_TAG = "exitCondition";
    private static final String EXIT_CONDITION_ATT_COMPONENT = "component";
    public boolean allowCalls;
    public boolean allowMessages;
    public boolean allowEvents = true;
    public int allowFrom = 0;
    public String sleepMode;
    public int sleepStartHour;
    public int sleepStartMinute;
    public int sleepEndHour;
    public int sleepEndMinute;
    public ComponentName[] conditionComponents;
    public Uri[] conditionIds;
    public Condition exitCondition;
    public ComponentName exitConditionComponent;
    public static final Parcelable.Creator<ZenModeConfig> CREATOR = new Parcelable.Creator<ZenModeConfig>(){

        @Override
        public ZenModeConfig createFromParcel(Parcel source) {
            return new ZenModeConfig(source);
        }

        public ZenModeConfig[] newArray(int size) {
            return new ZenModeConfig[size];
        }
    };
    private static final String SYSTEM_AUTHORITY = "android";
    private static final String COUNTDOWN_PATH = "countdown";
    private static final String DOWNTIME_PATH = "downtime";

    public ZenModeConfig() {
    }

    public ZenModeConfig(Parcel source) {
        this.allowCalls = source.readInt() == 1;
        this.allowMessages = source.readInt() == 1;
        boolean bl = this.allowEvents = source.readInt() == 1;
        if (source.readInt() == 1) {
            this.sleepMode = source.readString();
        }
        this.sleepStartHour = source.readInt();
        this.sleepStartMinute = source.readInt();
        this.sleepEndHour = source.readInt();
        this.sleepEndMinute = source.readInt();
        int len = source.readInt();
        if (len > 0) {
            this.conditionComponents = new ComponentName[len];
            source.readTypedArray(this.conditionComponents, ComponentName.CREATOR);
        }
        if ((len = source.readInt()) > 0) {
            this.conditionIds = new Uri[len];
            source.readTypedArray(this.conditionIds, Uri.CREATOR);
        }
        this.allowFrom = source.readInt();
        this.exitCondition = (Condition)source.readParcelable(null);
        this.exitConditionComponent = (ComponentName)source.readParcelable(null);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.allowCalls ? 1 : 0);
        dest.writeInt(this.allowMessages ? 1 : 0);
        dest.writeInt(this.allowEvents ? 1 : 0);
        if (this.sleepMode != null) {
            dest.writeInt(1);
            dest.writeString(this.sleepMode);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.sleepStartHour);
        dest.writeInt(this.sleepStartMinute);
        dest.writeInt(this.sleepEndHour);
        dest.writeInt(this.sleepEndMinute);
        if (this.conditionComponents != null && this.conditionComponents.length > 0) {
            dest.writeInt(this.conditionComponents.length);
            dest.writeTypedArray(this.conditionComponents, 0);
        } else {
            dest.writeInt(0);
        }
        if (this.conditionIds != null && this.conditionIds.length > 0) {
            dest.writeInt(this.conditionIds.length);
            dest.writeTypedArray(this.conditionIds, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.allowFrom);
        dest.writeParcelable(this.exitCondition, 0);
        dest.writeParcelable(this.exitConditionComponent, 0);
    }

    public String toString() {
        return ZenModeConfig.class.getSimpleName() + '[' + "allowCalls=" + this.allowCalls + ",allowMessages=" + this.allowMessages + ",allowFrom=" + ZenModeConfig.sourceToString(this.allowFrom) + ",allowEvents=" + this.allowEvents + ",sleepMode=" + this.sleepMode + ",sleepStart=" + this.sleepStartHour + '.' + this.sleepStartMinute + ",sleepEnd=" + this.sleepEndHour + '.' + this.sleepEndMinute + ",conditionComponents=" + (this.conditionComponents == null ? null : TextUtils.join((CharSequence)",", this.conditionComponents)) + ",conditionIds=" + (this.conditionIds == null ? null : TextUtils.join((CharSequence)",", this.conditionIds)) + ",exitCondition=" + this.exitCondition + ",exitConditionComponent=" + this.exitConditionComponent + ']';
    }

    public static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: {
                return "stars";
            }
        }
        return "UNKNOWN";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZenModeConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenModeConfig other = (ZenModeConfig)o;
        return other.allowCalls == this.allowCalls && other.allowMessages == this.allowMessages && other.allowFrom == this.allowFrom && other.allowEvents == this.allowEvents && Objects.equals(other.sleepMode, this.sleepMode) && other.sleepStartHour == this.sleepStartHour && other.sleepStartMinute == this.sleepStartMinute && other.sleepEndHour == this.sleepEndHour && other.sleepEndMinute == this.sleepEndMinute && Objects.deepEquals(other.conditionComponents, this.conditionComponents) && Objects.deepEquals(other.conditionIds, this.conditionIds) && Objects.equals(other.exitCondition, this.exitCondition) && Objects.equals(other.exitConditionComponent, this.exitConditionComponent);
    }

    public int hashCode() {
        return Objects.hash(this.allowCalls, this.allowMessages, this.allowFrom, this.allowEvents, this.sleepMode, this.sleepStartHour, this.sleepStartMinute, this.sleepEndHour, this.sleepEndMinute, Arrays.hashCode(this.conditionComponents), Arrays.hashCode(this.conditionIds), this.exitCondition, this.exitConditionComponent);
    }

    public boolean isValid() {
        return ZenModeConfig.isValidHour(this.sleepStartHour) && ZenModeConfig.isValidMinute(this.sleepStartMinute) && ZenModeConfig.isValidHour(this.sleepEndHour) && ZenModeConfig.isValidMinute(this.sleepEndMinute) && ZenModeConfig.isValidSleepMode(this.sleepMode);
    }

    public static boolean isValidSleepMode(String sleepMode) {
        return sleepMode == null || sleepMode.equals(SLEEP_MODE_NIGHTS) || sleepMode.equals(SLEEP_MODE_WEEKNIGHTS) || ZenModeConfig.tryParseDays(sleepMode) != null;
    }

    public static int[] tryParseDays(String sleepMode) {
        if (sleepMode == null) {
            return null;
        }
        if (SLEEP_MODE_NIGHTS.equals(sleepMode = sleepMode.trim())) {
            return ALL_DAYS;
        }
        if (SLEEP_MODE_WEEKNIGHTS.equals(sleepMode)) {
            return WEEKNIGHT_DAYS;
        }
        if (!sleepMode.startsWith(SLEEP_MODE_DAYS_PREFIX)) {
            return null;
        }
        if (sleepMode.equals(SLEEP_MODE_DAYS_PREFIX)) {
            return null;
        }
        String[] tokens = sleepMode.substring(SLEEP_MODE_DAYS_PREFIX.length()).split(",");
        if (tokens.length == 0) {
            return null;
        }
        int[] rt = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int day = ZenModeConfig.tryParseInt(tokens[i], -1);
            if (day == -1) {
                return null;
            }
            rt[i] = day;
        }
        return rt;
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static ZenModeConfig readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return null;
        }
        String tag = parser.getName();
        if (!ZEN_TAG.equals(tag)) {
            return null;
        }
        ZenModeConfig rt = new ZenModeConfig();
        int version = ZenModeConfig.safeInt(parser, ZEN_ATT_VERSION, 1);
        ArrayList<ComponentName> conditionComponents = new ArrayList<ComponentName>();
        ArrayList<Uri> conditionIds = new ArrayList<Uri>();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && ZEN_TAG.equals(tag)) {
                if (!conditionComponents.isEmpty()) {
                    rt.conditionComponents = conditionComponents.toArray(new ComponentName[conditionComponents.size()]);
                    rt.conditionIds = conditionIds.toArray(new Uri[conditionIds.size()]);
                }
                return rt;
            }
            if (type != 2) continue;
            if (ALLOW_TAG.equals(tag)) {
                rt.allowCalls = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CALLS, false);
                rt.allowMessages = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_MESSAGES, false);
                rt.allowEvents = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_EVENTS, true);
                rt.allowFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_FROM, 0);
                if (rt.allowFrom >= 0 && rt.allowFrom <= 2) continue;
                throw new IndexOutOfBoundsException("bad source in config:" + rt.allowFrom);
            }
            if (SLEEP_TAG.equals(tag)) {
                String mode = parser.getAttributeValue(null, SLEEP_ATT_MODE);
                rt.sleepMode = ZenModeConfig.isValidSleepMode(mode) ? mode : null;
                int startHour = ZenModeConfig.safeInt(parser, SLEEP_ATT_START_HR, 0);
                int startMinute = ZenModeConfig.safeInt(parser, SLEEP_ATT_START_MIN, 0);
                int endHour = ZenModeConfig.safeInt(parser, SLEEP_ATT_END_HR, 0);
                int endMinute = ZenModeConfig.safeInt(parser, SLEEP_ATT_END_MIN, 0);
                rt.sleepStartHour = ZenModeConfig.isValidHour(startHour) ? startHour : 0;
                rt.sleepStartMinute = ZenModeConfig.isValidMinute(startMinute) ? startMinute : 0;
                rt.sleepEndHour = ZenModeConfig.isValidHour(endHour) ? endHour : 0;
                rt.sleepEndMinute = ZenModeConfig.isValidMinute(endMinute) ? endMinute : 0;
                continue;
            }
            if (CONDITION_TAG.equals(tag)) {
                ComponentName component = ZenModeConfig.safeComponentName(parser, "component");
                Uri conditionId = ZenModeConfig.safeUri(parser, CONDITION_ATT_ID);
                if (component == null || conditionId == null) continue;
                conditionComponents.add(component);
                conditionIds.add(conditionId);
                continue;
            }
            if (!EXIT_CONDITION_TAG.equals(tag)) continue;
            rt.exitCondition = ZenModeConfig.readConditionXml(parser);
            if (rt.exitCondition == null) continue;
            rt.exitConditionComponent = ZenModeConfig.safeComponentName(parser, "component");
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    public void writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, ZEN_TAG);
        out.attribute(null, ZEN_ATT_VERSION, Integer.toString(1));
        out.startTag(null, ALLOW_TAG);
        out.attribute(null, ALLOW_ATT_CALLS, Boolean.toString(this.allowCalls));
        out.attribute(null, ALLOW_ATT_MESSAGES, Boolean.toString(this.allowMessages));
        out.attribute(null, ALLOW_ATT_EVENTS, Boolean.toString(this.allowEvents));
        out.attribute(null, ALLOW_ATT_FROM, Integer.toString(this.allowFrom));
        out.endTag(null, ALLOW_TAG);
        out.startTag(null, SLEEP_TAG);
        if (this.sleepMode != null) {
            out.attribute(null, SLEEP_ATT_MODE, this.sleepMode);
        }
        out.attribute(null, SLEEP_ATT_START_HR, Integer.toString(this.sleepStartHour));
        out.attribute(null, SLEEP_ATT_START_MIN, Integer.toString(this.sleepStartMinute));
        out.attribute(null, SLEEP_ATT_END_HR, Integer.toString(this.sleepEndHour));
        out.attribute(null, SLEEP_ATT_END_MIN, Integer.toString(this.sleepEndMinute));
        out.endTag(null, SLEEP_TAG);
        if (this.conditionComponents != null && this.conditionIds != null && this.conditionComponents.length == this.conditionIds.length) {
            for (int i = 0; i < this.conditionComponents.length; ++i) {
                out.startTag(null, CONDITION_TAG);
                out.attribute(null, "component", this.conditionComponents[i].flattenToString());
                out.attribute(null, CONDITION_ATT_ID, this.conditionIds[i].toString());
                out.endTag(null, CONDITION_TAG);
            }
        }
        if (this.exitCondition != null && this.exitConditionComponent != null) {
            out.startTag(null, EXIT_CONDITION_TAG);
            out.attribute(null, "component", this.exitConditionComponent.flattenToString());
            ZenModeConfig.writeConditionXml(this.exitCondition, out);
            out.endTag(null, EXIT_CONDITION_TAG);
        }
        out.endTag(null, ZEN_TAG);
    }

    public static Condition readConditionXml(XmlPullParser parser) {
        Uri id2 = ZenModeConfig.safeUri(parser, CONDITION_ATT_ID);
        String summary = parser.getAttributeValue(null, CONDITION_ATT_SUMMARY);
        String line1 = parser.getAttributeValue(null, CONDITION_ATT_LINE1);
        String line2 = parser.getAttributeValue(null, CONDITION_ATT_LINE2);
        int icon = ZenModeConfig.safeInt(parser, CONDITION_ATT_ICON, -1);
        int state = ZenModeConfig.safeInt(parser, CONDITION_ATT_STATE, -1);
        int flags = ZenModeConfig.safeInt(parser, CONDITION_ATT_FLAGS, -1);
        try {
            return new Condition(id2, summary, line1, line2, icon, state, flags);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Unable to read condition xml", e);
            return null;
        }
    }

    public static void writeConditionXml(Condition c, XmlSerializer out) throws IOException {
        out.attribute(null, CONDITION_ATT_ID, c.id.toString());
        out.attribute(null, CONDITION_ATT_SUMMARY, c.summary);
        out.attribute(null, CONDITION_ATT_LINE1, c.line1);
        out.attribute(null, CONDITION_ATT_LINE2, c.line2);
        out.attribute(null, CONDITION_ATT_ICON, Integer.toString(c.icon));
        out.attribute(null, CONDITION_ATT_STATE, Integer.toString(c.state));
        out.attribute(null, CONDITION_ATT_FLAGS, Integer.toString(c.flags));
    }

    public static boolean isValidHour(int val) {
        return val >= 0 && val < 24;
    }

    public static boolean isValidMinute(int val) {
        return val >= 0 && val < 60;
    }

    private static boolean safeBoolean(XmlPullParser parser, String att, boolean defValue) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.valueOf(val);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseInt(val, defValue);
    }

    private static ComponentName safeComponentName(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return ComponentName.unflattenFromString(val);
    }

    private static Uri safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return Uri.parse(val);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenModeConfig copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    public DowntimeInfo toDowntimeInfo() {
        DowntimeInfo downtime = new DowntimeInfo();
        downtime.startHour = this.sleepStartHour;
        downtime.startMinute = this.sleepStartMinute;
        downtime.endHour = this.sleepEndHour;
        downtime.endMinute = this.sleepEndMinute;
        return downtime;
    }

    public static Condition toTimeCondition(int minutesFromNow) {
        long now = System.currentTimeMillis();
        long millis = minutesFromNow == 0 ? 20000L : (long)(minutesFromNow * 60000);
        return ZenModeConfig.toTimeCondition(now + millis, minutesFromNow);
    }

    public static Condition toTimeCondition(long time, int minutes) {
        int num = minutes < 60 ? minutes : Math.round((float)minutes / 60.0f);
        int resId = minutes < 60 ? 18087961 : 18087962;
        String caption = Resources.getSystem().getQuantityString(resId, num, num);
        Uri id2 = ZenModeConfig.toCountdownConditionId(time);
        return new Condition(id2, caption, "", "", 0, 1, 1);
    }

    public static Uri toCountdownConditionId(long time) {
        return new Uri.Builder().scheme(CONDITION_TAG).authority(SYSTEM_AUTHORITY).appendPath(COUNTDOWN_PATH).appendPath(Long.toString(time)).build();
    }

    public static long tryParseCountdownConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, SYSTEM_AUTHORITY)) {
            return 0L;
        }
        if (conditionId.getPathSegments().size() != 2 || !COUNTDOWN_PATH.equals(conditionId.getPathSegments().get(0))) {
            return 0L;
        }
        try {
            return Long.parseLong(conditionId.getPathSegments().get(1));
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error parsing countdown condition: " + conditionId, e);
            return 0L;
        }
    }

    public static boolean isValidCountdownConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L;
    }

    public static Uri toDowntimeConditionId(DowntimeInfo downtime) {
        return new Uri.Builder().scheme(CONDITION_TAG).authority(SYSTEM_AUTHORITY).appendPath(DOWNTIME_PATH).appendQueryParameter("start", downtime.startHour + "." + downtime.startMinute).appendQueryParameter("end", downtime.endHour + "." + downtime.endMinute).build();
    }

    public static DowntimeInfo tryParseDowntimeConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, SYSTEM_AUTHORITY) || conditionId.getPathSegments().size() != 1 || !DOWNTIME_PATH.equals(conditionId.getPathSegments().get(0))) {
            return null;
        }
        int[] start = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("start"));
        int[] end = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("end"));
        if (start == null || end == null) {
            return null;
        }
        DowntimeInfo downtime = new DowntimeInfo();
        downtime.startHour = start[0];
        downtime.startMinute = start[1];
        downtime.endHour = end[0];
        downtime.endMinute = end[1];
        return downtime;
    }

    private static int[] tryParseHourAndMinute(String value) {
        int[] nArray;
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        int i = value.indexOf(46);
        if (i < 1 || i >= value.length() - 1) {
            return null;
        }
        int hour = ZenModeConfig.tryParseInt(value.substring(0, i), -1);
        int minute = ZenModeConfig.tryParseInt(value.substring(i + 1), -1);
        if (ZenModeConfig.isValidHour(hour) && ZenModeConfig.isValidMinute(minute)) {
            int[] nArray2 = new int[2];
            nArray2[0] = hour;
            nArray = nArray2;
            nArray2[1] = minute;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public static boolean isValidDowntimeConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseDowntimeConditionId(conditionId) != null;
    }

    public static class DowntimeInfo {
        public int startHour;
        public int startMinute;
        public int endHour;
        public int endMinute;

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DowntimeInfo)) {
                return false;
            }
            DowntimeInfo other = (DowntimeInfo)o;
            return this.startHour == other.startHour && this.startMinute == other.startMinute && this.endHour == other.endHour && this.endMinute == other.endMinute;
        }
    }
}

