/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.util.Collections;
import java.util.List;

public abstract class NotificationListenerService
extends Service {
    private final String TAG = NotificationListenerService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int HINT_HOST_DISABLE_EFFECTS = 1;
    public static final int TRIM_FULL = 0;
    public static final int TRIM_LIGHT = 1;
    private INotificationListenerWrapper mWrapper = null;
    private RankingMap mRankingMap;
    private INotificationManager mNoMan;
    private int mCurrentUser;
    private Context mSystemContext;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    public void onNotificationPosted(StatusBarNotification sbn) {
    }

    public void onNotificationPosted(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationPosted(sbn);
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
    }

    public void onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationRemoved(sbn);
    }

    public void onListenerConnected() {
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    public void onListenerHintsChanged(int hints) {
    }

    public void onInterruptionFilterChanged(int interruptionFilter) {
    }

    private final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    public final void cancelNotification(String pkg, String tag, int id2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{key});
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    public final void cancelNotifications(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void setOnNotificationPostedTrim(int trim) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, trim);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        return this.getActiveNotifications(null, 0);
    }

    public StatusBarNotification[] getActiveNotifications(int trim) {
        return this.getActiveNotifications(null, trim);
    }

    public StatusBarNotification[] getActiveNotifications(String[] keys) {
        return this.getActiveNotifications(keys, 0);
    }

    public StatusBarNotification[] getActiveNotifications(String[] keys, int trim) {
        if (!this.isBound()) {
            return null;
        }
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, keys, trim);
            List<StatusBarNotification> list = parceledList.getList();
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                Notification notification = ((StatusBarNotification)list.get(i)).getNotification();
                Notification.Builder.rebuild(this.getContext(), notification);
            }
            return list.toArray(new StatusBarNotification[N]);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    public final int getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getHintsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final int getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final void requestListenerHints(int hints) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, hints);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void requestInterruptionFilter(int interruptionFilter) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, interruptionFilter);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public RankingMap getCurrentRanking() {
        return this.mRankingMap;
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper();
        }
        return this.mWrapper;
    }

    private boolean isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    public void registerAsSystemService(Context context, ComponentName componentName, int currentUser) throws RemoteException {
        this.mSystemContext = context;
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper();
        }
        INotificationManager noMan = this.getNotificationInterface();
        noMan.registerListener(this.mWrapper, componentName, currentUser);
        this.mCurrentUser = currentUser;
    }

    public void unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            noMan.unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    private void applyUpdate(NotificationRankingUpdate update) {
        this.mRankingMap = new RankingMap(update);
    }

    private Context getContext() {
        if (this.mSystemContext != null) {
            return this.mSystemContext;
        }
        return this;
    }

    public static class RankingMap
    implements Parcelable {
        private final NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArraySet<Object> mIntercepted;
        private ArrayMap<String, Integer> mVisibilityOverrides;
        public static final Parcelable.Creator<RankingMap> CREATOR = new Parcelable.Creator<RankingMap>(){

            @Override
            public RankingMap createFromParcel(Parcel source) {
                NotificationRankingUpdate rankingUpdate = (NotificationRankingUpdate)source.readParcelable(null);
                return new RankingMap(rankingUpdate);
            }

            public RankingMap[] newArray(int size) {
                return new RankingMap[size];
            }
        };

        private RankingMap(NotificationRankingUpdate rankingUpdate) {
            this.mRankingUpdate = rankingUpdate;
        }

        public String[] getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        public boolean getRanking(String key, Ranking outRanking) {
            int rank = this.getRank(key);
            outRanking.populate(key, rank, this.isAmbient(key), !this.isIntercepted(key), this.getVisibilityOverride(key));
            return rank >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRank(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer rank = this.mRanks.get(key);
            return rank != null ? rank : -1;
        }

        private boolean isAmbient(String key) {
            int firstAmbientIndex = this.mRankingUpdate.getFirstAmbientIndex();
            if (firstAmbientIndex < 0) {
                return false;
            }
            int rank = this.getRank(key);
            return rank >= 0 && rank >= firstAmbientIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isIntercepted(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
            }
            return this.mIntercepted.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getVisibilityOverride(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer overide = this.mVisibilityOverrides.get(key);
            if (overide == null) {
                return -1000;
            }
            return overide;
        }

        private void buildRanksLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mRanks.put(key, i);
            }
        }

        private void buildInterceptedSetLocked() {
            String[] dndInterceptedKeys = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(dndInterceptedKeys.length);
            Collections.addAll(this.mIntercepted, dndInterceptedKeys);
        }

        private void buildVisibilityOverridesLocked() {
            Bundle visibilityBundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(visibilityBundle.size());
            for (String key : visibilityBundle.keySet()) {
                this.mVisibilityOverrides.put(key, visibilityBundle.getInt(key));
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mRankingUpdate, flags);
        }
    }

    public static class Ranking {
        public static final int VISIBILITY_NO_OVERRIDE = -1000;
        private String mKey;
        private int mRank = -1;
        private boolean mIsAmbient;
        private boolean mMatchesInterruptionFilter;
        private int mVisibilityOverride;

        public String getKey() {
            return this.mKey;
        }

        public int getRank() {
            return this.mRank;
        }

        public boolean isAmbient() {
            return this.mIsAmbient;
        }

        public int getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        public boolean matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }

        private void populate(String key, int rank, boolean isAmbient, boolean matchesInterruptionFilter, int visibilityOverride) {
            this.mKey = key;
            this.mRank = rank;
            this.mIsAmbient = isAmbient;
            this.mMatchesInterruptionFilter = matchesInterruptionFilter;
            this.mVisibilityOverride = visibilityOverride;
        }
    }

    private class INotificationListenerWrapper
    extends INotificationListener.Stub {
        private INotificationListenerWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: Error receiving StatusBarNotification", e);
                return;
            }
            Notification.Builder.rebuild(NotificationListenerService.this.getContext(), sbn.getNotification());
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(update);
                try {
                    NotificationListenerService.this.onNotificationPosted(sbn, NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationPosted", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", e);
                return;
            }
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(update);
                try {
                    NotificationListenerService.this.onNotificationRemoved(sbn, NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationRemoved", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onListenerConnected(NotificationRankingUpdate update) {
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(update);
                try {
                    NotificationListenerService.this.onListenerConnected();
                }
                catch (Throwable t) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onListenerConnected", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
            INotificationListenerWrapper iNotificationListenerWrapper = NotificationListenerService.this.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                NotificationListenerService.this.applyUpdate(update);
                try {
                    NotificationListenerService.this.onNotificationRankingUpdate(NotificationListenerService.this.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(NotificationListenerService.this.TAG, "Error running onNotificationRankingUpdate", t);
                }
            }
        }

        @Override
        public void onListenerHintsChanged(int hints) throws RemoteException {
            try {
                NotificationListenerService.this.onListenerHintsChanged(hints);
            }
            catch (Throwable t) {
                Log.w(NotificationListenerService.this.TAG, "Error running onListenerHintsChanged", t);
            }
        }

        @Override
        public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
            try {
                NotificationListenerService.this.onInterruptionFilterChanged(interruptionFilter);
            }
            catch (Throwable t) {
                Log.w(NotificationListenerService.this.TAG, "Error running onInterruptionFilterChanged", t);
            }
        }
    }
}

