/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;

public abstract class SearchIndexablesProvider
extends ContentProvider {
    private static final String TAG = "IndexablesProvider";
    private String mAuthority;
    private UriMatcher mMatcher;
    private static final int MATCH_RES_CODE = 1;
    private static final int MATCH_RAW_CODE = 2;
    private static final int MATCH_NON_INDEXABLE_KEYS_CODE = 3;

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        this.mAuthority = info.authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "settings/indexables_xml_res", 1);
        this.mMatcher.addURI(this.mAuthority, "settings/indexables_raw", 2);
        this.mMatcher.addURI(this.mAuthority, "settings/non_indexables_key", 3);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.READ_SEARCH_INDEXABLES".equals(info.readPermission)) {
            throw new SecurityException("Provider must be protected by READ_SEARCH_INDEXABLES");
        }
        super.attachInfo(context, info);
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        switch (this.mMatcher.match(uri)) {
            case 1: {
                return this.queryXmlResources(null);
            }
            case 2: {
                return this.queryRawData(null);
            }
            case 3: {
                return this.queryNonIndexableKeys(null);
            }
        }
        throw new UnsupportedOperationException("Unknown Uri " + uri);
    }

    public abstract Cursor queryXmlResources(String[] var1);

    public abstract Cursor queryRawData(String[] var1);

    public abstract Cursor queryNonIndexableKeys(String[] var1);

    @Override
    public String getType(Uri uri) {
        switch (this.mMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/indexables_xml_res";
            }
            case 2: {
                return "vnd.android.cursor.dir/indexables_raw";
            }
            case 3: {
                return "vnd.android.cursor.dir/non_indexables_key";
            }
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    @Override
    public final Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    @Override
    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    @Override
    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }
}

