/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrintAttributes;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import java.util.ArrayList;
import java.util.List;

public interface IPrintManager
extends IInterface {
    public List<PrintJobInfo> getPrintJobInfos(int var1, int var2) throws RemoteException;

    public PrintJobInfo getPrintJobInfo(PrintJobId var1, int var2, int var3) throws RemoteException;

    public Bundle print(String var1, IPrintDocumentAdapter var2, PrintAttributes var3, String var4, int var5, int var6) throws RemoteException;

    public void cancelPrintJob(PrintJobId var1, int var2, int var3) throws RemoteException;

    public void restartPrintJob(PrintJobId var1, int var2, int var3) throws RemoteException;

    public void addPrintJobStateChangeListener(IPrintJobStateChangeListener var1, int var2, int var3) throws RemoteException;

    public void removePrintJobStateChangeListener(IPrintJobStateChangeListener var1, int var2) throws RemoteException;

    public List<PrintServiceInfo> getInstalledPrintServices(int var1) throws RemoteException;

    public List<PrintServiceInfo> getEnabledPrintServices(int var1) throws RemoteException;

    public void createPrinterDiscoverySession(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public void startPrinterDiscovery(IPrinterDiscoveryObserver var1, List<PrinterId> var2, int var3) throws RemoteException;

    public void stopPrinterDiscovery(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public void validatePrinters(List<PrinterId> var1, int var2) throws RemoteException;

    public void startPrinterStateTracking(PrinterId var1, int var2) throws RemoteException;

    public void stopPrinterStateTracking(PrinterId var1, int var2) throws RemoteException;

    public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPrintManager {
        private static final String DESCRIPTOR = "android.print.IPrintManager";
        static final int TRANSACTION_getPrintJobInfos = 1;
        static final int TRANSACTION_getPrintJobInfo = 2;
        static final int TRANSACTION_print = 3;
        static final int TRANSACTION_cancelPrintJob = 4;
        static final int TRANSACTION_restartPrintJob = 5;
        static final int TRANSACTION_addPrintJobStateChangeListener = 6;
        static final int TRANSACTION_removePrintJobStateChangeListener = 7;
        static final int TRANSACTION_getInstalledPrintServices = 8;
        static final int TRANSACTION_getEnabledPrintServices = 9;
        static final int TRANSACTION_createPrinterDiscoverySession = 10;
        static final int TRANSACTION_startPrinterDiscovery = 11;
        static final int TRANSACTION_stopPrinterDiscovery = 12;
        static final int TRANSACTION_validatePrinters = 13;
        static final int TRANSACTION_startPrinterStateTracking = 14;
        static final int TRANSACTION_stopPrinterStateTracking = 15;
        static final int TRANSACTION_destroyPrinterDiscoverySession = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPrintManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPrintManager) {
                return (IPrintManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    List<PrintJobInfo> _result = this.getPrintJobInfos(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    PrintJobInfo _result = this.getPrintJobInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    IPrintDocumentAdapter _arg1 = IPrintDocumentAdapter.Stub.asInterface(data.readStrongBinder());
                    PrintAttributes _arg2 = 0 != data.readInt() ? PrintAttributes.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    Bundle _result = this.print(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.cancelPrintJob(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.restartPrintJob(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrintJobStateChangeListener _arg0 = IPrintJobStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.addPrintJobStateChangeListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrintJobStateChangeListener _arg0 = IPrintJobStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.removePrintJobStateChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    List<PrintServiceInfo> _result = this.getInstalledPrintServices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    List<PrintServiceInfo> _result = this.getEnabledPrintServices(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.createPrinterDiscoverySession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    ArrayList<PrinterId> _arg1 = data.createTypedArrayList(PrinterId.CREATOR);
                    int _arg2 = data.readInt();
                    this.startPrinterDiscovery(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.stopPrinterDiscovery(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    ArrayList<PrinterId> _arg0 = data.createTypedArrayList(PrinterId.CREATOR);
                    int _arg1 = data.readInt();
                    this.validatePrinters(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    PrinterId _arg0 = 0 != data.readInt() ? PrinterId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.startPrinterStateTracking(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    PrinterId _arg0 = 0 != data.readInt() ? PrinterId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.stopPrinterStateTracking(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.destroyPrinterDiscoverySession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IPrintManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PrintJobInfo> getPrintJobInfos(int appId, int userId) throws RemoteException {
                ArrayList<PrintJobInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PrintJobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                PrintJobInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PrintJobInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle print(String printJobName, IPrintDocumentAdapter printAdapter, PrintAttributes attributes, String packageName, int appId, int userId) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(printJobName);
                    _data.writeStrongBinder(printAdapter != null ? printAdapter.asBinder() : null);
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restartPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PrintServiceInfo> getInstalledPrintServices(int userId) throws RemoteException {
                ArrayList<PrintServiceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PrintServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PrintServiceInfo> getEnabledPrintServices(int userId) throws RemoteException {
                ArrayList<PrintServiceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PrintServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeTypedList(priorityList);
                    _data.writeInt(userId);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void validatePrinters(List<PrinterId> printerIds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(printerIds);
                    _data.writeInt(userId);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printerId != null) {
                        _data.writeInt(1);
                        printerId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printerId != null) {
                        _data.writeInt(1);
                        printerId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

