/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemClock;
import android.os.SystemProperties;
import com.google.android.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class SystemService {
    private static HashMap<String, State> sStates = Maps.newHashMap();
    private static Object sPropertyLock = new Object();

    public static void start(String name) {
        SystemProperties.set("ctl.start", name);
    }

    public static void stop(String name) {
        SystemProperties.set("ctl.stop", name);
    }

    public static void restart(String name) {
        SystemProperties.set("ctl.restart", name);
    }

    public static State getState(String service) {
        String rawState = SystemProperties.get("init.svc." + service);
        State state = sStates.get(rawState);
        if (state != null) {
            return state;
        }
        return State.STOPPED;
    }

    public static boolean isStopped(String service) {
        return State.STOPPED.equals((Object)SystemService.getState(service));
    }

    public static boolean isRunning(String service) {
        return State.RUNNING.equals((Object)SystemService.getState(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForState(String service, State state, long timeoutMillis) throws TimeoutException {
        long endMillis = SystemClock.elapsedRealtime() + timeoutMillis;
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                State currentState = SystemService.getState(service);
                if (state.equals((Object)currentState)) {
                    return;
                }
                if (SystemClock.elapsedRealtime() >= endMillis) {
                    throw new TimeoutException("Service " + service + " currently " + (Object)((Object)currentState) + "; waited " + timeoutMillis + "ms for " + (Object)((Object)state));
                }
                try {
                    sPropertyLock.wait(timeoutMillis);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAnyStopped(String ... services) {
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                for (String service : services) {
                    if (!State.STOPPED.equals((Object)SystemService.getState(service))) continue;
                    return;
                }
                try {
                    sPropertyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        SystemProperties.addChangeCallback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = sPropertyLock;
                synchronized (object) {
                    sPropertyLock.notifyAll();
                }
            }
        });
    }

    public static enum State {
        RUNNING("running"),
        STOPPING("stopping"),
        STOPPED("stopped"),
        RESTARTING("restarting");


        private State(String state) {
            sStates.put(state, this);
        }
    }
}

