/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Memory;
import libcore.io.Streams;

public class FileBridge
extends Thread {
    private static final String TAG = "FileBridge";
    private static final int MSG_LENGTH = 8;
    private static final int CMD_WRITE = 1;
    private static final int CMD_FSYNC = 2;
    private static final int CMD_CLOSE = 3;
    private FileDescriptor mTarget;
    private final FileDescriptor mServer = new FileDescriptor();
    private final FileDescriptor mClient = new FileDescriptor();
    private volatile boolean mClosed;

    public FileBridge() {
        try {
            Os.socketpair((int)OsConstants.AF_UNIX, (int)OsConstants.SOCK_STREAM, (int)0, (FileDescriptor)this.mServer, (FileDescriptor)this.mClient);
        }
        catch (ErrnoException e) {
            throw new RuntimeException("Failed to create bridge");
        }
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void forceClose() {
        IoUtils.closeQuietly((FileDescriptor)this.mTarget);
        IoUtils.closeQuietly((FileDescriptor)this.mServer);
        IoUtils.closeQuietly((FileDescriptor)this.mClient);
        this.mClosed = true;
    }

    public void setTargetFile(FileDescriptor target) {
        this.mTarget = target;
    }

    public FileDescriptor getClientSocket() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] temp = new byte[8192];
        try {
            while (IoBridge.read((FileDescriptor)this.mServer, (byte[])temp, (int)0, (int)8) == 8) {
                int cmd = Memory.peekInt((byte[])temp, (int)0, (ByteOrder)ByteOrder.BIG_ENDIAN);
                if (cmd == 1) {
                    int n;
                    for (int len = Memory.peekInt((byte[])temp, (int)4, (ByteOrder)ByteOrder.BIG_ENDIAN); len > 0; len -= n) {
                        n = IoBridge.read((FileDescriptor)this.mServer, (byte[])temp, (int)0, (int)Math.min(temp.length, len));
                        if (n == -1) {
                            throw new IOException("Unexpected EOF; still expected " + len + " bytes");
                        }
                        IoBridge.write((FileDescriptor)this.mTarget, (byte[])temp, (int)0, (int)n);
                    }
                    continue;
                }
                if (cmd == 2) {
                    Os.fsync((FileDescriptor)this.mTarget);
                    IoBridge.write((FileDescriptor)this.mServer, (byte[])temp, (int)0, (int)8);
                    continue;
                }
                if (cmd != 3) continue;
                Os.fsync((FileDescriptor)this.mTarget);
                Os.close((FileDescriptor)this.mTarget);
                this.mClosed = true;
                IoBridge.write((FileDescriptor)this.mServer, (byte[])temp, (int)0, (int)8);
                break;
            }
        }
        catch (ErrnoException | IOException e) {
            Log.wtf(TAG, "Failed during bridge", e);
        }
        finally {
            this.forceClose();
        }
    }

    public static class FileBridgeOutputStream
    extends OutputStream {
        private final ParcelFileDescriptor mClientPfd;
        private final FileDescriptor mClient;
        private final byte[] mTemp = new byte[8];

        public FileBridgeOutputStream(ParcelFileDescriptor clientPfd) {
            this.mClientPfd = clientPfd;
            this.mClient = clientPfd.getFileDescriptor();
        }

        public FileBridgeOutputStream(FileDescriptor client) {
            this.mClientPfd = null;
            this.mClient = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.writeCommandAndBlock(3, "close()");
            }
            finally {
                IoBridge.closeAndSignalBlockedThreads((FileDescriptor)this.mClient);
                IoUtils.closeQuietly((AutoCloseable)this.mClientPfd);
            }
        }

        public void fsync() throws IOException {
            this.writeCommandAndBlock(2, "fsync()");
        }

        private void writeCommandAndBlock(int cmd, String cmdString) throws IOException {
            Memory.pokeInt((byte[])this.mTemp, (int)0, (int)cmd, (ByteOrder)ByteOrder.BIG_ENDIAN);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8);
            if (IoBridge.read((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8) == 8 && Memory.peekInt((byte[])this.mTemp, (int)0, (ByteOrder)ByteOrder.BIG_ENDIAN) == cmd) {
                return;
            }
            throw new IOException("Failed to execute " + cmdString + " across bridge");
        }

        @Override
        public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
            Memory.pokeInt((byte[])this.mTemp, (int)0, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN);
            Memory.pokeInt((byte[])this.mTemp, (int)4, (int)byteCount, (ByteOrder)ByteOrder.BIG_ENDIAN);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])buffer, (int)byteOffset, (int)byteCount);
        }

        @Override
        public void write(int oneByte) throws IOException {
            Streams.writeSingleByte((OutputStream)this, (int)oneByte);
        }
    }
}

