/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IRttManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.CountDownLatch;

public class RttManager {
    private static final boolean DBG = true;
    private static final String TAG = "RttManager";
    public static final int RTT_TYPE_UNSPECIFIED = 0;
    public static final int RTT_TYPE_ONE_SIDED = 1;
    public static final int RTT_TYPE_11_V = 2;
    public static final int RTT_TYPE_11_MC = 4;
    public static final int RTT_PEER_TYPE_UNSPECIFIED = 0;
    public static final int RTT_PEER_TYPE_AP = 1;
    public static final int RTT_PEER_TYPE_STA = 2;
    public static final int RTT_CHANNEL_WIDTH_20 = 0;
    public static final int RTT_CHANNEL_WIDTH_40 = 1;
    public static final int RTT_CHANNEL_WIDTH_80 = 2;
    public static final int RTT_CHANNEL_WIDTH_160 = 3;
    public static final int RTT_CHANNEL_WIDTH_80P80 = 4;
    public static final int RTT_CHANNEL_WIDTH_5 = 5;
    public static final int RTT_CHANNEL_WIDTH_10 = 6;
    public static final int RTT_CHANNEL_WIDTH_UNSPECIFIED = -1;
    public static final int RTT_STATUS_SUCCESS = 0;
    public static final int RTT_STATUS_FAILURE = 1;
    public static final int RTT_STATUS_FAIL_NO_RSP = 2;
    public static final int RTT_STATUS_FAIL_REJECTED = 3;
    public static final int RTT_STATUS_FAIL_NOT_SCHEDULED_YET = 4;
    public static final int RTT_STATUS_FAIL_TM_TIMEOUT = 5;
    public static final int RTT_STATUS_FAIL_AP_ON_DIFF_CHANNEL = 6;
    public static final int RTT_STATUS_FAIL_NO_CAPABILITY = 7;
    public static final int RTT_STATUS_ABORTED = 8;
    public static final int REASON_UNSPECIFIED = -1;
    public static final int REASON_NOT_AVAILABLE = -2;
    public static final int REASON_INVALID_LISTENER = -3;
    public static final int REASON_INVALID_REQUEST = -4;
    public static final String DESCRIPTION_KEY = "android.net.wifi.RttManager.Description";
    public static final int BASE = 160256;
    public static final int CMD_OP_START_RANGING = 160256;
    public static final int CMD_OP_STOP_RANGING = 160257;
    public static final int CMD_OP_FAILED = 160258;
    public static final int CMD_OP_SUCCEEDED = 160259;
    public static final int CMD_OP_ABORTED = 160260;
    private Context mContext;
    private IRttManager mService;
    private static final int INVALID_KEY = 0;
    private static int sListenerKey = 1;
    private static final SparseArray sListenerMap = new SparseArray();
    private static final Object sListenerMapLock = new Object();
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static final Object sThreadRefLock;
    private static int sThreadRefCount;
    private static HandlerThread sHandlerThread;

    public Capabilities getCapabilities() {
        return new Capabilities();
    }

    public void startRanging(RttParams[] params, RttListener listener) {
        this.validateChannel();
        ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
        sAsyncChannel.sendMessage(160256, 0, RttManager.putListener(listener), parcelableParams);
    }

    public void stopRanging(RttListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(160257, 0, RttManager.removeListener(listener));
    }

    public RttManager(Context context, IRttManager service) {
        this.mContext = context;
        this.mService = service;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            if (++sThreadRefCount == 1) {
                Messenger messenger = null;
                try {
                    Log.d(TAG, "Get the messenger from " + this.mService);
                    messenger = this.mService.getMessenger();
                }
                catch (RemoteException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread("WifiScanner");
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler handler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)handler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "interrupted wait at init");
                }
            }
        }
    }

    private void validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            do {
                ++sListenerKey;
            } while (key == 0);
            sListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            int index = sListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return sListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            sListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int removeListener(Object listener) {
        int key = RttManager.getListenerKey(listener);
        if (key == 0) {
            return key;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            sListenerMap.remove(key);
            return key;
        }
    }

    static {
        sThreadRefLock = new Object();
    }

    private static class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e(RttManager.TAG, "Failed to set up channel connection");
                        sAsyncChannel = null;
                    }
                    sConnected.countDown();
                    return;
                }
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e(RttManager.TAG, "Channel connection lost");
                    sAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = RttManager.getListener(msg.arg2);
            if (listener == null) {
                Log.d(RttManager.TAG, "invalid listener key = " + msg.arg2);
                return;
            }
            Log.d(RttManager.TAG, "listener key = " + msg.arg2);
            switch (msg.what) {
                case 160259: {
                    this.reportSuccess(listener, msg);
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                case 160258: {
                    this.reportFailure(listener, msg);
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                case 160260: {
                    ((RttListener)listener).onAborted();
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                default: {
                    Log.d(RttManager.TAG, "Ignoring message " + msg.what);
                    return;
                }
            }
        }

        void reportSuccess(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            ParcelableRttResults parcelableResults = (ParcelableRttResults)msg.obj;
            ((RttListener)listener).onSuccess(parcelableResults.mResults);
        }

        void reportFailure(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            Bundle bundle = (Bundle)msg.obj;
            ((RttListener)listener).onFailure(msg.arg1, bundle.getString(RttManager.DESCRIPTION_KEY));
        }
    }

    public static interface RttListener {
        public void onSuccess(RttResult[] var1);

        public void onFailure(int var1, String var2);

        public void onAborted();
    }

    public static class ParcelableRttResults
    implements Parcelable {
        public RttResult[] mResults;
        public static final Parcelable.Creator<ParcelableRttResults> CREATOR = new Parcelable.Creator<ParcelableRttResults>(){

            @Override
            public ParcelableRttResults createFromParcel(Parcel in) {
                int num = in.readInt();
                if (num == 0) {
                    return new ParcelableRttResults(null);
                }
                RttResult[] results = new RttResult[num];
                for (int i = 0; i < num; ++i) {
                    results[i] = new RttResult();
                    results[i].bssid = in.readString();
                    results[i].status = in.readInt();
                    results[i].requestType = in.readInt();
                    results[i].ts = in.readLong();
                    results[i].rssi = in.readInt();
                    results[i].rssi_spread = in.readInt();
                    results[i].tx_rate = in.readInt();
                    results[i].rtt_ns = in.readLong();
                    results[i].rtt_sd_ns = in.readLong();
                    results[i].rtt_spread_ns = in.readLong();
                    results[i].distance_cm = in.readInt();
                    results[i].distance_sd_cm = in.readInt();
                    results[i].distance_spread_cm = in.readInt();
                }
                ParcelableRttResults parcelableResults = new ParcelableRttResults(results);
                return parcelableResults;
            }

            public ParcelableRttResults[] newArray(int size) {
                return new ParcelableRttResults[size];
            }
        };

        public ParcelableRttResults(RttResult[] results) {
            this.mResults = results;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (RttResult result : this.mResults) {
                    dest.writeString(result.bssid);
                    dest.writeInt(result.status);
                    dest.writeInt(result.requestType);
                    dest.writeLong(result.ts);
                    dest.writeInt(result.rssi);
                    dest.writeInt(result.rssi_spread);
                    dest.writeInt(result.tx_rate);
                    dest.writeLong(result.rtt_ns);
                    dest.writeLong(result.rtt_sd_ns);
                    dest.writeLong(result.rtt_spread_ns);
                    dest.writeInt(result.distance_cm);
                    dest.writeInt(result.distance_sd_cm);
                    dest.writeInt(result.distance_spread_cm);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class RttResult {
        public String bssid;
        public int status;
        public int requestType;
        public long ts;
        public int rssi;
        public int rssi_spread;
        public int tx_rate;
        public long rtt_ns;
        public long rtt_sd_ns;
        public long rtt_spread_ns;
        public int distance_cm;
        public int distance_sd_cm;
        public int distance_spread_cm;
    }

    public static class ParcelableRttParams
    implements Parcelable {
        public RttParams[] mParams;
        public static final Parcelable.Creator<ParcelableRttParams> CREATOR = new Parcelable.Creator<ParcelableRttParams>(){

            @Override
            public ParcelableRttParams createFromParcel(Parcel in) {
                int num = in.readInt();
                if (num == 0) {
                    return new ParcelableRttParams(null);
                }
                RttParams[] params = new RttParams[num];
                for (int i = 0; i < num; ++i) {
                    params[i] = new RttParams();
                    params[i].deviceType = in.readInt();
                    params[i].requestType = in.readInt();
                    params[i].bssid = in.readString();
                    params[i].frequency = in.readInt();
                    params[i].channelWidth = in.readInt();
                    params[i].num_samples = in.readInt();
                    params[i].num_retries = in.readInt();
                }
                ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
                return parcelableParams;
            }

            public ParcelableRttParams[] newArray(int size) {
                return new ParcelableRttParams[size];
            }
        };

        ParcelableRttParams(RttParams[] params) {
            this.mParams = params;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mParams != null) {
                dest.writeInt(this.mParams.length);
                for (RttParams params : this.mParams) {
                    dest.writeInt(params.deviceType);
                    dest.writeInt(params.requestType);
                    dest.writeString(params.bssid);
                    dest.writeInt(params.frequency);
                    dest.writeInt(params.channelWidth);
                    dest.writeInt(params.num_samples);
                    dest.writeInt(params.num_retries);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    public static class RttParams {
        public int deviceType;
        public int requestType;
        public String bssid;
        public int frequency;
        public int channelWidth;
        public int num_samples;
        public int num_retries;
    }

    public class Capabilities {
        public int supportedType;
        public int supportedPeerType;
    }
}

