/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Connection;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;

class IdleCache {
    private static final int IDLE_CACHE_MAX = 8;
    private static final int EMPTY_CHECK_MAX = 5;
    private static final int TIMEOUT = 6000;
    private static final int CHECK_INTERVAL = 2000;
    private Entry[] mEntries = new Entry[8];
    private int mCount = 0;
    private IdleReaper mThread = null;
    private int mCached = 0;
    private int mReused = 0;

    IdleCache() {
        for (int i = 0; i < 8; ++i) {
            this.mEntries[i] = new Entry();
        }
    }

    synchronized boolean cacheConnection(HttpHost host, Connection connection) {
        boolean ret = false;
        if (this.mCount < 8) {
            long time = SystemClock.uptimeMillis();
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                if (entry.mHost != null) continue;
                entry.mHost = host;
                entry.mConnection = connection;
                entry.mTimeout = time + 6000L;
                ++this.mCount;
                ret = true;
                if (this.mThread != null) break;
                this.mThread = new IdleReaper();
                this.mThread.start();
                break;
            }
        }
        return ret;
    }

    synchronized Connection getConnection(HttpHost host) {
        Connection ret = null;
        if (this.mCount > 0) {
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                HttpHost eHost = entry.mHost;
                if (eHost == null || !eHost.equals((Object)host)) continue;
                ret = entry.mConnection;
                entry.mHost = null;
                entry.mConnection = null;
                --this.mCount;
                break;
            }
        }
        return ret;
    }

    synchronized void clear() {
        for (int i = 0; this.mCount > 0 && i < 8; ++i) {
            Entry entry = this.mEntries[i];
            if (entry.mHost == null) continue;
            entry.mHost = null;
            entry.mConnection.closeConnection();
            entry.mConnection = null;
            --this.mCount;
        }
    }

    private synchronized void clearIdle() {
        if (this.mCount > 0) {
            long time = SystemClock.uptimeMillis();
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                if (entry.mHost == null || time <= entry.mTimeout) continue;
                entry.mHost = null;
                entry.mConnection.closeConnection();
                entry.mConnection = null;
                --this.mCount;
            }
        }
    }

    private class IdleReaper
    extends Thread {
        private IdleReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int check = 0;
            this.setName("IdleReaper");
            Process.setThreadPriority(10);
            IdleCache idleCache = IdleCache.this;
            synchronized (idleCache) {
                while (check < 5) {
                    try {
                        IdleCache.this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (IdleCache.this.mCount == 0) {
                        ++check;
                        continue;
                    }
                    check = 0;
                    IdleCache.this.clearIdle();
                }
                IdleCache.this.mThread = null;
            }
        }
    }

    class Entry {
        HttpHost mHost;
        Connection mConnection;
        long mTimeout;

        Entry() {
        }
    }
}

