/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.DelegatingSSLSession;
import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Slog;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.TrustManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertificateChainValidator {
    private static final String TAG = "CertificateChainValidator";
    private X509TrustManager mTrustManager;

    public static CertificateChainValidator getInstance() {
        return NoPreloadHolder.sInstance;
    }

    private CertificateChainValidator() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X.509");
            tmf.init((KeyStore)null);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.mTrustManager = (X509TrustManager)tm;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("X.509 TrustManagerFactory must be available", e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("X.509 TrustManagerFactory cannot be initialized", e);
        }
        if (this.mTrustManager == null) {
            throw new RuntimeException("None of the X.509 TrustManagers are X509TrustManager");
        }
    }

    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection connection, SSLSocket sslSocket, String domain) throws IOException {
        Certificate[] peerCertificates;
        SSLSession sslSession = sslSocket.getSession();
        if (!sslSession.isValid()) {
            this.closeSocketThrowException(sslSocket, "failed to perform SSL handshake");
        }
        if ((peerCertificates = sslSocket.getSession().getPeerCertificates()) == null || peerCertificates.length == 0) {
            this.closeSocketThrowException(sslSocket, "failed to retrieve peer certificates");
        } else if (connection != null && peerCertificates[0] != null) {
            connection.setCertificate(new SslCertificate((X509Certificate)peerCertificates[0]));
        }
        return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])peerCertificates, domain, "RSA");
    }

    public static SslError verifyServerCertificates(byte[][] certChain, String domain, String authType) throws IOException {
        if (certChain == null || certChain.length == 0) {
            throw new IllegalArgumentException("bad certificate chain");
        }
        X509Certificate[] serverCertificates = new X509Certificate[certChain.length];
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < certChain.length; ++i) {
                serverCertificates[i] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certChain[i]));
            }
        }
        catch (CertificateException e) {
            throw new IOException("can't read certificate", e);
        }
        return CertificateChainValidator.verifyServerDomainAndCertificates(serverCertificates, domain, authType);
    }

    public static void handleTrustStorageUpdate() {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance("X.509");
            tmf.init((KeyStore)null);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.w(TAG, "Couldn't find default X.509 TrustManagerFactory");
            return;
        }
        catch (KeyStoreException e) {
            Slog.w(TAG, "Couldn't initialize default X.509 TrustManagerFactory", e);
            return;
        }
        TrustManager[] tms = tmf.getTrustManagers();
        boolean sentUpdate = false;
        for (TrustManager tm : tms) {
            try {
                Method updateMethod = tm.getClass().getDeclaredMethod("handleTrustStorageUpdate", new Class[0]);
                updateMethod.setAccessible(true);
                updateMethod.invoke((Object)tm, new Object[0]);
                sentUpdate = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!sentUpdate) {
            Slog.w(TAG, "Didn't find a TrustManager to handle CA list update");
        }
    }

    private static SslError verifyServerDomainAndCertificates(X509Certificate[] chain, String domain, String authType) throws IOException {
        boolean valid;
        X509Certificate currCertificate = chain[0];
        if (currCertificate == null) {
            throw new IllegalArgumentException("certificate for this site is null");
        }
        boolean bl = valid = domain != null && !domain.isEmpty() && NoPreloadHolder.sVerifier.verify(domain, new DelegatingSSLSession.CertificateWrap(currCertificate));
        if (!valid) {
            return new SslError(2, currCertificate);
        }
        try {
            X509TrustManager x509TrustManager = SSLParametersImpl.getDefaultX509TrustManager();
            if (x509TrustManager instanceof TrustManagerImpl) {
                TrustManagerImpl trustManager = (TrustManagerImpl)x509TrustManager;
                trustManager.checkServerTrusted(chain, authType, domain);
            } else {
                x509TrustManager.checkServerTrusted(chain, authType);
            }
            return null;
        }
        catch (GeneralSecurityException e) {
            return new SslError(3, currCertificate);
        }
    }

    private X509TrustManager getTrustManager() {
        return this.mTrustManager;
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage, String defaultErrorMessage) throws IOException {
        this.closeSocketThrowException(socket, errorMessage != null ? errorMessage : defaultErrorMessage);
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage) throws IOException {
        if (socket != null) {
            SSLSession session = socket.getSession();
            if (session != null) {
                session.invalidate();
            }
            socket.close();
        }
        throw new SSLHandshakeException(errorMessage);
    }

    private static class NoPreloadHolder {
        private static final CertificateChainValidator sInstance = new CertificateChainValidator();
        private static final HostnameVerifier sVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

        private NoPreloadHolder() {
        }
    }
}

