/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpResults;
import android.os.Parcel;
import android.util.Log;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;

public class NetworkUtils {
    private static final String TAG = "NetworkUtils";
    public static final int RESET_IPV4_ADDRESSES = 1;
    public static final int RESET_IPV6_ADDRESSES = 2;
    public static final int RESET_ALL_ADDRESSES = 3;

    public static native int resetConnections(String var0, int var1);

    public static native boolean runDhcp(String var0, DhcpResults var1);

    public static native boolean runDhcpRenew(String var0, DhcpResults var1);

    public static native boolean stopDhcp(String var0);

    public static native boolean releaseDhcpLease(String var0);

    public static native String getDhcpError();

    public static native boolean bindProcessToNetwork(int var0);

    public static native int getNetworkBoundToProcess();

    public static native boolean bindProcessToNetworkForHostResolution(int var0);

    public static native int bindSocketToNetwork(int var0, int var1);

    public static native boolean protectFromVpn(int var0);

    public static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    public static int inetAddressToInt(Inet4Address inetAddr) throws IllegalArgumentException {
        byte[] addr = inetAddr.getAddress();
        return (addr[3] & 0xFF) << 24 | (addr[2] & 0xFF) << 16 | (addr[1] & 0xFF) << 8 | addr[0] & 0xFF;
    }

    public static int prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        if (prefixLength < 0 || prefixLength > 32) {
            throw new IllegalArgumentException("Invalid prefix length (0 <= prefix <= 32)");
        }
        int value = -1 << 32 - prefixLength;
        return Integer.reverseBytes(value);
    }

    public static int netmaskIntToPrefixLength(int netmask) {
        return Integer.bitCount(netmask);
    }

    public static InetAddress numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress((String)addrString);
    }

    protected static void parcelInetAddress(Parcel parcel, InetAddress address, int flags) {
        byte[] addressArray = address != null ? address.getAddress() : null;
        parcel.writeByteArray(addressArray);
    }

    protected static InetAddress unparcelInetAddress(Parcel in) {
        byte[] addressArray = in.createByteArray();
        if (addressArray == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(addressArray);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void maskRawAddress(byte[] array2, int prefixLength) {
        if (prefixLength < 0 || prefixLength > array2.length * 8) {
            throw new RuntimeException("IP address with " + array2.length + " bytes has invalid prefix length " + prefixLength);
        }
        int offset = prefixLength / 8;
        int remainder = prefixLength % 8;
        byte mask = (byte)(255 << 8 - remainder);
        if (offset < array2.length) {
            array2[offset] = (byte)(array2[offset] & mask);
        }
        ++offset;
        while (offset < array2.length) {
            array2[offset] = 0;
            ++offset;
        }
    }

    public static InetAddress getNetworkPart(InetAddress address, int prefixLength) {
        byte[] array2 = address.getAddress();
        NetworkUtils.maskRawAddress(array2, prefixLength);
        InetAddress netPart = null;
        try {
            netPart = InetAddress.getByAddress(array2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getNetworkPart error - " + e.toString());
        }
        return netPart;
    }

    public static Pair<InetAddress, Integer> parseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            address = InetAddress.parseNumericAddress((String)pieces[0]);
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    public static boolean addressTypeMatches(InetAddress left, InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    public static InetAddress hexToInet6Address(String addrHexString) throws IllegalArgumentException {
        try {
            return NetworkUtils.numericToInetAddress(String.format(Locale.US, "%s:%s:%s:%s:%s:%s:%s:%s", addrHexString.substring(0, 4), addrHexString.substring(4, 8), addrHexString.substring(8, 12), addrHexString.substring(12, 16), addrHexString.substring(16, 20), addrHexString.substring(20, 24), addrHexString.substring(24, 28), addrHexString.substring(28, 32)));
        }
        catch (Exception e) {
            Log.e(TAG, "error in hexToInet6Address(" + addrHexString + "): " + e);
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] makeStrings(Collection<InetAddress> addrs) {
        String[] result = new String[addrs.size()];
        int i = 0;
        for (InetAddress addr : addrs) {
            result[i++] = addr.getHostAddress();
        }
        return result;
    }

    public static String trimV4AddrZeros(String addr) {
        if (addr == null) {
            return null;
        }
        String[] octets = addr.split("\\.");
        if (octets.length != 4) {
            return addr;
        }
        StringBuilder builder = new StringBuilder(16);
        String result = null;
        for (int i = 0; i < 4; ++i) {
            try {
                if (octets[i].length() > 3) {
                    return addr;
                }
                builder.append(Integer.parseInt(octets[i]));
            }
            catch (NumberFormatException e) {
                return addr;
            }
            if (i >= 3) continue;
            builder.append('.');
        }
        result = builder.toString();
        return result;
    }
}

