/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class NetworkScorerAppManager {
    private static final String TAG = "NetworkScorerAppManager";
    private static final Intent SCORE_INTENT = new Intent("android.net.scoring.SCORE_NETWORKS");

    private NetworkScorerAppManager() {
    }

    public static Collection<NetworkScorerAppData> getAllValidScorers(Context context) {
        ArrayList<NetworkScorerAppData> scorers = new ArrayList<NetworkScorerAppData>();
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> receivers = pm.queryBroadcastReceivers(SCORE_INTENT, 0, 0);
        for (ResolveInfo receiver : receivers) {
            ActivityInfo activityInfo;
            ActivityInfo receiverInfo = receiver.activityInfo;
            if (receiverInfo == null || !"android.permission.BROADCAST_SCORE_NETWORKS".equals(receiverInfo.permission) || pm.checkPermission("android.permission.SCORE_NETWORKS", receiverInfo.packageName) != 0) continue;
            String configurationActivityClassName = null;
            Intent intent = new Intent("android.net.scoring.CUSTOM_ENABLE");
            intent.setPackage(receiverInfo.packageName);
            List<ResolveInfo> configActivities = pm.queryIntentActivities(intent, 0);
            if (!configActivities.isEmpty() && (activityInfo = configActivities.get((int)0).activityInfo) != null) {
                configurationActivityClassName = activityInfo.name;
            }
            scorers.add(new NetworkScorerAppData(receiverInfo.packageName, receiverInfo.loadLabel(pm), configurationActivityClassName));
        }
        return scorers;
    }

    public static NetworkScorerAppData getActiveScorer(Context context) {
        String scorerPackage = Settings.Global.getString(context.getContentResolver(), "network_scorer_app");
        return NetworkScorerAppManager.getScorer(context, scorerPackage);
    }

    public static boolean setActiveScorer(Context context, String packageName) {
        String oldPackageName = Settings.Global.getString(context.getContentResolver(), "network_scorer_app");
        if (TextUtils.equals(oldPackageName, packageName)) {
            return true;
        }
        Log.i(TAG, "Changing network scorer from " + oldPackageName + " to " + packageName);
        if (packageName == null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", null);
            return true;
        }
        if (NetworkScorerAppManager.getScorer(context, packageName) != null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", packageName);
            return true;
        }
        Log.w(TAG, "Requested network scorer is not valid: " + packageName);
        return false;
    }

    public static boolean isCallerActiveScorer(Context context, int callingUid) {
        NetworkScorerAppData defaultApp = NetworkScorerAppManager.getActiveScorer(context);
        if (defaultApp == null) {
            return false;
        }
        AppOpsManager appOpsMgr = (AppOpsManager)context.getSystemService("appops");
        try {
            appOpsMgr.checkPackage(callingUid, defaultApp.mPackageName);
        }
        catch (SecurityException e) {
            return false;
        }
        return context.checkCallingPermission("android.permission.SCORE_NETWORKS") == 0;
    }

    public static NetworkScorerAppData getScorer(Context context, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        Collection<NetworkScorerAppData> applications = NetworkScorerAppManager.getAllValidScorers(context);
        for (NetworkScorerAppData app : applications) {
            if (!packageName.equals(app.mPackageName)) continue;
            return app;
        }
        return null;
    }

    public static class NetworkScorerAppData {
        public final String mPackageName;
        public final CharSequence mScorerName;
        public final String mConfigurationActivityClassName;

        public NetworkScorerAppData(String packageName, CharSequence scorerName, String configurationActivityClassName) {
            this.mScorerName = scorerName;
            this.mPackageName = packageName;
            this.mConfigurationActivityClassName = configurationActivityClassName;
        }
    }
}

