/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;

public class NetworkFactory
extends Handler {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int BASE = 536576;
    public static final int CMD_REQUEST_NETWORK = 536576;
    public static final int CMD_CANCEL_REQUEST = 536577;
    private static final int CMD_SET_SCORE = 536578;
    private static final int CMD_SET_FILTER = 536579;
    private final Context mContext;
    private final String LOG_TAG;
    private final SparseArray<NetworkRequestInfo> mNetworkRequests = new SparseArray();
    private int mScore;
    private NetworkCapabilities mCapabilityFilter;
    private int mRefCount = 0;
    private Messenger mMessenger = null;

    public NetworkFactory(Looper looper, Context context, String logTag, NetworkCapabilities filter) {
        super(looper);
        this.LOG_TAG = logTag;
        this.mContext = context;
        this.mCapabilityFilter = filter;
    }

    public void register() {
        this.log("Registering NetworkFactory");
        if (this.mMessenger == null) {
            this.mMessenger = new Messenger(this);
            ConnectivityManager.from(this.mContext).registerNetworkFactory(this.mMessenger, this.LOG_TAG);
        }
    }

    public void unregister() {
        this.log("Unregistering NetworkFactory");
        if (this.mMessenger != null) {
            ConnectivityManager.from(this.mContext).unregisterNetworkFactory(this.mMessenger);
            this.mMessenger = null;
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 536576: {
                this.handleAddRequest((NetworkRequest)msg.obj, msg.arg1);
                break;
            }
            case 536577: {
                this.handleRemoveRequest((NetworkRequest)msg.obj);
                break;
            }
            case 536578: {
                this.handleSetScore(msg.arg1);
                break;
            }
            case 536579: {
                this.handleSetFilter((NetworkCapabilities)msg.obj);
            }
        }
    }

    private void handleAddRequest(NetworkRequest request, int score) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n == null) {
            this.log("got request " + request + " with score " + score);
            n = new NetworkRequestInfo(request, score);
            this.mNetworkRequests.put(n.request.requestId, n);
        } else {
            n.score = score;
        }
        this.evalRequest(n);
    }

    private void handleRemoveRequest(NetworkRequest request) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n != null && n.requested) {
            this.mNetworkRequests.remove(request.requestId);
            this.releaseNetworkFor(n.request);
        }
    }

    private void handleSetScore(int score) {
        this.mScore = score;
        this.evalRequests();
    }

    private void handleSetFilter(NetworkCapabilities netCap) {
        this.mCapabilityFilter = netCap;
        this.evalRequests();
    }

    public boolean acceptRequest(NetworkRequest request, int score) {
        return true;
    }

    private void evalRequest(NetworkRequestInfo n) {
        if (!n.requested && n.score < this.mScore && n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(n.request, n.score)) {
            this.needNetworkFor(n.request, n.score);
            n.requested = true;
        } else if (!(!n.requested || n.score <= this.mScore && n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(n.request, n.score))) {
            this.releaseNetworkFor(n.request);
            n.requested = false;
        }
    }

    private void evalRequests() {
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            NetworkRequestInfo n = this.mNetworkRequests.valueAt(i);
            this.evalRequest(n);
        }
    }

    protected void startNetwork() {
    }

    protected void stopNetwork() {
    }

    protected void needNetworkFor(NetworkRequest networkRequest, int score) {
        if (++this.mRefCount == 1) {
            this.startNetwork();
        }
    }

    protected void releaseNetworkFor(NetworkRequest networkRequest) {
        if (--this.mRefCount == 0) {
            this.stopNetwork();
        }
    }

    public void addNetworkRequest(NetworkRequest networkRequest, int score) {
        this.sendMessage(this.obtainMessage(536576, new NetworkRequestInfo(networkRequest, score)));
    }

    public void removeNetworkRequest(NetworkRequest networkRequest) {
        this.sendMessage(this.obtainMessage(536577, networkRequest));
    }

    public void setScoreFilter(int score) {
        this.sendMessage(this.obtainMessage(536578, score, 0));
    }

    public void setCapabilityFilter(NetworkCapabilities netCap) {
        this.sendMessage(this.obtainMessage(536579, new NetworkCapabilities(netCap)));
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, s);
    }

    private class NetworkRequestInfo {
        public final NetworkRequest request;
        public int score;
        public boolean requested;

        public NetworkRequestInfo(NetworkRequest request, int score) {
            this.request = request;
            this.score = score;
            this.requested = false;
        }
    }
}

