/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.UidRange;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;

public abstract class NetworkAgent
extends Handler {
    private volatile AsyncChannel mAsyncChannel;
    private final String LOG_TAG;
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final ArrayList<Message> mPreConnectedQueue = new ArrayList();
    private static final int BASE = 528384;
    public static final int CMD_SUSPECT_BAD = 528384;
    public static final int EVENT_NETWORK_INFO_CHANGED = 528385;
    public static final int EVENT_NETWORK_CAPABILITIES_CHANGED = 528386;
    public static final int EVENT_NETWORK_PROPERTIES_CHANGED = 528387;
    public static final int WIFI_BASE_SCORE = 60;
    public static final int EVENT_NETWORK_SCORE_CHANGED = 528388;
    public static final int EVENT_UID_RANGES_ADDED = 528389;
    public static final int EVENT_UID_RANGES_REMOVED = 528390;
    public static final int CMD_REPORT_NETWORK_STATUS = 528391;
    public static final int VALID_NETWORK = 1;
    public static final int INVALID_NETWORK = 2;
    public static final int EVENT_SET_EXPLICITLY_SELECTED = 528392;

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score) {
        this(looper, context, logTag, ni, nc, lp, score, null);
    }

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc) {
        super(looper);
        this.LOG_TAG = logTag;
        this.mContext = context;
        if (ni == null || nc == null || lp == null) {
            throw new IllegalArgumentException();
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        cm.registerNetworkAgent(new Messenger(this), new NetworkInfo(ni), new LinkProperties(lp), new NetworkCapabilities(nc), score, misc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 69633: {
                if (this.mAsyncChannel != null) {
                    this.log("Received new connection while already connected!");
                    break;
                }
                AsyncChannel ac = new AsyncChannel();
                ac.connected(null, this, msg.replyTo);
                ac.replyToMessage(msg, 69634, 0);
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = ac;
                    for (Message m : this.mPreConnectedQueue) {
                        ac.sendMessage(m);
                    }
                    this.mPreConnectedQueue.clear();
                    break;
                }
            }
            case 69635: {
                if (this.mAsyncChannel == null) break;
                this.mAsyncChannel.disconnect();
                break;
            }
            case 69636: {
                this.log("NetworkAgent channel lost");
                this.unwanted();
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = null;
                    break;
                }
            }
            case 528384: {
                this.log("Unhandled Message " + msg);
                break;
            }
            case 528391: {
                this.networkStatus(msg.arg1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueOrSendMessage(int what, Object obj) {
        ArrayList<Message> arrayList = this.mPreConnectedQueue;
        synchronized (arrayList) {
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.sendMessage(what, obj);
            } else {
                Message msg = Message.obtain();
                msg.what = what;
                msg.obj = obj;
                this.mPreConnectedQueue.add(msg);
            }
        }
    }

    public void sendLinkProperties(LinkProperties linkProperties) {
        this.queueOrSendMessage(528387, new LinkProperties(linkProperties));
    }

    public void sendNetworkInfo(NetworkInfo networkInfo) {
        this.queueOrSendMessage(528385, new NetworkInfo(networkInfo));
    }

    public void sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.queueOrSendMessage(528386, new NetworkCapabilities(networkCapabilities));
    }

    public void sendNetworkScore(int score) {
        if (score < 0) {
            throw new IllegalArgumentException("Score must be >= 0");
        }
        this.queueOrSendMessage(528388, new Integer(score));
    }

    public void addUidRanges(UidRange[] ranges) {
        this.queueOrSendMessage(528389, ranges);
    }

    public void removeUidRanges(UidRange[] ranges) {
        this.queueOrSendMessage(528390, ranges);
    }

    public void explicitlySelected() {
        this.queueOrSendMessage(528392, 0);
    }

    protected abstract void unwanted();

    protected void networkStatus(int status) {
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, "NetworkAgent: " + s);
    }
}

