/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalSocketImpl {
    private SocketInputStream fis;
    private SocketOutputStream fos;
    private Object readMonitor = new Object();
    private Object writeMonitor = new Object();
    private FileDescriptor fd;
    private boolean mFdCreatedInternally;
    FileDescriptor[] inboundFileDescriptors;
    FileDescriptor[] outboundFileDescriptors;

    private native int pending_native(FileDescriptor var1) throws IOException;

    private native int available_native(FileDescriptor var1) throws IOException;

    private native int read_native(FileDescriptor var1) throws IOException;

    private native int readba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private native void writeba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private native void write_native(int var1, FileDescriptor var2) throws IOException;

    private native void connectLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native void bindLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native void listen_native(FileDescriptor var1, int var2) throws IOException;

    private native void shutdown(FileDescriptor var1, boolean var2);

    private native Credentials getPeerCredentials_native(FileDescriptor var1) throws IOException;

    private native int getOption_native(FileDescriptor var1, int var2) throws IOException;

    private native void setOption_native(FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    private native FileDescriptor accept(FileDescriptor var1, LocalSocketImpl var2) throws IOException;

    LocalSocketImpl() {
    }

    LocalSocketImpl(FileDescriptor fd) throws IOException {
        this.fd = fd;
    }

    public String toString() {
        return super.toString() + " fd:" + this.fd;
    }

    public void create(int sockType) throws IOException {
        if (this.fd == null) {
            int osType;
            switch (sockType) {
                case 1: {
                    osType = OsConstants.SOCK_DGRAM;
                    break;
                }
                case 2: {
                    osType = OsConstants.SOCK_STREAM;
                    break;
                }
                case 3: {
                    osType = OsConstants.SOCK_SEQPACKET;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown sockType");
                }
            }
            try {
                this.fd = Os.socket((int)OsConstants.AF_UNIX, (int)osType, (int)0);
                this.mFdCreatedInternally = true;
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fd == null || !this.mFdCreatedInternally) {
                this.fd = null;
                return;
            }
            try {
                Os.close((FileDescriptor)this.fd);
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            this.fd = null;
        }
    }

    protected void connect(LocalSocketAddress address, int timeout) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.connectLocal(this.fd, address.getName(), address.getNamespace().getId());
    }

    public void bind(LocalSocketAddress endpoint) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.bindLocal(this.fd, endpoint.getName(), endpoint.getNamespace().getId());
    }

    protected void listen(int backlog) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.listen_native(this.fd, backlog);
    }

    protected void accept(LocalSocketImpl s) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        s.fd = this.accept(this.fd, s);
        s.mFdCreatedInternally = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fis == null) {
                this.fis = new SocketInputStream();
            }
            return this.fis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fos == null) {
                this.fos = new SocketOutputStream();
            }
            return this.fos;
        }
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    protected void shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, true);
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, false);
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    protected void sendUrgentData(int data) throws IOException {
        throw new RuntimeException("not impled");
    }

    public Object getOption(int optID) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (optID == 4102) {
            return 0;
        }
        int value = this.getOption_native(this.fd, optID);
        switch (optID) {
            case 4097: 
            case 4098: {
                return value;
            }
        }
        return value;
    }

    public void setOption(int optID, Object value) throws IOException {
        int boolValue = -1;
        int intValue = 0;
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Boolean) {
            boolValue = (Boolean)value != false ? 1 : 0;
        } else {
            throw new IOException("bad value: " + value);
        }
        this.setOption_native(this.fd, optID, boolValue, intValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDescriptorsForSend(FileDescriptor[] fds) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] result = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return result;
        }
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.getPeerCredentials_native(this.fd);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                LocalSocketImpl.this.writeba_native(b, off, len, myFd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                LocalSocketImpl.this.write_native(b, myFd);
            }
        }

        @Override
        public void flush() throws IOException {
            FileDescriptor myFd = LocalSocketImpl.this.fd;
            if (myFd == null) {
                throw new IOException("socket closed");
            }
            while (LocalSocketImpl.this.pending_native(myFd) > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        @Override
        public int available() throws IOException {
            FileDescriptor myFd = LocalSocketImpl.this.fd;
            if (myFd == null) {
                throw new IOException("socket closed");
            }
            return LocalSocketImpl.this.available_native(myFd);
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                int ret = LocalSocketImpl.this.read_native(myFd);
                return ret;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int ret = LocalSocketImpl.this.readba_native(b, off, len, myFd);
                return ret;
            }
        }
    }
}

