/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.DhcpResults;
import android.net.NetworkUtils;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

public class DhcpStateMachine
extends StateMachine {
    private static final String TAG = "DhcpStateMachine";
    private static final boolean DBG = false;
    private StateMachine mController;
    private Context mContext;
    private BroadcastReceiver mBroadcastReceiver;
    private AlarmManager mAlarmManager;
    private PendingIntent mDhcpRenewalIntent;
    private PowerManager.WakeLock mDhcpRenewWakeLock;
    private static final String WAKELOCK_TAG = "DHCP";
    private DhcpResults mDhcpResults;
    private static final int DHCP_RENEW = 0;
    private static final String ACTION_DHCP_RENEW = "android.net.wifi.DHCP_RENEW";
    private static final int MIN_RENEWAL_TIME_SECS = 300;
    private final String mInterfaceName;
    private boolean mRegisteredForPreDhcpNotification = false;
    private static final int BASE = 196608;
    public static final int CMD_START_DHCP = 196609;
    public static final int CMD_STOP_DHCP = 196610;
    public static final int CMD_RENEW_DHCP = 196611;
    public static final int CMD_PRE_DHCP_ACTION = 196612;
    public static final int CMD_POST_DHCP_ACTION = 196613;
    public static final int CMD_ON_QUIT = 196614;
    public static final int CMD_PRE_DHCP_ACTION_COMPLETE = 196615;
    public static final int DHCP_SUCCESS = 1;
    public static final int DHCP_FAILURE = 2;
    private State mDefaultState = new DefaultState();
    private State mStoppedState = new StoppedState();
    private State mWaitBeforeStartState = new WaitBeforeStartState();
    private State mRunningState = new RunningState();
    private State mWaitBeforeRenewalState = new WaitBeforeRenewalState();

    private DhcpStateMachine(Context context, StateMachine controller, String intf) {
        super(TAG);
        this.mContext = context;
        this.mController = controller;
        this.mInterfaceName = intf;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent dhcpRenewalIntent = new Intent(ACTION_DHCP_RENEW, null);
        this.mDhcpRenewalIntent = PendingIntent.getBroadcast(this.mContext, 0, dhcpRenewalIntent, 0);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mDhcpRenewWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mDhcpRenewWakeLock.setReferenceCounted(false);
        this.mBroadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                DhcpStateMachine.this.mDhcpRenewWakeLock.acquire(40000L);
                DhcpStateMachine.this.sendMessage(196611);
            }
        };
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter(ACTION_DHCP_RENEW));
        this.addState(this.mDefaultState);
        this.addState(this.mStoppedState, this.mDefaultState);
        this.addState(this.mWaitBeforeStartState, this.mDefaultState);
        this.addState(this.mRunningState, this.mDefaultState);
        this.addState(this.mWaitBeforeRenewalState, this.mDefaultState);
        this.setInitialState(this.mStoppedState);
    }

    public static DhcpStateMachine makeDhcpStateMachine(Context context, StateMachine controller, String intf) {
        DhcpStateMachine dsm = new DhcpStateMachine(context, controller, intf);
        dsm.start();
        return dsm;
    }

    public void registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    public void doQuit() {
        this.quit();
    }

    @Override
    protected void onQuitting() {
        this.mController.sendMessage(196614);
    }

    private boolean runDhcp(DhcpAction dhcpAction) {
        boolean success = false;
        DhcpResults dhcpResults = new DhcpResults();
        if (dhcpAction == DhcpAction.START) {
            NetworkUtils.stopDhcp(this.mInterfaceName);
            success = NetworkUtils.runDhcp(this.mInterfaceName, dhcpResults);
        } else if (dhcpAction == DhcpAction.RENEW && (success = NetworkUtils.runDhcpRenew(this.mInterfaceName, dhcpResults))) {
            dhcpResults.updateFromDhcpRequest(this.mDhcpResults);
        }
        if (success) {
            long leaseDuration = dhcpResults.leaseDuration;
            if (leaseDuration >= 0L) {
                if (leaseDuration < 300L) {
                    leaseDuration = 300L;
                }
                this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + leaseDuration * 480L, this.mDhcpRenewalIntent);
            }
            this.mDhcpResults = dhcpResults;
            this.mController.obtainMessage(196613, 1, 0, dhcpResults).sendToTarget();
        } else {
            Log.e(TAG, "DHCP failed on " + this.mInterfaceName + ": " + NetworkUtils.getDhcpError());
            NetworkUtils.stopDhcp(this.mInterfaceName);
            this.mController.obtainMessage(196613, 2, 0).sendToTarget();
        }
        return success;
    }

    class WaitBeforeRenewalState
    extends State {
        WaitBeforeRenewalState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196610: {
                    DhcpStateMachine.this.mAlarmManager.cancel(DhcpStateMachine.this.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(DhcpStateMachine.this.mInterfaceName)) {
                        Log.e(DhcpStateMachine.TAG, "Failed to stop Dhcp on " + DhcpStateMachine.this.mInterfaceName);
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    break;
                }
                case 196615: {
                    if (DhcpStateMachine.this.runDhcp(DhcpAction.RENEW)) {
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                        break;
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }

        @Override
        public void exit() {
            DhcpStateMachine.this.mDhcpRenewWakeLock.release();
        }
    }

    class RunningState
    extends State {
        RunningState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196610: {
                    DhcpStateMachine.this.mAlarmManager.cancel(DhcpStateMachine.this.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(DhcpStateMachine.this.mInterfaceName)) {
                        Log.e(DhcpStateMachine.TAG, "Failed to stop Dhcp on " + DhcpStateMachine.this.mInterfaceName);
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    break;
                }
                case 196611: {
                    if (DhcpStateMachine.this.mRegisteredForPreDhcpNotification) {
                        DhcpStateMachine.this.mController.sendMessage(196612);
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mWaitBeforeRenewalState);
                        break;
                    }
                    if (!DhcpStateMachine.this.runDhcp(DhcpAction.RENEW)) {
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    }
                    DhcpStateMachine.this.mDhcpRenewWakeLock.release();
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class WaitBeforeStartState
    extends State {
        WaitBeforeStartState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196615: {
                    if (DhcpStateMachine.this.runDhcp(DhcpAction.START)) {
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                        break;
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    break;
                }
                case 196610: {
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class StoppedState
    extends State {
        StoppedState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196609: {
                    if (DhcpStateMachine.this.mRegisteredForPreDhcpNotification) {
                        DhcpStateMachine.this.mController.sendMessage(196612);
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mWaitBeforeStartState);
                        break;
                    }
                    if (!DhcpStateMachine.this.runDhcp(DhcpAction.START)) break;
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                    break;
                }
                case 196610: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        @Override
        public void exit() {
            DhcpStateMachine.this.mContext.unregisterReceiver(DhcpStateMachine.this.mBroadcastReceiver);
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 196611: {
                    Log.e(DhcpStateMachine.TAG, "Error! Failed to handle a DHCP renewal on " + DhcpStateMachine.this.mInterfaceName);
                    DhcpStateMachine.this.mDhcpRenewWakeLock.release();
                    break;
                }
                default: {
                    Log.e(DhcpStateMachine.TAG, "Error! unhandled message  " + message);
                }
            }
            return true;
        }
    }

    private static enum DhcpAction {
        START,
        RENEW;

    }
}

