/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Rect;
import android.media.tv.ITvInputSession;
import android.media.tv.TvInputService;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.Surface;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;

public class ITvInputSessionWrapper
extends ITvInputSession.Stub
implements HandlerCaller.Callback {
    private static final String TAG = "TvInputSessionWrapper";
    private static final int MESSAGE_HANDLING_DURATION_THRESHOLD_MILLIS = 50;
    private static final int DO_RELEASE = 1;
    private static final int DO_SET_MAIN = 2;
    private static final int DO_SET_SURFACE = 3;
    private static final int DO_DISPATCH_SURFACE_CHANGED = 4;
    private static final int DO_SET_STREAM_VOLUME = 5;
    private static final int DO_TUNE = 6;
    private static final int DO_SET_CAPTION_ENABLED = 7;
    private static final int DO_SELECT_TRACK = 8;
    private static final int DO_APP_PRIVATE_COMMAND = 9;
    private static final int DO_CREATE_OVERLAY_VIEW = 10;
    private static final int DO_RELAYOUT_OVERLAY_VIEW = 11;
    private static final int DO_REMOVE_OVERLAY_VIEW = 12;
    private static final int DO_REQUEST_UNBLOCK_CONTENT = 13;
    private final HandlerCaller mCaller;
    private TvInputService.Session mTvInputSessionImpl;
    private InputChannel mChannel;
    private TvInputEventReceiver mReceiver;

    public ITvInputSessionWrapper(Context context, TvInputService.Session sessionImpl, InputChannel channel) {
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mTvInputSessionImpl = sessionImpl;
        this.mChannel = channel;
        if (channel != null) {
            this.mReceiver = new TvInputEventReceiver(channel, context.getMainLooper());
        }
    }

    @Override
    public void executeMessage(Message msg) {
        long duration;
        if (this.mTvInputSessionImpl == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        switch (msg.what) {
            case 1: {
                this.mTvInputSessionImpl.release();
                this.mTvInputSessionImpl = null;
                if (this.mReceiver != null) {
                    this.mReceiver.dispose();
                    this.mReceiver = null;
                }
                if (this.mChannel == null) break;
                this.mChannel.dispose();
                this.mChannel = null;
                break;
            }
            case 2: {
                this.mTvInputSessionImpl.setMain((Boolean)msg.obj);
                break;
            }
            case 3: {
                this.mTvInputSessionImpl.setSurface((Surface)msg.obj);
                break;
            }
            case 4: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.dispatchSurfaceChanged(args.argi1, args.argi2, args.argi3);
                args.recycle();
                break;
            }
            case 5: {
                this.mTvInputSessionImpl.setStreamVolume(((Float)msg.obj).floatValue());
                break;
            }
            case 6: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.tune((Uri)args.arg1, (Bundle)args.arg2);
                args.recycle();
                break;
            }
            case 7: {
                this.mTvInputSessionImpl.setCaptionEnabled((Boolean)msg.obj);
                break;
            }
            case 8: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.selectTrack((Integer)args.arg1, (String)args.arg2);
                args.recycle();
                break;
            }
            case 9: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                args.recycle();
                break;
            }
            case 10: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.createOverlayView((IBinder)args.arg1, (Rect)args.arg2);
                args.recycle();
                break;
            }
            case 11: {
                this.mTvInputSessionImpl.relayoutOverlayView((Rect)msg.obj);
                break;
            }
            case 12: {
                this.mTvInputSessionImpl.removeOverlayView(true);
                break;
            }
            case 13: {
                this.mTvInputSessionImpl.unblockContent((String)msg.obj);
                break;
            }
            default: {
                Log.w(TAG, "Unhandled message code: " + msg.what);
            }
        }
        if ((duration = System.currentTimeMillis() - startTime) > 50L) {
            Log.w(TAG, "Handling message (" + msg.what + ") took too long time (duration=" + duration + "ms)");
        }
    }

    @Override
    public void release() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(1));
    }

    @Override
    public void setMain(boolean isMain) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(2, isMain));
    }

    @Override
    public void setSurface(Surface surface) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(3, surface));
    }

    @Override
    public void dispatchSurfaceChanged(int format, int width, int height) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIII(4, format, width, height, 0));
    }

    @Override
    public final void setVolume(float volume) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(5, Float.valueOf(volume)));
    }

    @Override
    public void tune(Uri channelUri, Bundle params) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(6, channelUri, params));
    }

    @Override
    public void setCaptionEnabled(boolean enabled) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(7, enabled));
    }

    @Override
    public void selectTrack(int type, String trackId) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(8, type, trackId));
    }

    @Override
    public void appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(9, action, data));
    }

    @Override
    public void createOverlayView(IBinder windowToken, Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(10, windowToken, frame));
    }

    @Override
    public void relayoutOverlayView(Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(11, frame));
    }

    @Override
    public void removeOverlayView() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(12));
    }

    @Override
    public void requestUnblockContent(String unblockedRating) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(13, unblockedRating));
    }

    private final class TvInputEventReceiver
    extends InputEventReceiver {
        public TvInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent event) {
            if (ITvInputSessionWrapper.this.mTvInputSessionImpl == null) {
                this.finishInputEvent(event, false);
                return;
            }
            int handled = ITvInputSessionWrapper.this.mTvInputSessionImpl.dispatchInputEvent(event, this);
            if (handled != -1) {
                this.finishInputEvent(event, handled == 1);
            }
        }
    }
}

