/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;

public class MiniThumbFile {
    private static final String TAG = "MiniThumbFile";
    private static final int MINI_THUMB_DATA_FILE_VERSION = 3;
    public static final int BYTES_PER_MINTHUMB = 10000;
    private static final int HEADER_SIZE = 13;
    private Uri mUri;
    private RandomAccessFile mMiniThumbFile;
    private FileChannel mChannel;
    private ByteBuffer mBuffer;
    private static final Hashtable<String, MiniThumbFile> sThumbFiles = new Hashtable();

    public static synchronized void reset() {
        for (MiniThumbFile file : sThumbFiles.values()) {
            file.deactivate();
        }
        sThumbFiles.clear();
    }

    public static synchronized MiniThumbFile instance(Uri uri) {
        String type = uri.getPathSegments().get(1);
        MiniThumbFile file = sThumbFiles.get(type);
        if (file == null) {
            file = new MiniThumbFile(Uri.parse("content://media/external/" + type + "/media"));
            sThumbFiles.put(type, file);
        }
        return file;
    }

    private String randomAccessFilePath(int version) {
        String directoryName = Environment.getExternalStorageDirectory().toString() + "/DCIM/.thumbnails";
        return directoryName + "/.thumbdata" + version + "-" + this.mUri.hashCode();
    }

    private void removeOldFile() {
        String oldPath = this.randomAccessFilePath(2);
        File oldFile = new File(oldPath);
        if (oldFile.exists()) {
            try {
                oldFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private RandomAccessFile miniThumbDataFile() {
        if (this.mMiniThumbFile == null) {
            this.removeOldFile();
            String path = this.randomAccessFilePath(3);
            File directory = new File(path).getParentFile();
            if (!directory.isDirectory() && !directory.mkdirs()) {
                Log.e(TAG, "Unable to create .thumbnails directory " + directory.toString());
            }
            File f = new File(path);
            try {
                this.mMiniThumbFile = new RandomAccessFile(f, "rw");
            }
            catch (IOException ex) {
                try {
                    this.mMiniThumbFile = new RandomAccessFile(f, "r");
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            if (this.mMiniThumbFile != null) {
                this.mChannel = this.mMiniThumbFile.getChannel();
            }
        }
        return this.mMiniThumbFile;
    }

    public MiniThumbFile(Uri uri) {
        this.mUri = uri;
        this.mBuffer = ByteBuffer.allocateDirect(10000);
    }

    public synchronized void deactivate() {
        if (this.mMiniThumbFile != null) {
            try {
                this.mMiniThumbFile.close();
                this.mMiniThumbFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getMagic(long id2) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r != null) {
            long pos = id2 * 10000L;
            FileLock lock = null;
            try {
                this.mBuffer.clear();
                this.mBuffer.limit(9);
                lock = this.mChannel.lock(pos, 9L, true);
                if (this.mChannel.read(this.mBuffer, pos) == 9) {
                    this.mBuffer.position(0);
                    if (this.mBuffer.get() == 1) {
                        long l = this.mBuffer.getLong();
                        return l;
                    }
                }
            }
            catch (IOException ex) {
                Log.v(TAG, "Got exception checking file magic: ", ex);
            }
            catch (RuntimeException ex) {
                Log.e(TAG, "Got exception when reading magic, id = " + id2 + ", disk full or mount read-only? " + ex.getClass());
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveMiniThumbToFile(byte[] data, long id2, long magic) throws IOException {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return;
        }
        long pos = id2 * 10000L;
        FileLock lock = null;
        try {
            if (data != null) {
                if (data.length > 9987) {
                    return;
                }
                this.mBuffer.clear();
                this.mBuffer.put((byte)1);
                this.mBuffer.putLong(magic);
                this.mBuffer.putInt(data.length);
                this.mBuffer.put(data);
                this.mBuffer.flip();
                lock = this.mChannel.lock(pos, 10000L, false);
                this.mChannel.write(this.mBuffer, pos);
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "couldn't save mini thumbnail data for " + id2 + "; ", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "couldn't save mini thumbnail data for " + id2 + "; disk full or mount read-only? " + ex.getClass());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getMiniThumbFromFile(long id2, byte[] data) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return null;
        }
        long pos = id2 * 10000L;
        FileLock lock = null;
        try {
            this.mBuffer.clear();
            lock = this.mChannel.lock(pos, 10000L, true);
            int size = this.mChannel.read(this.mBuffer, pos);
            if (size > 13) {
                this.mBuffer.position(0);
                byte flag = this.mBuffer.get();
                long magic = this.mBuffer.getLong();
                int length = this.mBuffer.getInt();
                if (size >= 13 + length && length != 0 && magic != 0L && flag == 1 && data.length >= length) {
                    this.mBuffer.get(data, 0, length);
                    byte[] byArray = data;
                    return byArray;
                }
            }
        }
        catch (IOException ex) {
            Log.w(TAG, "got exception when reading thumbnail id=" + id2 + ", exception: " + ex);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "Got exception when reading thumbnail, id = " + id2 + ", disk full or mount read-only? " + ex.getClass());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException ex) {}
        }
        return null;
    }
}

