/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;

abstract class LocalListenerHelper<TListener> {
    private final HashSet<TListener> mListeners = new HashSet();
    private final String mTag;

    protected LocalListenerHelper(String name) {
        Preconditions.checkNotNull(name);
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            if (this.mListeners.isEmpty()) {
                boolean registeredWithService;
                try {
                    registeredWithService = this.registerWithServer();
                }
                catch (RemoteException e) {
                    Log.e(this.mTag, "Error handling first listener.", e);
                    return false;
                }
                if (!registeredWithService) {
                    Log.e(this.mTag, "Unable to register listener transport.");
                    return false;
                }
            }
            if (this.mListeners.contains(listener)) {
                return true;
            }
            this.mListeners.add(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            boolean isLastRemoved;
            boolean removed = this.mListeners.remove(listener);
            boolean bl = isLastRemoved = removed && this.mListeners.isEmpty();
            if (isLastRemoved) {
                try {
                    this.unregisterFromServer();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract boolean registerWithServer() throws RemoteException;

    protected abstract void unregisterFromServer() throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreach(ListenerOperation operation) {
        ArrayList<TListener> listeners;
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            listeners = new ArrayList<TListener>(this.mListeners);
        }
        for (Object listener : listeners) {
            try {
                operation.execute(listener);
            }
            catch (RemoteException e) {
                Log.e(this.mTag, "Error in monitored listener.", e);
            }
        }
    }

    protected static interface ListenerOperation<TListener> {
        public void execute(TListener var1) throws RemoteException;
    }
}

