/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.SensorManager;
import android.os.Handler;
import android.view.Display;
import android.view.DisplayInfo;

public abstract class DisplayManagerInternal {
    public abstract void initPowerManagement(DisplayPowerCallbacks var1, Handler var2, SensorManager var3);

    public abstract boolean requestPowerState(DisplayPowerRequest var1, boolean var2);

    public abstract boolean isProximitySensorAvailable();

    public abstract DisplayInfo getDisplayInfo(int var1);

    public abstract void registerDisplayTransactionListener(DisplayTransactionListener var1);

    public abstract void unregisterDisplayTransactionListener(DisplayTransactionListener var1);

    public abstract void setDisplayInfoOverrideFromWindowManager(int var1, DisplayInfo var2);

    public abstract void performTraversalInTransactionFromWindowManager();

    public abstract void setDisplayProperties(int var1, boolean var2, float var3, boolean var4);

    public static interface DisplayTransactionListener {
        public void onDisplayTransaction();
    }

    public static interface DisplayPowerCallbacks {
        public void onStateChanged();

        public void onProximityPositive();

        public void onProximityNegative();

        public void onDisplayStateChange(int var1);

        public void acquireSuspendBlocker();

        public void releaseSuspendBlocker();
    }

    public static final class DisplayPowerRequest {
        public static final int POLICY_OFF = 0;
        public static final int POLICY_DOZE = 1;
        public static final int POLICY_DIM = 2;
        public static final int POLICY_BRIGHT = 3;
        public int policy;
        public boolean useProximitySensor;
        public int screenBrightness;
        public float screenAutoBrightnessAdjustment;
        public boolean useAutoBrightness;
        public boolean lowPowerMode;
        public boolean blockScreenOn;
        public int dozeScreenBrightness;
        public int dozeScreenState;

        public DisplayPowerRequest() {
            this.policy = 3;
            this.useProximitySensor = false;
            this.screenBrightness = 255;
            this.screenAutoBrightnessAdjustment = 0.0f;
            this.useAutoBrightness = false;
            this.blockScreenOn = false;
            this.dozeScreenBrightness = -1;
            this.dozeScreenState = 0;
        }

        public DisplayPowerRequest(DisplayPowerRequest other) {
            this.copyFrom(other);
        }

        public boolean isBrightOrDim() {
            return this.policy == 3 || this.policy == 2;
        }

        public void copyFrom(DisplayPowerRequest other) {
            this.policy = other.policy;
            this.useProximitySensor = other.useProximitySensor;
            this.screenBrightness = other.screenBrightness;
            this.screenAutoBrightnessAdjustment = other.screenAutoBrightnessAdjustment;
            this.useAutoBrightness = other.useAutoBrightness;
            this.blockScreenOn = other.blockScreenOn;
            this.lowPowerMode = other.lowPowerMode;
            this.dozeScreenBrightness = other.dozeScreenBrightness;
            this.dozeScreenState = other.dozeScreenState;
        }

        public boolean equals(Object o) {
            return o instanceof DisplayPowerRequest && this.equals((DisplayPowerRequest)o);
        }

        public boolean equals(DisplayPowerRequest other) {
            return other != null && this.policy == other.policy && this.useProximitySensor == other.useProximitySensor && this.screenBrightness == other.screenBrightness && this.screenAutoBrightnessAdjustment == other.screenAutoBrightnessAdjustment && this.useAutoBrightness == other.useAutoBrightness && this.blockScreenOn == other.blockScreenOn && this.lowPowerMode == other.lowPowerMode && this.dozeScreenBrightness == other.dozeScreenBrightness && this.dozeScreenState == other.dozeScreenState;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "policy=" + DisplayPowerRequest.policyToString(this.policy) + ", useProximitySensor=" + this.useProximitySensor + ", screenBrightness=" + this.screenBrightness + ", screenAutoBrightnessAdjustment=" + this.screenAutoBrightnessAdjustment + ", useAutoBrightness=" + this.useAutoBrightness + ", blockScreenOn=" + this.blockScreenOn + ", lowPowerMode=" + this.lowPowerMode + ", dozeScreenBrightness=" + this.dozeScreenBrightness + ", dozeScreenState=" + Display.stateToString(this.dozeScreenState);
        }

        public static String policyToString(int policy) {
            switch (policy) {
                case 0: {
                    return "OFF";
                }
                case 1: {
                    return "DOZE";
                }
                case 2: {
                    return "DIM";
                }
                case 3: {
                    return "BRIGHT";
                }
            }
            return Integer.toString(policy);
        }
    }
}

