/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import android.view.Surface;
import java.util.ArrayList;

public final class DisplayManagerGlobal {
    private static final String TAG = "DisplayManager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    public static final int EVENT_DISPLAY_ADDED = 1;
    public static final int EVENT_DISPLAY_CHANGED = 2;
    public static final int EVENT_DISPLAY_REMOVED = 3;
    private static DisplayManagerGlobal sInstance;
    private final Object mLock = new Object();
    private final IDisplayManager mDm;
    private DisplayManagerCallback mCallback;
    private final ArrayList<DisplayListenerDelegate> mDisplayListeners = new ArrayList();
    private final SparseArray<DisplayInfo> mDisplayInfoCache = new SparseArray();
    private int[] mDisplayIdCache;
    private int mWifiDisplayScanNestCount;

    private DisplayManagerGlobal(IDisplayManager dm) {
        this.mDm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisplayManagerGlobal getInstance() {
        Class<DisplayManagerGlobal> clazz = DisplayManagerGlobal.class;
        synchronized (DisplayManagerGlobal.class) {
            IBinder b;
            if (sInstance == null && (b = ServiceManager.getService("display")) != null) {
                sInstance = new DisplayManagerGlobal(IDisplayManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayInfo getDisplayInfo(int displayId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                DisplayInfo info = this.mDm.getDisplayInfo(displayId);
                if (info == null) {
                    return null;
                }
                this.registerCallbackIfNeededLocked();
                return info;
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Could not get display information from display manager.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDisplayIds() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                int[] displayIds = this.mDm.getDisplayIds();
                this.registerCallbackIfNeededLocked();
                return displayIds;
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Could not get display ids from display manager.", ex);
            return new int[]{0};
        }
    }

    public Display getCompatibleDisplay(int displayId, DisplayAdjustments daj) {
        DisplayInfo displayInfo = this.getDisplayInfo(displayId);
        if (displayInfo == null) {
            return null;
        }
        return new Display(this, displayId, displayInfo, daj);
    }

    public Display getRealDisplay(int displayId) {
        return this.getCompatibleDisplay(displayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    public Display getRealDisplay(int displayId, IBinder token) {
        return this.getCompatibleDisplay(displayId, new DisplayAdjustments(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisplayListener(DisplayManager.DisplayListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findDisplayListenerLocked(listener);
            if (index < 0) {
                this.mDisplayListeners.add(new DisplayListenerDelegate(listener, handler));
                this.registerCallbackIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDisplayListener(DisplayManager.DisplayListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findDisplayListenerLocked(listener);
            if (index >= 0) {
                DisplayListenerDelegate d = this.mDisplayListeners.get(index);
                d.clearEvents();
                this.mDisplayListeners.remove(index);
            }
        }
    }

    private int findDisplayListenerLocked(DisplayManager.DisplayListener listener) {
        int numListeners = this.mDisplayListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mDisplayListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    private void registerCallbackIfNeededLocked() {
        if (this.mCallback == null) {
            this.mCallback = new DisplayManagerCallback();
            try {
                this.mDm.registerCallback(this.mCallback);
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Failed to register callback with display manager service.", ex);
                this.mCallback = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayEvent(int displayId, int event) {
        Object object = this.mLock;
        synchronized (object) {
            int numListeners = this.mDisplayListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mDisplayListeners.get(i).sendDisplayEvent(displayId, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWifiDisplayScanNestCount++ == 0) {
                this.registerCallbackIfNeededLocked();
                try {
                    this.mDm.startWifiDisplayScan();
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "Failed to scan for Wifi displays.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            if (--this.mWifiDisplayScanNestCount == 0) {
                try {
                    this.mDm.stopWifiDisplayScan();
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "Failed to scan for Wifi displays.", ex);
                }
            } else if (this.mWifiDisplayScanNestCount < 0) {
                Log.wtf(TAG, "Wifi display scan nest count became negative: " + this.mWifiDisplayScanNestCount);
                this.mWifiDisplayScanNestCount = 0;
            }
        }
    }

    public void connectWifiDisplay(String deviceAddress) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.connectWifiDisplay(deviceAddress);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to connect to Wifi display " + deviceAddress + ".", ex);
        }
    }

    public void pauseWifiDisplay() {
        try {
            this.mDm.pauseWifiDisplay();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to pause Wifi display.", ex);
        }
    }

    public void resumeWifiDisplay() {
        try {
            this.mDm.resumeWifiDisplay();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to resume Wifi display.", ex);
        }
    }

    public void disconnectWifiDisplay() {
        try {
            this.mDm.disconnectWifiDisplay();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to disconnect from Wifi display.", ex);
        }
    }

    public void setHDMIKeepRate(int keepRate) {
        try {
            this.mDm.setHDMIKeepRate(keepRate);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display keepRate", ex);
        }
    }

    public int getHDMIKeepRate() {
        try {
            return this.mDm.getHDMIKeepRate();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to display keep rate.", ex);
            return 0;
        }
    }

    public void setHDMIResolution(int resolution) {
        try {
            this.mDm.setHDMIResolution(resolution);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display resolution", ex);
        }
    }

    public int getHDMIResolution() {
        try {
            return this.mDm.getHDMIResolution();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display resolution.", ex);
            return 0;
        }
    }

    public void setHDMIRotAngle(int rotAngle) {
        try {
            this.mDm.setHDMIRotAngle(rotAngle);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display rotAngle", ex);
        }
    }

    public int getHDMIRotAngle() {
        try {
            return this.mDm.getHDMIRotAngle();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display rotAngle.", ex);
            return 0;
        }
    }

    public void setHDMINavBarVisible(int navBarVisible) {
        try {
            this.mDm.setHDMINavBarVisible(navBarVisible);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display navBarVisible", ex);
        }
    }

    public int getHDMINavBarVisible() {
        try {
            return this.mDm.getHDMINavBarVisible();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display navBarVisible.", ex);
            return 0;
        }
    }

    public boolean isHDMIConnected() {
        try {
            return this.mDm.isHDMIConnected();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display connect state", ex);
            return false;
        }
    }

    public void setHDMIXOverScan(int xOverScan) {
        try {
            this.mDm.setHDMIXOverScan(xOverScan);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display xoverscan", ex);
        }
    }

    public int getHDMIXOverScan() {
        try {
            return this.mDm.getHDMIXOverScan();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display xoverscan", ex);
            return 0;
        }
    }

    public void setHDMIYOverScan(int yOverScan) {
        try {
            this.mDm.setHDMIYOverScan(yOverScan);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to set display xoverscan", ex);
        }
    }

    public int getHDMIYOverScan() {
        try {
            return this.mDm.getHDMIYOverScan();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display xoverscan", ex);
            return 0;
        }
    }

    public String getHDMIMode() {
        try {
            return this.mDm.getHDMIMode();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display xoverscan", ex);
            return null;
        }
    }

    public String getHDMIName() {
        try {
            return this.mDm.getHDMIName();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get display xoverscan", ex);
            return null;
        }
    }

    public void renameWifiDisplay(String deviceAddress, String alias) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.renameWifiDisplay(deviceAddress, alias);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to rename Wifi display " + deviceAddress + " with alias " + alias + ".", ex);
        }
    }

    public void forgetWifiDisplay(String deviceAddress) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.forgetWifiDisplay(deviceAddress);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to forget Wifi display.", ex);
        }
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        try {
            return this.mDm.getWifiDisplayStatus();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get Wifi display status.", ex);
            return new WifiDisplayStatus();
        }
    }

    public VirtualDisplay createVirtualDisplay(Context context, MediaProjection projection, String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler) {
        int displayId;
        if (TextUtils.isEmpty(name)) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        if (width <= 0 || height <= 0 || densityDpi <= 0) {
            throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
        }
        VirtualDisplayCallback callbackWrapper = new VirtualDisplayCallback(callback, handler);
        IMediaProjection projectionToken = projection != null ? projection.getProjection() : null;
        try {
            displayId = this.mDm.createVirtualDisplay(callbackWrapper, projectionToken, context.getPackageName(), name, width, height, densityDpi, surface, flags);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Could not create virtual display: " + name, ex);
            return null;
        }
        if (displayId < 0) {
            Log.e(TAG, "Could not create virtual display: " + name);
            return null;
        }
        Display display = this.getRealDisplay(displayId);
        if (display == null) {
            Log.wtf(TAG, "Could not obtain display info for newly created virtual display: " + name);
            try {
                this.mDm.releaseVirtualDisplay(callbackWrapper);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
            return null;
        }
        return new VirtualDisplay(this, display, callbackWrapper, surface);
    }

    public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) {
        try {
            this.mDm.setVirtualDisplaySurface(token, surface);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed to set virtual display surface.", ex);
        }
    }

    public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) {
        try {
            this.mDm.resizeVirtualDisplay(token, width, height, densityDpi);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed to resize virtual display.", ex);
        }
    }

    public void releaseVirtualDisplay(IVirtualDisplayCallback token) {
        try {
            this.mDm.releaseVirtualDisplay(token);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Failed to release virtual display.", ex);
        }
    }

    private static final class VirtualDisplayCallbackDelegate
    extends Handler {
        public static final int MSG_DISPLAY_PAUSED = 0;
        public static final int MSG_DISPLAY_RESUMED = 1;
        public static final int MSG_DISPLAY_STOPPED = 2;
        private final VirtualDisplay.Callback mCallback;

        public VirtualDisplayCallbackDelegate(VirtualDisplay.Callback callback, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper(), null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mCallback.onPaused();
                    break;
                }
                case 1: {
                    this.mCallback.onResumed();
                    break;
                }
                case 2: {
                    this.mCallback.onStopped();
                }
            }
        }
    }

    private static final class VirtualDisplayCallback
    extends IVirtualDisplayCallback.Stub {
        private VirtualDisplayCallbackDelegate mDelegate;

        public VirtualDisplayCallback(VirtualDisplay.Callback callback, Handler handler) {
            if (callback != null) {
                this.mDelegate = new VirtualDisplayCallbackDelegate(callback, handler);
            }
        }

        @Override
        public void onPaused() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(0);
            }
        }

        @Override
        public void onResumed() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(1);
            }
        }

        @Override
        public void onStopped() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(2);
            }
        }
    }

    private static final class DisplayListenerDelegate
    extends Handler {
        public final DisplayManager.DisplayListener mListener;

        public DisplayListenerDelegate(DisplayManager.DisplayListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper(), null, true);
            this.mListener = listener;
        }

        public void sendDisplayEvent(int displayId, int event) {
            Message msg = this.obtainMessage(event, displayId, 0);
            this.sendMessage(msg);
        }

        public void clearEvents() {
            this.removeCallbacksAndMessages(null);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onDisplayAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onDisplayChanged(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onDisplayRemoved(msg.arg1);
                }
            }
        }
    }

    private final class DisplayManagerCallback
    extends IDisplayManagerCallback.Stub {
        private DisplayManagerCallback() {
        }

        @Override
        public void onDisplayEvent(int displayId, int event) {
            DisplayManagerGlobal.this.handleDisplayEvent(displayId, event);
        }
    }
}

