/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MarshalQueryableArray<T>
implements MarshalQueryable<T> {
    private static final String TAG = MarshalQueryableArray.class.getSimpleName();
    private static final boolean VERBOSE = Log.isLoggable(TAG, 2);

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerArray(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        return managedType.getRawType().isArray();
    }

    private class MarshalerArray
    extends Marshaler<T> {
        private final Class<T> mClass;
        private final Marshaler<?> mComponentMarshaler;
        private final Class<?> mComponentClass;

        protected MarshalerArray(TypeReference<T> typeReference, int nativeType) {
            super(MarshalQueryableArray.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
            TypeReference<?> componentToken = typeReference.getComponentType();
            this.mComponentMarshaler = MarshalRegistry.getMarshaler(componentToken, this.mNativeType);
            this.mComponentClass = componentToken.getRawType();
        }

        @Override
        public void marshal(T value, ByteBuffer buffer) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.marshalArrayElement(this.mComponentMarshaler, buffer, value, i);
            }
        }

        @Override
        public T unmarshal(ByteBuffer buffer) {
            Object array2;
            int elementSize = this.mComponentMarshaler.getNativeSize();
            if (elementSize != Marshaler.NATIVE_SIZE_DYNAMIC) {
                int remaining = buffer.remaining();
                int arraySize = remaining / elementSize;
                if (remaining % elementSize != 0) {
                    throw new UnsupportedOperationException("Arrays for " + this.mTypeReference + " must be packed tighly into a multiple of " + elementSize + "; but there are " + remaining % elementSize + " left over bytes");
                }
                if (VERBOSE) {
                    Log.v(TAG, String.format("Attempting to unpack array (count = %d, element size = %d, bytes remaining = %d) for type %s", arraySize, elementSize, remaining, this.mClass));
                }
                array2 = Array.newInstance(this.mComponentClass, arraySize);
                for (int i = 0; i < arraySize; ++i) {
                    Object elem = this.mComponentMarshaler.unmarshal(buffer);
                    Array.set(array2, i, elem);
                }
            } else {
                ArrayList arrayList = new ArrayList();
                while (buffer.hasRemaining()) {
                    Object elem = this.mComponentMarshaler.unmarshal(buffer);
                    arrayList.add(elem);
                }
                int arraySize = arrayList.size();
                array2 = this.copyListToArray(arrayList, Array.newInstance(this.mComponentClass, arraySize));
            }
            if (buffer.remaining() != 0) {
                Log.e(TAG, "Trailing bytes (" + buffer.remaining() + ") left over after unpacking " + this.mClass);
            }
            return this.mClass.cast(array2);
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public int calculateMarshalSize(T value) {
            int elementSize = this.mComponentMarshaler.getNativeSize();
            int arrayLength = Array.getLength(value);
            if (elementSize != Marshaler.NATIVE_SIZE_DYNAMIC) {
                return elementSize * arrayLength;
            }
            int size = 0;
            for (int i = 0; i < arrayLength; ++i) {
                size += this.calculateElementMarshalSize(this.mComponentMarshaler, value, i);
            }
            return size;
        }

        private <TElem> void marshalArrayElement(Marshaler<TElem> marshaler, ByteBuffer buffer, Object array2, int index) {
            marshaler.marshal(Array.get(array2, index), buffer);
        }

        private Object copyListToArray(ArrayList<?> arrayList, Object arrayDest) {
            return arrayList.toArray((Object[])arrayDest);
        }

        private <TElem> int calculateElementMarshalSize(Marshaler<TElem> marshaler, Object array2, int index) {
            Object elem = Array.get(array2, index);
            return marshaler.calculateMarshalSize(elem);
        }
    }
}

