/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.RequestHolder;
import android.os.Handler;
import android.util.Log;

public class CameraDeviceState {
    private static final String TAG = "CameraDeviceState";
    private static final boolean DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    private static final int STATE_ERROR = 0;
    private static final int STATE_UNCONFIGURED = 1;
    private static final int STATE_CONFIGURING = 2;
    private static final int STATE_IDLE = 3;
    private static final int STATE_CAPTURING = 4;
    private static final String[] sStateNames = new String[]{"ERROR", "UNCONFIGURED", "CONFIGURING", "IDLE", "CAPTURING"};
    private int mCurrentState = 1;
    private int mCurrentError = -1;
    private RequestHolder mCurrentRequest = null;
    private Handler mCurrentHandler = null;
    private CameraDeviceStateListener mCurrentListener = null;
    public static final int NO_CAPTURE_ERROR = -1;

    public synchronized void setError(int error) {
        this.mCurrentError = error;
        this.doStateTransition(0);
    }

    public synchronized boolean setConfiguring() {
        this.doStateTransition(2);
        return this.mCurrentError == -1;
    }

    public synchronized boolean setIdle() {
        this.doStateTransition(3);
        return this.mCurrentError == -1;
    }

    public synchronized boolean setCaptureStart(RequestHolder request, long timestamp, int captureError) {
        this.mCurrentRequest = request;
        this.doStateTransition(4, timestamp, captureError);
        return this.mCurrentError == -1;
    }

    public synchronized boolean setCaptureResult(final RequestHolder request, final CameraMetadataNative result, final int captureError) {
        if (this.mCurrentState != 4) {
            Log.e(TAG, "Cannot receive result while in state: " + this.mCurrentState);
            this.mCurrentError = 1;
            this.doStateTransition(0);
            return this.mCurrentError == -1;
        }
        if (this.mCurrentHandler != null && this.mCurrentListener != null) {
            if (captureError != -1) {
                this.mCurrentHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraDeviceState.this.mCurrentListener.onError(captureError, request);
                    }
                });
            } else {
                this.mCurrentHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraDeviceState.this.mCurrentListener.onCaptureResult(result, request);
                    }
                });
            }
        }
        return this.mCurrentError == -1;
    }

    public synchronized void setCameraDeviceCallbacks(Handler handler, CameraDeviceStateListener listener) {
        this.mCurrentHandler = handler;
        this.mCurrentListener = listener;
    }

    private void doStateTransition(int newState) {
        this.doStateTransition(newState, 0L, -1);
    }

    private void doStateTransition(int newState, final long timestamp, final int error) {
        if (newState != this.mCurrentState) {
            String stateName = "UNKNOWN";
            if (newState >= 0 && newState < sStateNames.length) {
                stateName = sStateNames[newState];
            }
            Log.i(TAG, "Legacy camera service transitioning to state " + stateName);
        }
        if (newState != 0 && newState != 3 && this.mCurrentState != newState && this.mCurrentHandler != null && this.mCurrentListener != null) {
            this.mCurrentHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraDeviceState.this.mCurrentListener.onBusy();
                }
            });
        }
        switch (newState) {
            case 0: {
                if (this.mCurrentState != 0 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onError(CameraDeviceState.this.mCurrentError, CameraDeviceState.this.mCurrentRequest);
                        }
                    });
                }
                this.mCurrentState = 0;
                break;
            }
            case 2: {
                if (this.mCurrentState != 1 && this.mCurrentState != 3) {
                    Log.e(TAG, "Cannot call configure while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentState != 2 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onConfiguring();
                        }
                    });
                }
                this.mCurrentState = 2;
                break;
            }
            case 3: {
                if (this.mCurrentState == 3) break;
                if (this.mCurrentState != 2 && this.mCurrentState != 4) {
                    Log.e(TAG, "Cannot call idle while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentState != 3 && this.mCurrentHandler != null && this.mCurrentListener != null) {
                    this.mCurrentHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraDeviceState.this.mCurrentListener.onIdle();
                        }
                    });
                }
                this.mCurrentState = 3;
                break;
            }
            case 4: {
                if (this.mCurrentState != 3 && this.mCurrentState != 4) {
                    Log.e(TAG, "Cannot call capture while in state: " + this.mCurrentState);
                    this.mCurrentError = 1;
                    this.doStateTransition(0);
                    break;
                }
                if (this.mCurrentHandler != null && this.mCurrentListener != null) {
                    if (error != -1) {
                        this.mCurrentHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                CameraDeviceState.this.mCurrentListener.onError(error, CameraDeviceState.this.mCurrentRequest);
                            }
                        });
                    } else {
                        this.mCurrentHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                CameraDeviceState.this.mCurrentListener.onCaptureStarted(CameraDeviceState.this.mCurrentRequest, timestamp);
                            }
                        });
                    }
                }
                this.mCurrentState = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Transition to unknown state: " + newState);
            }
        }
    }

    public static interface CameraDeviceStateListener {
        public void onError(int var1, RequestHolder var2);

        public void onConfiguring();

        public void onIdle();

        public void onBusy();

        public void onCaptureStarted(RequestHolder var1, long var2);

        public void onCaptureResult(CameraMetadataNative var1, RequestHolder var2);
    }
}

