/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends Drawable
implements Drawable.Callback {
    private final Rect mTmpRect = new Rect();
    private InsetState mInsetState;
    private boolean mMutated;

    InsetDrawable() {
        this(null, null);
    }

    public InsetDrawable(Drawable drawable2, int inset) {
        this(drawable2, inset, inset, inset, inset);
    }

    public InsetDrawable(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this(null, null);
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = insetLeft;
        this.mInsetState.mInsetTop = insetTop;
        this.mInsetState.mInsetRight = insetRight;
        this.mInsetState.mInsetBottom = insetBottom;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        this.mInsetState.mDrawable = null;
        this.updateStateFromTypedArray(a);
        if (this.mInsetState.mDrawable == null) {
            Drawable dr;
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            this.mInsetState.mDrawable = dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            dr.setCallback(this);
        }
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mInsetState.mDrawable == null && (this.mInsetState.mThemeAttrs == null || this.mInsetState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        InsetState state = this.mInsetState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int N = a.getIndexCount();
        block8: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 1: {
                    Drawable dr = a.getDrawable(attr2);
                    if (dr == null) continue block8;
                    state.mDrawable = dr;
                    dr.setCallback(this);
                    continue block8;
                }
                case 6: {
                    int inset = a.getDimensionPixelOffset(attr2, Integer.MIN_VALUE);
                    if (inset == Integer.MIN_VALUE) continue block8;
                    state.mInsetLeft = inset;
                    state.mInsetTop = inset;
                    state.mInsetRight = inset;
                    state.mInsetBottom = inset;
                    continue block8;
                }
                case 2: {
                    state.mInsetLeft = a.getDimensionPixelOffset(attr2, state.mInsetLeft);
                    continue block8;
                }
                case 4: {
                    state.mInsetTop = a.getDimensionPixelOffset(attr2, state.mInsetTop);
                    continue block8;
                }
                case 3: {
                    state.mInsetRight = a.getDimensionPixelOffset(attr2, state.mInsetRight);
                    continue block8;
                }
                case 5: {
                    state.mInsetBottom = a.getDimensionPixelOffset(attr2, state.mInsetBottom);
                }
            }
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        InsetState state = this.mInsetState;
        if (state == null || state.mThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
        try {
            this.updateStateFromTypedArray(a);
            this.verifyRequiredAttributes(a);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mInsetState != null && this.mInsetState.mThemeAttrs != null;
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        this.mInsetState.mDrawable.draw(canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mInsetState.mChangingConfigurations | this.mInsetState.mDrawable.getChangingConfigurations();
    }

    @Override
    public boolean getPadding(Rect padding) {
        boolean pad = this.mInsetState.mDrawable.getPadding(padding);
        padding.left += this.mInsetState.mInsetLeft;
        padding.right += this.mInsetState.mInsetRight;
        padding.top += this.mInsetState.mInsetTop;
        padding.bottom += this.mInsetState.mInsetBottom;
        return pad || (this.mInsetState.mInsetLeft | this.mInsetState.mInsetRight | this.mInsetState.mInsetTop | this.mInsetState.mInsetBottom) != 0;
    }

    @Override
    public Insets getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        return Insets.of(contentInsets.left + this.mInsetState.mInsetLeft, contentInsets.top + this.mInsetState.mInsetTop, contentInsets.right + this.mInsetState.mInsetRight, contentInsets.bottom + this.mInsetState.mInsetBottom);
    }

    @Override
    public void setHotspot(float x, float y) {
        this.mInsetState.mDrawable.setHotspot(x, y);
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mInsetState.mDrawable.setHotspotBounds(left, top, right, bottom);
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        this.mInsetState.mDrawable.getHotspotBounds(outRect);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        this.mInsetState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    @Override
    public void setAlpha(int alpha) {
        this.mInsetState.mDrawable.setAlpha(alpha);
    }

    @Override
    public int getAlpha() {
        return this.mInsetState.mDrawable.getAlpha();
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        this.mInsetState.mDrawable.setColorFilter(cf);
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mInsetState.mDrawable.setTintList(tint);
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mInsetState.mDrawable.setTintMode(tintMode);
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.mInsetState.mDrawable.setLayoutDirection(layoutDirection);
    }

    @Override
    public int getOpacity() {
        return this.mInsetState.mDrawable.getOpacity();
    }

    @Override
    public boolean isStateful() {
        return this.mInsetState.mDrawable.isStateful();
    }

    @Override
    protected boolean onStateChange(int[] state) {
        boolean changed = this.mInsetState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    @Override
    protected boolean onLevelChange(int level) {
        return this.mInsetState.mDrawable.setLevel(level);
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mInsetState.mInsetLeft;
        r.top += this.mInsetState.mInsetTop;
        r.right -= this.mInsetState.mInsetRight;
        r.bottom -= this.mInsetState.mInsetBottom;
        this.mInsetState.mDrawable.setBounds(r.left, r.top, r.right, r.bottom);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mInsetState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mInsetState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public void getOutline(Outline outline) {
        this.mInsetState.mDrawable.getOutline(outline);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mInsetState.canConstantState()) {
            this.mInsetState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mInsetState;
        }
        return null;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mInsetState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    public Drawable getDrawable() {
        return this.mInsetState.mDrawable;
    }

    private InsetDrawable(InsetState state, Resources res) {
        this.mInsetState = new InsetState(state, this, res);
    }

    static final class InsetState
    extends Drawable.ConstantState {
        int[] mThemeAttrs;
        int mChangingConfigurations;
        Drawable mDrawable;
        int mInsetLeft;
        int mInsetTop;
        int mInsetRight;
        int mInsetBottom;
        boolean mCheckedConstantState;
        boolean mCanConstantState;

        InsetState(InsetState orig, InsetDrawable owner, Resources res) {
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mInsetLeft = orig.mInsetLeft;
                this.mInsetTop = orig.mInsetTop;
                this.mInsetRight = orig.mInsetRight;
                this.mInsetBottom = orig.mInsetBottom;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new InsetDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new InsetDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

