/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.SystemClock;

public class Interpolator {
    private int mValueCount;
    private int mFrameCount;
    private final long native_instance;

    public Interpolator(int valueCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = 2;
        this.native_instance = Interpolator.nativeConstructor(valueCount, 2);
    }

    public Interpolator(int valueCount, int frameCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = frameCount;
        this.native_instance = Interpolator.nativeConstructor(valueCount, frameCount);
    }

    public void reset(int valueCount) {
        this.reset(valueCount, 2);
    }

    public void reset(int valueCount, int frameCount) {
        this.mValueCount = valueCount;
        this.mFrameCount = frameCount;
        Interpolator.nativeReset(this.native_instance, valueCount, frameCount);
    }

    public final int getKeyFrameCount() {
        return this.mFrameCount;
    }

    public final int getValueCount() {
        return this.mValueCount;
    }

    public void setKeyFrame(int index, int msec, float[] values) {
        this.setKeyFrame(index, msec, values, null);
    }

    public void setKeyFrame(int index, int msec, float[] values, float[] blend) {
        if (index < 0 || index >= this.mFrameCount) {
            throw new IndexOutOfBoundsException();
        }
        if (values.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        if (blend != null && blend.length < 4) {
            throw new ArrayStoreException();
        }
        Interpolator.nativeSetKeyFrame(this.native_instance, index, msec, values, blend);
    }

    public void setRepeatMirror(float repeatCount, boolean mirror) {
        if (repeatCount >= 0.0f) {
            Interpolator.nativeSetRepeatMirror(this.native_instance, repeatCount, mirror);
        }
    }

    public Result timeToValues(float[] values) {
        return this.timeToValues((int)SystemClock.uptimeMillis(), values);
    }

    public Result timeToValues(int msec, float[] values) {
        if (values != null && values.length < this.mValueCount) {
            throw new ArrayStoreException();
        }
        switch (Interpolator.nativeTimeToValues(this.native_instance, msec, values)) {
            case 0: {
                return Result.NORMAL;
            }
            case 1: {
                return Result.FREEZE_START;
            }
        }
        return Result.FREEZE_END;
    }

    protected void finalize() throws Throwable {
        Interpolator.nativeDestructor(this.native_instance);
    }

    private static native long nativeConstructor(int var0, int var1);

    private static native void nativeDestructor(long var0);

    private static native void nativeReset(long var0, int var2, int var3);

    private static native void nativeSetKeyFrame(long var0, int var2, int var3, float[] var4, float[] var5);

    private static native void nativeSetRepeatMirror(long var0, float var2, boolean var3);

    private static native int nativeTimeToValues(long var0, int var2, float[] var3);

    public static enum Result {
        NORMAL,
        FREEZE_START,
        FREEZE_END;

    }
}

