/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.RoundRobinScheduler;
import android.util.Log;
import java.util.HashMap;

public class OneShotScheduler
extends RoundRobinScheduler {
    private HashMap<String, Integer> scheduled = new HashMap();
    private final boolean mLogVerbose = Log.isLoggable("OneShotScheduler", 2);
    private static final String TAG = "OneShotScheduler";

    public OneShotScheduler(FilterGraph graph) {
        super(graph);
    }

    @Override
    public void reset() {
        super.reset();
        this.scheduled.clear();
    }

    @Override
    public Filter scheduleNextNode() {
        Filter first = null;
        while (true) {
            Filter filter;
            if ((filter = super.scheduleNextNode()) == null) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "No filters available to run.");
                }
                return null;
            }
            if (!this.scheduled.containsKey(filter.getName())) {
                if (filter.getNumberOfConnectedInputs() == 0) {
                    this.scheduled.put(filter.getName(), 1);
                }
                if (this.mLogVerbose) {
                    Log.v(TAG, "Scheduling filter \"" + filter.getName() + "\" of type " + filter.getFilterClassName());
                }
                return filter;
            }
            if (first == filter) break;
            if (first != null) continue;
            first = filter;
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "One pass through graph completed.");
        }
        return null;
    }
}

