/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.drm.DrmConvertedStatus;
import android.drm.DrmErrorEvent;
import android.drm.DrmEvent;
import android.drm.DrmInfo;
import android.drm.DrmInfoEvent;
import android.drm.DrmInfoRequest;
import android.drm.DrmInfoStatus;
import android.drm.DrmRights;
import android.drm.DrmStore;
import android.drm.DrmSupportInfo;
import android.drm.DrmUtils;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class DrmManagerClient {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_UNKNOWN = -2000;
    public static final int INVALID_SESSION = -1;
    HandlerThread mInfoThread;
    HandlerThread mEventThread;
    private static final String TAG = "DrmManagerClient";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private static final int ACTION_REMOVE_ALL_RIGHTS = 1001;
    private static final int ACTION_PROCESS_DRM_INFO = 1002;
    private int mUniqueId;
    private long mNativeContext;
    private volatile boolean mReleased;
    private Context mContext;
    private InfoHandler mInfoHandler;
    private EventHandler mEventHandler;
    private OnInfoListener mOnInfoListener;
    private OnEventListener mOnEventListener;
    private OnErrorListener mOnErrorListener;

    public static void notify(Object thisReference, int uniqueId, int infoType, String message) {
        DrmManagerClient instance = (DrmManagerClient)((WeakReference)thisReference).get();
        if (null != instance && null != instance.mInfoHandler) {
            Message m = instance.mInfoHandler.obtainMessage(1, uniqueId, infoType, message);
            instance.mInfoHandler.sendMessage(m);
        }
    }

    public DrmManagerClient(Context context) {
        this.mContext = context;
        this.createEventThreads();
        this.mUniqueId = this._initialize();
        this.mCloseGuard.open("release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        if (this.mReleased) {
            return;
        }
        this.mReleased = true;
        if (this.mEventHandler != null) {
            this.mEventThread.quit();
            this.mEventThread = null;
        }
        if (this.mInfoHandler != null) {
            this.mInfoThread.quit();
            this.mInfoThread = null;
        }
        this.mEventHandler = null;
        this.mInfoHandler = null;
        this.mOnEventListener = null;
        this.mOnInfoListener = null;
        this.mOnErrorListener = null;
        this._release(this.mUniqueId);
        this.mCloseGuard.close();
    }

    public synchronized void setOnInfoListener(OnInfoListener infoListener) {
        this.mOnInfoListener = infoListener;
        if (null != infoListener) {
            this.createListeners();
        }
    }

    public synchronized void setOnEventListener(OnEventListener eventListener) {
        this.mOnEventListener = eventListener;
        if (null != eventListener) {
            this.createListeners();
        }
    }

    public synchronized void setOnErrorListener(OnErrorListener errorListener) {
        this.mOnErrorListener = errorListener;
        if (null != errorListener) {
            this.createListeners();
        }
    }

    public String[] getAvailableDrmEngines() {
        DrmSupportInfo[] supportInfos = this._getAllSupportInfo(this.mUniqueId);
        ArrayList<String> descriptions = new ArrayList<String>();
        for (int i = 0; i < supportInfos.length; ++i) {
            descriptions.add(supportInfos[i].getDescriprition());
        }
        String[] drmEngines = new String[descriptions.size()];
        return descriptions.toArray(drmEngines);
    }

    public ContentValues getConstraints(String path, int action) {
        if (null == path || path.equals("") || !DrmStore.Action.isValid(action)) {
            throw new IllegalArgumentException("Given usage or path is invalid/null");
        }
        return this._getConstraints(this.mUniqueId, path, action);
    }

    public ContentValues getMetadata(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path is invalid/null");
        }
        return this._getMetadata(this.mUniqueId, path);
    }

    public ContentValues getConstraints(Uri uri, int action) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getConstraints(this.convertUriToPath(uri), action);
    }

    public ContentValues getMetadata(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getMetadata(this.convertUriToPath(uri));
    }

    public int saveRights(DrmRights drmRights, String rightsPath, String contentPath) throws IOException {
        if (null == drmRights || !drmRights.isValid()) {
            throw new IllegalArgumentException("Given drmRights or contentPath is not valid");
        }
        if (null != rightsPath && !rightsPath.equals("")) {
            DrmUtils.writeToFile(rightsPath, drmRights.getData());
        }
        return this._saveRights(this.mUniqueId, drmRights, rightsPath, contentPath);
    }

    public void installDrmEngine(String engineFilePath) {
        if (null == engineFilePath || engineFilePath.equals("")) {
            throw new IllegalArgumentException("Given engineFilePath: " + engineFilePath + "is not valid");
        }
        this._installDrmEngine(this.mUniqueId, engineFilePath);
    }

    public boolean canHandle(String path, String mimeType) {
        if ((null == path || path.equals("")) && (null == mimeType || mimeType.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._canHandle(this.mUniqueId, path, mimeType);
    }

    public boolean canHandle(Uri uri, String mimeType) {
        if (!(null != uri && Uri.EMPTY != uri || null != mimeType && !mimeType.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        return this.canHandle(this.convertUriToPath(uri), mimeType);
    }

    public int processDrmInfo(DrmInfo drmInfo) {
        if (null == drmInfo || !drmInfo.isValid()) {
            throw new IllegalArgumentException("Given drmInfo is invalid/null");
        }
        int result = -2000;
        if (null != this.mEventHandler) {
            Message msg = this.mEventHandler.obtainMessage(1002, drmInfo);
            result = this.mEventHandler.sendMessage(msg) ? 0 : result;
        }
        return result;
    }

    public DrmInfo acquireDrmInfo(DrmInfoRequest drmInfoRequest) {
        if (null == drmInfoRequest || !drmInfoRequest.isValid()) {
            throw new IllegalArgumentException("Given drmInfoRequest is invalid/null");
        }
        return this._acquireDrmInfo(this.mUniqueId, drmInfoRequest);
    }

    public int acquireRights(DrmInfoRequest drmInfoRequest) {
        DrmInfo drmInfo = this.acquireDrmInfo(drmInfoRequest);
        if (null == drmInfo) {
            return -2000;
        }
        return this.processDrmInfo(drmInfo);
    }

    public int getDrmObjectType(String path, String mimeType) {
        if ((null == path || path.equals("")) && (null == mimeType || mimeType.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._getDrmObjectType(this.mUniqueId, path, mimeType);
    }

    public int getDrmObjectType(Uri uri, String mimeType) {
        if (!(null != uri && Uri.EMPTY != uri || null != mimeType && !mimeType.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        String path = "";
        try {
            path = this.convertUriToPath(uri);
        }
        catch (Exception e) {
            Log.w(TAG, "Given Uri could not be found in media store");
        }
        return this.getDrmObjectType(path, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOriginalMimeType(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path should be non null");
        }
        String mime = null;
        FileInputStream is = null;
        try {
            FileDescriptor fd = null;
            File file = new File(path);
            if (file.exists()) {
                is = new FileInputStream(file);
                fd = is.getFD();
            }
            mime = this._getOriginalMimeType(this.mUniqueId, path, fd);
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return mime;
    }

    public String getOriginalMimeType(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.getOriginalMimeType(this.convertUriToPath(uri));
    }

    public int checkRightsStatus(String path) {
        return this.checkRightsStatus(path, 0);
    }

    public int checkRightsStatus(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri));
    }

    public int checkRightsStatus(String path, int action) {
        if (null == path || path.equals("") || !DrmStore.Action.isValid(action)) {
            throw new IllegalArgumentException("Given path or action is not valid");
        }
        return this._checkRightsStatus(this.mUniqueId, path, action);
    }

    public int checkRightsStatus(Uri uri, int action) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri), action);
    }

    public int removeRights(String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException("Given path should be non null");
        }
        return this._removeRights(this.mUniqueId, path);
    }

    public int removeRights(Uri uri) {
        if (null == uri || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.removeRights(this.convertUriToPath(uri));
    }

    public int removeAllRights() {
        int result = -2000;
        if (null != this.mEventHandler) {
            Message msg = this.mEventHandler.obtainMessage(1001);
            result = this.mEventHandler.sendMessage(msg) ? 0 : result;
        }
        return result;
    }

    public int openConvertSession(String mimeType) {
        if (null == mimeType || mimeType.equals("")) {
            throw new IllegalArgumentException("Path or the mimeType should be non null");
        }
        return this._openConvertSession(this.mUniqueId, mimeType);
    }

    public DrmConvertedStatus convertData(int convertId, byte[] inputData) {
        if (null == inputData || 0 >= inputData.length) {
            throw new IllegalArgumentException("Given inputData should be non null");
        }
        return this._convertData(this.mUniqueId, convertId, inputData);
    }

    public DrmConvertedStatus closeConvertSession(int convertId) {
        return this._closeConvertSession(this.mUniqueId, convertId);
    }

    private int getEventType(int infoType) {
        int eventType = -1;
        switch (infoType) {
            case 1: 
            case 2: 
            case 3: {
                eventType = 1002;
            }
        }
        return eventType;
    }

    private int getErrorType(int infoType) {
        int error = -1;
        switch (infoType) {
            case 1: 
            case 2: 
            case 3: {
                error = 2006;
            }
        }
        return error;
    }

    private String convertUriToPath(Uri uri) {
        String path = null;
        if (null != uri) {
            String scheme = uri.getScheme();
            if (null == scheme || scheme.equals("") || scheme.equals("file")) {
                path = uri.getPath();
            } else if (scheme.equals("http")) {
                path = uri.toString();
            } else if (scheme.equals("content")) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = null;
                try {
                    cursor = this.mContext.getContentResolver().query(uri, projection, null, null, null);
                    if (null == cursor || 0 == cursor.getCount() || !cursor.moveToFirst()) {
                        throw new IllegalArgumentException("Given Uri could not be found in media store");
                    }
                    int pathIndex = cursor.getColumnIndexOrThrow("_data");
                    path = cursor.getString(pathIndex);
                }
                catch (SQLiteException e) {
                    throw new IllegalArgumentException("Given Uri is not formatted in a way so that it can be found in media store.");
                }
                finally {
                    if (null != cursor) {
                        cursor.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("Given Uri scheme is not supported");
            }
        }
        return path;
    }

    private native int _initialize();

    private native void _setListeners(int var1, Object var2);

    private native void _release(int var1);

    private native void _installDrmEngine(int var1, String var2);

    private native ContentValues _getConstraints(int var1, String var2, int var3);

    private native ContentValues _getMetadata(int var1, String var2);

    private native boolean _canHandle(int var1, String var2, String var3);

    private native DrmInfoStatus _processDrmInfo(int var1, DrmInfo var2);

    private native DrmInfo _acquireDrmInfo(int var1, DrmInfoRequest var2);

    private native int _saveRights(int var1, DrmRights var2, String var3, String var4);

    private native int _getDrmObjectType(int var1, String var2, String var3);

    private native String _getOriginalMimeType(int var1, String var2, FileDescriptor var3);

    private native int _checkRightsStatus(int var1, String var2, int var3);

    private native int _removeRights(int var1, String var2);

    private native int _removeAllRights(int var1);

    private native int _openConvertSession(int var1, String var2);

    private native DrmConvertedStatus _convertData(int var1, int var2, byte[] var3);

    private native DrmConvertedStatus _closeConvertSession(int var1, int var2);

    private native DrmSupportInfo[] _getAllSupportInfo(int var1);

    private void createEventThreads() {
        if (this.mEventHandler == null && this.mInfoHandler == null) {
            this.mInfoThread = new HandlerThread("DrmManagerClient.InfoHandler");
            this.mInfoThread.start();
            this.mInfoHandler = new InfoHandler(this.mInfoThread.getLooper());
            this.mEventThread = new HandlerThread("DrmManagerClient.EventHandler");
            this.mEventThread.start();
            this.mEventHandler = new EventHandler(this.mEventThread.getLooper());
        }
    }

    private void createListeners() {
        this._setListeners(this.mUniqueId, new WeakReference<DrmManagerClient>(this));
    }

    static {
        System.loadLibrary("drmframework_jni");
    }

    private class InfoHandler
    extends Handler {
        public static final int INFO_EVENT_TYPE = 1;

        public InfoHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            DrmInfoEvent info = null;
            DrmErrorEvent error = null;
            switch (msg.what) {
                case 1: {
                    int uniqueId = msg.arg1;
                    int infoType = msg.arg2;
                    String message = msg.obj.toString();
                    switch (infoType) {
                        case 2: {
                            try {
                                DrmUtils.removeFile(message);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            info = new DrmInfoEvent(uniqueId, infoType, message);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            info = new DrmInfoEvent(uniqueId, infoType, message);
                            break;
                        }
                        default: {
                            error = new DrmErrorEvent(uniqueId, infoType, message);
                        }
                    }
                    if (null != DrmManagerClient.this.mOnInfoListener && null != info) {
                        DrmManagerClient.this.mOnInfoListener.onInfo(DrmManagerClient.this, info);
                    }
                    if (null != DrmManagerClient.this.mOnErrorListener && null != error) {
                        DrmManagerClient.this.mOnErrorListener.onError(DrmManagerClient.this, error);
                    }
                    return;
                }
            }
            Log.e(DrmManagerClient.TAG, "Unknown message type " + msg.what);
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            DrmEvent event = null;
            DrmErrorEvent error = null;
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            switch (msg.what) {
                case 1002: {
                    DrmInfo drmInfo = (DrmInfo)msg.obj;
                    DrmInfoStatus status = DrmManagerClient.this._processDrmInfo(DrmManagerClient.this.mUniqueId, drmInfo);
                    attributes.put("drm_info_status_object", status);
                    attributes.put("drm_info_object", drmInfo);
                    if (null != status && 1 == status.statusCode) {
                        event = new DrmEvent(DrmManagerClient.this.mUniqueId, DrmManagerClient.this.getEventType(status.infoType), null, attributes);
                        break;
                    }
                    int infoType = null != status ? status.infoType : drmInfo.getInfoType();
                    error = new DrmErrorEvent(DrmManagerClient.this.mUniqueId, DrmManagerClient.this.getErrorType(infoType), null, attributes);
                    break;
                }
                case 1001: {
                    if (0 == DrmManagerClient.this._removeAllRights(DrmManagerClient.this.mUniqueId)) {
                        event = new DrmEvent(DrmManagerClient.this.mUniqueId, 1001, null);
                        break;
                    }
                    error = new DrmErrorEvent(DrmManagerClient.this.mUniqueId, 2007, null);
                    break;
                }
                default: {
                    Log.e(DrmManagerClient.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
            if (null != DrmManagerClient.this.mOnEventListener && null != event) {
                DrmManagerClient.this.mOnEventListener.onEvent(DrmManagerClient.this, event);
            }
            if (null != DrmManagerClient.this.mOnErrorListener && null != error) {
                DrmManagerClient.this.mOnErrorListener.onError(DrmManagerClient.this, error);
            }
        }
    }

    public static interface OnErrorListener {
        public void onError(DrmManagerClient var1, DrmErrorEvent var2);
    }

    public static interface OnEventListener {
        public void onEvent(DrmManagerClient var1, DrmEvent var2);
    }

    public static interface OnInfoListener {
        public void onInfo(DrmManagerClient var1, DrmInfoEvent var2);
    }
}

