/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandleAppName;
import android.os.Debug;
import android.os.Process;
import android.os.UserHandle;
import dalvik.system.VMRuntime;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleHello
extends ChunkHandler {
    public static final int CHUNK_HELO = DdmHandleHello.type((String)"HELO");
    public static final int CHUNK_WAIT = DdmHandleHello.type((String)"WAIT");
    public static final int CHUNK_FEAT = DdmHandleHello.type((String)"FEAT");
    private static DdmHandleHello mInstance = new DdmHandleHello();
    private static final String[] FRAMEWORK_FEATURES = new String[]{"opengl-tracing", "view-hierarchy"};

    private DdmHandleHello() {
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_HELO, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_FEAT, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_HELO) {
            return this.handleHELO(request);
        }
        if (type == CHUNK_FEAT) {
            return this.handleFEAT(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)type));
    }

    private Chunk handleHELO(Chunk request) {
        ByteBuffer in = DdmHandleHello.wrapChunk((Chunk)request);
        int serverProtoVers = in.getInt();
        String vmName = System.getProperty("java.vm.name", "?");
        String vmVersion = System.getProperty("java.vm.version", "?");
        String vmIdent = vmName + " v" + vmVersion;
        String appName = DdmHandleAppName.getAppName();
        VMRuntime vmRuntime = VMRuntime.getRuntime();
        String instructionSetDescription = vmRuntime.is64Bit() ? "64-bit" : "32-bit";
        String vmInstructionSet = vmRuntime.vmInstructionSet();
        if (vmInstructionSet != null && vmInstructionSet.length() > 0) {
            instructionSetDescription = instructionSetDescription + " (" + vmInstructionSet + ")";
        }
        String vmFlags = "CheckJNI=" + (vmRuntime.isCheckJniEnabled() ? "true" : "false");
        ByteBuffer out = ByteBuffer.allocate(28 + vmIdent.length() * 2 + appName.length() * 2 + instructionSetDescription.length() * 2 + vmFlags.length() * 2);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(1);
        out.putInt(Process.myPid());
        out.putInt(vmIdent.length());
        out.putInt(appName.length());
        DdmHandleHello.putString((ByteBuffer)out, (String)vmIdent);
        DdmHandleHello.putString((ByteBuffer)out, (String)appName);
        out.putInt(UserHandle.myUserId());
        out.putInt(instructionSetDescription.length());
        DdmHandleHello.putString((ByteBuffer)out, (String)instructionSetDescription);
        out.putInt(vmFlags.length());
        DdmHandleHello.putString((ByteBuffer)out, (String)vmFlags);
        Chunk reply = new Chunk(CHUNK_HELO, out);
        if (Debug.waitingForDebugger()) {
            DdmHandleHello.sendWAIT(0);
        }
        return reply;
    }

    private Chunk handleFEAT(Chunk request) {
        int i;
        int i2;
        String[] vmFeatures = Debug.getVmFeatureList();
        int size = 4 + 4 * (vmFeatures.length + FRAMEWORK_FEATURES.length);
        for (i2 = vmFeatures.length - 1; i2 >= 0; --i2) {
            size += vmFeatures[i2].length() * 2;
        }
        for (i2 = FRAMEWORK_FEATURES.length - 1; i2 >= 0; --i2) {
            size += FRAMEWORK_FEATURES[i2].length() * 2;
        }
        ByteBuffer out = ByteBuffer.allocate(size);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(vmFeatures.length + FRAMEWORK_FEATURES.length);
        for (i = vmFeatures.length - 1; i >= 0; --i) {
            out.putInt(vmFeatures[i].length());
            DdmHandleHello.putString((ByteBuffer)out, (String)vmFeatures[i]);
        }
        for (i = FRAMEWORK_FEATURES.length - 1; i >= 0; --i) {
            out.putInt(FRAMEWORK_FEATURES[i].length());
            DdmHandleHello.putString((ByteBuffer)out, (String)FRAMEWORK_FEATURES[i]);
        }
        return new Chunk(CHUNK_FEAT, out);
    }

    public static void sendWAIT(int reason) {
        byte[] data = new byte[]{(byte)reason};
        Chunk waitChunk = new Chunk(CHUNK_WAIT, data, 0, 1);
        DdmServer.sendChunk((Chunk)waitChunk);
    }
}

