/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;

public class KeyguardManager {
    private IWindowManager mWM = WindowManagerGlobal.getWindowManagerService();
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isKeyguardSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.setPackage("com.android.settings");
        return intent;
    }

    KeyguardManager() {
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String tag) {
        return new KeyguardLock(tag);
    }

    public boolean isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        try {
            return this.mWM.inKeyguardRestrictedInputMode();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    @Deprecated
    public void exitKeyguardSecurely(final OnKeyguardExitResult callback) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean success) throws RemoteException {
                    if (callback != null) {
                        callback.onKeyguardExitResult(success);
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    public class KeyguardLock {
        private final IBinder mToken = new Binder();
        private final String mTag;

        KeyguardLock(String tag) {
            this.mTag = tag;
        }

        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

