/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.WorkSource;

public class AlarmManager {
    private static final String TAG = "AlarmManager";
    public static final int RTC_WAKEUP = 0;
    public static final int RTC = 1;
    public static final int ELAPSED_REALTIME_WAKEUP = 2;
    public static final int ELAPSED_REALTIME = 3;
    public static final String ACTION_NEXT_ALARM_CLOCK_CHANGED = "android.app.action.NEXT_ALARM_CLOCK_CHANGED";
    public static final long WINDOW_EXACT = 0L;
    public static final long WINDOW_HEURISTIC = -1L;
    private final IAlarmManager mService;
    private final boolean mAlwaysExact;
    public static final long INTERVAL_FIFTEEN_MINUTES = 900000L;
    public static final long INTERVAL_HALF_HOUR = 1800000L;
    public static final long INTERVAL_HOUR = 3600000L;
    public static final long INTERVAL_HALF_DAY = 43200000L;
    public static final long INTERVAL_DAY = 86400000L;

    AlarmManager(IAlarmManager service, Context ctx) {
        this.mService = service;
        int sdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mAlwaysExact = sdkVersion < 19;
    }

    private long legacyExactLength() {
        return this.mAlwaysExact ? 0L : -1L;
    }

    public void set(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, operation, null, null);
    }

    public void setRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), intervalMillis, operation, null, null);
    }

    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, operation, null, null);
    }

    public void setExact(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, operation, null, null);
    }

    public void setAlarmClock(AlarmClockInfo info, PendingIntent operation) {
        this.setImpl(0, info.getTriggerTime(), 0L, 0L, operation, null, info);
    }

    public void set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, operation, workSource, null);
    }

    private void setImpl(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource, AlarmClockInfo alarmClock) {
        if (triggerAtMillis < 0L) {
            triggerAtMillis = 0L;
        }
        try {
            this.mService.set(type, triggerAtMillis, windowMillis, intervalMillis, operation, workSource, alarmClock);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, intervalMillis, operation, null, null);
    }

    public void cancel(PendingIntent operation) {
        try {
            this.mService.remove(operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setTime(long millis) {
        try {
            this.mService.setTime(millis);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setTimeZone(String timeZone) {
        try {
            this.mService.setTimeZone(timeZone);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public AlarmClockInfo getNextAlarmClock() {
        return this.getNextAlarmClock(UserHandle.myUserId());
    }

    public AlarmClockInfo getNextAlarmClock(int userId) {
        try {
            return this.mService.getNextAlarmClock(userId);
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public static final class AlarmClockInfo
    implements Parcelable {
        private final long mTriggerTime;
        private final PendingIntent mShowIntent;
        public static final Parcelable.Creator<AlarmClockInfo> CREATOR = new Parcelable.Creator<AlarmClockInfo>(){

            @Override
            public AlarmClockInfo createFromParcel(Parcel in) {
                return new AlarmClockInfo(in);
            }

            public AlarmClockInfo[] newArray(int size) {
                return new AlarmClockInfo[size];
            }
        };

        public AlarmClockInfo(long triggerTime, PendingIntent showIntent) {
            this.mTriggerTime = triggerTime;
            this.mShowIntent = showIntent;
        }

        AlarmClockInfo(Parcel in) {
            this.mTriggerTime = in.readLong();
            this.mShowIntent = (PendingIntent)in.readParcelable(PendingIntent.class.getClassLoader());
        }

        public long getTriggerTime() {
            return this.mTriggerTime;
        }

        public PendingIntent getShowIntent() {
            return this.mShowIntent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mTriggerTime);
            dest.writeParcelable(this.mShowIntent, flags);
        }
    }
}

