/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.util.StateSet;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class StateListAnimator {
    private final ArrayList<Tuple> mTuples = new ArrayList();
    private Tuple mLastMatch = null;
    private Animator mRunningAnimator = null;
    private WeakReference<View> mViewRef;
    private AnimatorListenerAdapter mAnimatorListener = new AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(Animator animation) {
            animation.setTarget(null);
            if (StateListAnimator.this.mRunningAnimator == animation) {
                StateListAnimator.this.mRunningAnimator = null;
            }
        }
    };

    public void addState(int[] specs, Animator animator2) {
        Tuple tuple = new Tuple(specs, animator2);
        tuple.mAnimator.addListener(this.mAnimatorListener);
        this.mTuples.add(tuple);
    }

    public Animator getRunningAnimator() {
        return this.mRunningAnimator;
    }

    public View getTarget() {
        return this.mViewRef == null ? null : (View)this.mViewRef.get();
    }

    public void setTarget(View view) {
        View current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.mViewRef = new WeakReference<View>(view);
        }
    }

    private void clearTarget() {
        int size = this.mTuples.size();
        for (int i = 0; i < size; ++i) {
            this.mTuples.get((int)i).mAnimator.setTarget(null);
        }
        this.mViewRef = null;
        this.mLastMatch = null;
        this.mRunningAnimator = null;
    }

    public void setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches(tuple.mSpecs, state)) continue;
            match = tuple;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        match.mAnimator.setTarget(this.getTarget());
        this.mRunningAnimator = match.mAnimator;
        this.mRunningAnimator.start();
    }

    private void cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    public ArrayList<Tuple> getTuples() {
        return this.mTuples;
    }

    public void jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
        }
    }

    public static class Tuple {
        final int[] mSpecs;
        final Animator mAnimator;

        private Tuple(int[] specs, Animator animator2) {
            this.mSpecs = specs;
            this.mAnimator = animator2;
        }

        public int[] getSpecs() {
            return this.mSpecs;
        }

        public Animator getAnimator() {
            return this.mAnimator;
        }
    }
}

