/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.ObjectAnimator;
import android.animation.PathKeyframes;
import android.animation.PropertyValuesHolder;
import android.animation.StateListAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.PathParser;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final String TAG = "AnimatorInflater";
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_PATH = 2;
    private static final int VALUE_TYPE_COLOR = 4;
    private static final int VALUE_TYPE_CUSTOM = 5;
    private static final boolean DBG_ANIMATOR_INFLATER = false;

    public static Animator loadAnimator(Context context, int id2) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(context.getResources(), context.getTheme(), id2);
    }

    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int id2) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(resources, theme, id2, 1.0f);
    }

    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int id2, float pathErrorScale) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = resources.getAnimation(id2);
            Animator animator2 = AnimatorInflater.createAnimatorFromXml(resources, theme, parser, pathErrorScale);
            return animator2;
        }
    }

    public static StateListAnimator loadStateListAnimator(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            StateListAnimator stateListAnimator = AnimatorInflater.createStateListAnimatorFromXml(context, parser, Xml.asAttributeSet(parser));
            return stateListAnimator;
        }
    }

    private static StateListAnimator createStateListAnimatorFromXml(Context context, XmlPullParser parser, AttributeSet attributeSet) throws IOException, XmlPullParserException {
        StateListAnimator stateListAnimator = new StateListAnimator();
        while (true) {
            int type = parser.next();
            switch (type) {
                case 1: 
                case 3: {
                    return stateListAnimator;
                }
                case 2: {
                    Animator animator2 = null;
                    if (!"item".equals(parser.getName())) break;
                    int attributeCount = parser.getAttributeCount();
                    int[] states = new int[attributeCount];
                    int stateIndex = 0;
                    for (int i = 0; i < attributeCount; ++i) {
                        int attrName = attributeSet.getAttributeNameResource(i);
                        if (attrName == 16843213) {
                            animator2 = AnimatorInflater.loadAnimator(context, attributeSet.getAttributeResourceValue(i, 0));
                            continue;
                        }
                        states[stateIndex++] = attributeSet.getAttributeBooleanValue(i, false) ? attrName : -attrName;
                    }
                    if (animator2 == null) {
                        animator2 = AnimatorInflater.createAnimatorFromXml(context.getResources(), context.getTheme(), parser, 1.0f);
                    }
                    if (animator2 == null) {
                        throw new Resources.NotFoundException("animation state item must have a valid animation");
                    }
                    stateListAnimator.addState(StateSet.trimStateSet(states, stateIndex), animator2);
                }
            }
        }
    }

    private static void parseAnimatorFromTypeArray(ValueAnimator anim2, TypedArray arrayAnimator, TypedArray arrayObjectAnimator, float pixelSize) {
        int toType;
        long duration = arrayAnimator.getInt(1, 300);
        long startDelay = arrayAnimator.getInt(2, 0);
        int valueType = arrayAnimator.getInt(7, 0);
        TypeEvaluator evaluator = null;
        boolean getFloats = valueType == 0;
        TypedValue tvFrom = arrayAnimator.peekValue(5);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = arrayAnimator.peekValue(6);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (valueType == 2) {
            evaluator = AnimatorInflater.setupAnimatorForPath(anim2, arrayAnimator);
        } else {
            if (hasFrom && fromType >= 28 && fromType <= 31 || hasTo && toType >= 28 && toType <= 31) {
                getFloats = false;
                evaluator = ArgbEvaluator.getInstance();
            }
            AnimatorInflater.setupValues(anim2, arrayAnimator, getFloats, hasFrom, fromType, hasTo, toType);
        }
        anim2.setDuration(duration);
        anim2.setStartDelay(startDelay);
        if (arrayAnimator.hasValue(3)) {
            anim2.setRepeatCount(arrayAnimator.getInt(3, 0));
        }
        if (arrayAnimator.hasValue(4)) {
            anim2.setRepeatMode(arrayAnimator.getInt(4, 1));
        }
        if (evaluator != null) {
            anim2.setEvaluator(evaluator);
        }
        if (arrayObjectAnimator != null) {
            AnimatorInflater.setupObjectAnimator(anim2, arrayObjectAnimator, getFloats, pixelSize);
        }
    }

    private static TypeEvaluator setupAnimatorForPath(ValueAnimator anim2, TypedArray arrayAnimator) {
        PathDataEvaluator evaluator = null;
        String fromString = arrayAnimator.getString(5);
        String toString = arrayAnimator.getString(6);
        PathParser.PathDataNode[] nodesFrom = PathParser.createNodesFromPathData(fromString);
        PathParser.PathDataNode[] nodesTo = PathParser.createNodesFromPathData(toString);
        if (nodesFrom != null) {
            if (nodesTo != null) {
                anim2.setObjectValues(nodesFrom, nodesTo);
                if (!PathParser.canMorph(nodesFrom, nodesTo)) {
                    throw new InflateException(arrayAnimator.getPositionDescription() + " Can't morph from " + fromString + " to " + toString);
                }
            } else {
                anim2.setObjectValues(new Object[]{nodesFrom});
            }
            evaluator = new PathDataEvaluator(PathParser.deepCopyNodes(nodesFrom));
        } else if (nodesTo != null) {
            anim2.setObjectValues(new Object[]{nodesTo});
            evaluator = new PathDataEvaluator(PathParser.deepCopyNodes(nodesTo));
        }
        return evaluator;
    }

    private static void setupObjectAnimator(ValueAnimator anim2, TypedArray arrayObjectAnimator, boolean getFloats, float pixelSize) {
        ObjectAnimator oa = (ObjectAnimator)anim2;
        String pathData = arrayObjectAnimator.getString(1);
        if (pathData != null) {
            Keyframes yKeyframes;
            Keyframes xKeyframes;
            String propertyXName = arrayObjectAnimator.getString(2);
            String propertyYName = arrayObjectAnimator.getString(3);
            if (propertyXName == null && propertyYName == null) {
                throw new InflateException(arrayObjectAnimator.getPositionDescription() + " propertyXName or propertyYName is needed for PathData");
            }
            Path path = PathParser.createPathFromPathData(pathData);
            float error = 0.5f * pixelSize;
            PathKeyframes keyframeSet = KeyframeSet.ofPath(path, error);
            if (getFloats) {
                xKeyframes = keyframeSet.createXFloatKeyframes();
                yKeyframes = keyframeSet.createYFloatKeyframes();
            } else {
                xKeyframes = keyframeSet.createXIntKeyframes();
                yKeyframes = keyframeSet.createYIntKeyframes();
            }
            PropertyValuesHolder x = null;
            PropertyValuesHolder y = null;
            if (propertyXName != null) {
                x = PropertyValuesHolder.ofKeyframes(propertyXName, xKeyframes);
            }
            if (propertyYName != null) {
                y = PropertyValuesHolder.ofKeyframes(propertyYName, yKeyframes);
            }
            if (x == null) {
                oa.setValues(y);
            } else if (y == null) {
                oa.setValues(x);
            } else {
                oa.setValues(x, y);
            }
        } else {
            String propertyName = arrayObjectAnimator.getString(0);
            oa.setPropertyName(propertyName);
        }
    }

    private static void setupValues(ValueAnimator anim2, TypedArray arrayAnimator, boolean getFloats, boolean hasFrom, int fromType, boolean hasTo, int toType) {
        int valueFromIndex = 5;
        int valueToIndex = 6;
        if (getFloats) {
            if (hasFrom) {
                float valueFrom = fromType == 5 ? arrayAnimator.getDimension(valueFromIndex, 0.0f) : arrayAnimator.getFloat(valueFromIndex, 0.0f);
                if (hasTo) {
                    float valueTo = toType == 5 ? arrayAnimator.getDimension(valueToIndex, 0.0f) : arrayAnimator.getFloat(valueToIndex, 0.0f);
                    anim2.setFloatValues(valueFrom, valueTo);
                } else {
                    anim2.setFloatValues(valueFrom);
                }
            } else {
                float valueTo = toType == 5 ? arrayAnimator.getDimension(valueToIndex, 0.0f) : arrayAnimator.getFloat(valueToIndex, 0.0f);
                anim2.setFloatValues(valueTo);
            }
        } else if (hasFrom) {
            int valueFrom = fromType == 5 ? (int)arrayAnimator.getDimension(valueFromIndex, 0.0f) : (fromType >= 28 && fromType <= 31 ? arrayAnimator.getColor(valueFromIndex, 0) : arrayAnimator.getInt(valueFromIndex, 0));
            if (hasTo) {
                int valueTo = toType == 5 ? (int)arrayAnimator.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? arrayAnimator.getColor(valueToIndex, 0) : arrayAnimator.getInt(valueToIndex, 0));
                anim2.setIntValues(valueFrom, valueTo);
            } else {
                anim2.setIntValues(valueFrom);
            }
        } else if (hasTo) {
            int valueTo = toType == 5 ? (int)arrayAnimator.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? arrayAnimator.getColor(valueToIndex, 0) : arrayAnimator.getInt(valueToIndex, 0));
            anim2.setIntValues(valueTo);
        }
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, float pixelSize) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(res, theme, parser, Xml.asAttributeSet(parser), null, 0, pixelSize);
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering, float pixelSize) throws XmlPullParserException, IOException {
        int type;
        Animator anim2 = null;
        ArrayList<ObjectAnimator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("objectAnimator")) {
                anim2 = AnimatorInflater.loadObjectAnimator(res, theme, attrs, pixelSize);
            } else if (name.equals("animator")) {
                anim2 = AnimatorInflater.loadAnimator(res, theme, attrs, null, pixelSize);
            } else if (name.equals("set")) {
                anim2 = new AnimatorSet();
                TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.AnimatorSet, 0, 0) : res.obtainAttributes(attrs, R.styleable.AnimatorSet);
                int ordering = a.getInt(0, 0);
                AnimatorInflater.createAnimatorFromXml(res, theme, parser, attrs, (AnimatorSet)anim2, ordering, pixelSize);
                a.recycle();
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<ObjectAnimator>();
            }
            childAnims.add((ObjectAnimator)anim2);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator animator2 : childAnims) {
                animsArray[index++] = animator2;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim2;
    }

    private static ObjectAnimator loadObjectAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, float pathErrorScale) throws Resources.NotFoundException {
        ObjectAnimator anim2 = new ObjectAnimator();
        AnimatorInflater.loadAnimator(res, theme, attrs, anim2, pathErrorScale);
        return anim2;
    }

    private static ValueAnimator loadAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, ValueAnimator anim2, float pathErrorScale) throws Resources.NotFoundException {
        TypedArray arrayAnimator = null;
        TypedArray arrayObjectAnimator = null;
        arrayAnimator = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Animator, 0, 0) : res.obtainAttributes(attrs, R.styleable.Animator);
        if (anim2 != null) {
            arrayObjectAnimator = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.PropertyAnimator, 0, 0) : res.obtainAttributes(attrs, R.styleable.PropertyAnimator);
        }
        if (anim2 == null) {
            anim2 = new ValueAnimator();
        }
        AnimatorInflater.parseAnimatorFromTypeArray(anim2, arrayAnimator, arrayObjectAnimator, pathErrorScale);
        int resID = arrayAnimator.getResourceId(0, 0);
        if (resID > 0) {
            anim2.setInterpolator(AnimationUtils.loadInterpolator(res, theme, resID));
        }
        arrayAnimator.recycle();
        if (arrayObjectAnimator != null) {
            arrayObjectAnimator.recycle();
        }
        return anim2;
    }

    private static class PathDataEvaluator
    implements TypeEvaluator<PathParser.PathDataNode[]> {
        private PathParser.PathDataNode[] mNodeArray;

        private PathDataEvaluator() {
        }

        public PathDataEvaluator(PathParser.PathDataNode[] nodeArray) {
            this.mNodeArray = nodeArray;
        }

        @Override
        public PathParser.PathDataNode[] evaluate(float fraction2, PathParser.PathDataNode[] startPathData, PathParser.PathDataNode[] endPathData) {
            if (!PathParser.canMorph(startPathData, endPathData)) {
                throw new IllegalArgumentException("Can't interpolate between two incompatible pathData");
            }
            if (this.mNodeArray == null || !PathParser.canMorph(this.mNodeArray, startPathData)) {
                this.mNodeArray = PathParser.deepCopyNodes(startPathData);
            }
            for (int i = 0; i < startPathData.length; ++i) {
                this.mNodeArray[i].interpolatePathDataNode(startPathData[i], endPathData[i], fraction2);
            }
            return this.mNodeArray;
        }
    }
}

