/*
 * Copyright 2014 - 2015 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX6UL_PINFUNC_H
#define __DTS_IMX6UL_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define MX6UL_PAD_BOOT_MODE0__GPIO5_IO10                          0x0014 0x02A0 0x0000 0x5 0x0
#define MX6UL_PAD_BOOT_MODE1__GPIO5_IO11                          0x0018 0x02A4 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER0__GPIO5_IO00                        0x001C 0x02A8 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER1__GPIO5_IO01                        0x0020 0x02AC 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER2__GPIO5_IO02                        0x0024 0x02B0 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER3__GPIO5_IO03                        0x0028 0x02B4 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER4__GPIO5_IO04                        0x002C 0x02B8 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER5__GPIO5_IO05                        0x0030 0x02BC 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER6__GPIO5_IO06                        0x0034 0x02C0 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER7__GPIO5_IO07                        0x0038 0x02C4 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER8__GPIO5_IO08                        0x003C 0x02C8 0x0000 0x5 0x0
#define MX6UL_PAD_SNVS_TAMPER9__GPIO5_IO09                        0x0040 0x02CC 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_MOD__SJC_MOD                               0x0044 0x02D0 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_MOD__GPT2_CLK                              0x0044 0x02D0 0x05A0 0x1 0x0
#define MX6UL_PAD_JTAG_MOD__SPDIF_OUT                             0x0044 0x02D0 0x0000 0x2 0x0
#define MX6UL_PAD_JTAG_MOD__ENET1_REF_CLK_25M                     0x0044 0x02D0 0x0000 0x3 0x0
#define MX6UL_PAD_JTAG_MOD__CCM_PMIC_RDY                          0x0044 0x02D0 0x04C0 0x4 0x0
#define MX6UL_PAD_JTAG_MOD__GPIO1_IO10                            0x0044 0x02D0 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_MOD__SDMA_EXT_EVENT00                      0x0044 0x02D0 0x0610 0x6 0x0
#define MX6UL_PAD_JTAG_TMS__SJC_TMS                               0x0048 0x02D4 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_TMS__GPT2_CAPTURE1                         0x0048 0x02D4 0x0598 0x1 0x0
#define MX6UL_PAD_JTAG_TMS__SAI2_MCLK                             0x0048 0x02D4 0x05F0 0x2 0x0
#define MX6UL_PAD_JTAG_TMS__CCM_CLKO1                             0x0048 0x02D4 0x0000 0x3 0x0
#define MX6UL_PAD_JTAG_TMS__CCM_WAIT                              0x0048 0x02D4 0x0000 0x4 0x0
#define MX6UL_PAD_JTAG_TMS__GPIO1_IO11                            0x0048 0x02D4 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_TMS__SDMA_EXT_EVENT01                      0x0048 0x02D4 0x0614 0x6 0x0
#define MX6UL_PAD_JTAG_TMS__EPIT1_OUT                             0x0048 0x02D4 0x0000 0x8 0x0
#define MX6UL_PAD_JTAG_TDO__SJC_TDO                               0x004C 0x02D8 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_TDO__GPT2_CAPTURE2                         0x004C 0x02D8 0x059C 0x1 0x0
#define MX6UL_PAD_JTAG_TDO__SAI2_TX_SYNC                          0x004C 0x02D8 0x05FC 0x2 0x0
#define MX6UL_PAD_JTAG_TDO__CCM_CLKO2                             0x004C 0x02D8 0x0000 0x3 0x0
#define MX6UL_PAD_JTAG_TDO__CCM_STOP                              0x004C 0x02D8 0x0000 0x4 0x0
#define MX6UL_PAD_JTAG_TDO__GPIO1_IO12                            0x004C 0x02D8 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_TDO__MQS_RIGHT                             0x004C 0x02D8 0x0000 0x6 0x0
#define MX6UL_PAD_JTAG_TDO__EPIT2_OUT                             0x004C 0x02D8 0x0000 0x8 0x0
#define MX6UL_PAD_JTAG_TDI__SJC_TDI                               0x0050 0x02DC 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_TDI__GPT2_COMPARE1                         0x0050 0x02DC 0x0000 0x1 0x0
#define MX6UL_PAD_JTAG_TDI__SAI2_TX_BCLK                          0x0050 0x02DC 0x05F8 0x2 0x0
#define MX6UL_PAD_JTAG_TDI__PWM6_OUT                              0x0050 0x02DC 0x0000 0x4 0x0
#define MX6UL_PAD_JTAG_TDI__GPIO1_IO13                            0x0050 0x02DC 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_TDI__MQS_LEFT                              0x0050 0x02DC 0x0000 0x6 0x0
#define MX6UL_PAD_JTAG_TDI__SIM1_POWER_FAIL                       0x0050 0x02DC 0x0000 0x8 0x0
#define MX6UL_PAD_JTAG_TCK__SJC_TCK                               0x0054 0x02E0 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_TCK__GPT2_COMPARE2                         0x0054 0x02E0 0x0000 0x1 0x0
#define MX6UL_PAD_JTAG_TCK__SAI2_RX_DATA                          0x0054 0x02E0 0x05F4 0x2 0x0
#define MX6UL_PAD_JTAG_TCK__PWM7_OUT                              0x0054 0x02E0 0x0000 0x4 0x0
#define MX6UL_PAD_JTAG_TCK__GPIO1_IO14                            0x0054 0x02E0 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_TCK__REF_CLK_32K                           0x0054 0x02E0 0x0000 0x6 0x0
#define MX6UL_PAD_JTAG_TCK__SIM2_POWER_FAIL                       0x0054 0x02E0 0x0000 0x8 0x0
#define MX6UL_PAD_JTAG_TRST_B__SJC_TRSTB                          0x0058 0x02E4 0x0000 0x0 0x0
#define MX6UL_PAD_JTAG_TRST_B__GPT2_COMPARE3                      0x0058 0x02E4 0x0000 0x1 0x0
#define MX6UL_PAD_JTAG_TRST_B__SAI2_TX_DATA                       0x0058 0x02E4 0x0000 0x2 0x0
#define MX6UL_PAD_JTAG_TRST_B__PWM8_OUT                           0x0058 0x02E4 0x0000 0x4 0x0
#define MX6UL_PAD_JTAG_TRST_B__GPIO1_IO15                         0x0058 0x02E4 0x0000 0x5 0x0
#define MX6UL_PAD_JTAG_TRST_B__REF_CLK_24M                        0x0058 0x02E4 0x0000 0x6 0x0
#define MX6UL_PAD_JTAG_TRST_B__CAAM_RNG_OSC_OBS                   0x0058 0x02E4 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO00__I2C2_SCL                            0x005C 0x02E8 0x05AC 0x0 0x1
#define MX6UL_PAD_GPIO1_IO00__GPT1_CAPTURE1                       0x005C 0x02E8 0x058C 0x1 0x0
#define MX6UL_PAD_GPIO1_IO00__ANATOP_OTG1_ID                      0x005C 0x02E8 0x04B8 0x2 0x0
#define MX6UL_PAD_GPIO1_IO00__ENET1_REF_CLK1                      0x005C 0x02E8 0x0574 0x3 0x0
#define MX6UL_PAD_GPIO1_IO00__MQS_RIGHT                           0x005C 0x02E8 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO00__GPIO1_IO00                          0x005C 0x02E8 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO00__ENET1_1588_EVENT0_IN                0x005C 0x02E8 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO00__SRC_SYSTEM_RESET                    0x005C 0x02E8 0x0000 0x7 0x0
#define MX6UL_PAD_GPIO1_IO00__WDOG3_WDOG_B                        0x005C 0x02E8 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO01__I2C2_SDA                            0x0060 0x02EC 0x05B0 0x0 0x1
#define MX6UL_PAD_GPIO1_IO01__GPT1_COMPARE1                       0x0060 0x02EC 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO01__USB_OTG1_OC                         0x0060 0x02EC 0x0664 0x2 0x0
#define MX6UL_PAD_GPIO1_IO01__ENET2_REF_CLK2                      0x0060 0x02EC 0x057C 0x3 0x0
#define MX6UL_PAD_GPIO1_IO01__MQS_LEFT                            0x0060 0x02EC 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO01__GPIO1_IO01                          0x0060 0x02EC 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO01__ENET1_1588_EVENT0_OUT               0x0060 0x02EC 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO01__SRC_EARLY_RESET                     0x0060 0x02EC 0x0000 0x7 0x0
#define MX6UL_PAD_GPIO1_IO01__WDOG1_WDOG_B                        0x0060 0x02EC 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO02__I2C1_SCL                            0x0064 0x02F0 0x05A4 0x0 0x0
#define MX6UL_PAD_GPIO1_IO02__GPT1_COMPARE2                       0x0064 0x02F0 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO02__USB_OTG2_PWR                        0x0064 0x02F0 0x0000 0x2 0x0
#define MX6UL_PAD_GPIO1_IO02__ENET1_REF_CLK_25M                   0x0064 0x02F0 0x0000 0x3 0x0
#define MX6UL_PAD_GPIO1_IO02__USDHC1_WP                           0x0064 0x02F0 0x066C 0x4 0x0
#define MX6UL_PAD_GPIO1_IO02__GPIO1_IO02                          0x0064 0x02F0 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO02__SDMA_EXT_EVENT00                    0x0064 0x02F0 0x0610 0x6 0x1
#define MX6UL_PAD_GPIO1_IO02__SRC_ANY_PU_RESET                    0x0064 0x02F0 0x0000 0x7 0x0
#define MX6UL_PAD_GPIO1_IO02__UART1_DCE_TX                        0x0064 0x02F0 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO02__UART1_DTE_RX                        0x0064 0x02F0 0x0624 0x8 0x0
#define MX6UL_PAD_GPIO1_IO03__I2C1_SDA                            0x0068 0x02F4 0x05A8 0x0 0x1
#define MX6UL_PAD_GPIO1_IO03__GPT1_COMPARE3                       0x0068 0x02F4 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO03__USB_OTG2_OC                         0x0068 0x02F4 0x0660 0x2 0x0
#define MX6UL_PAD_GPIO1_IO03__REF_CLK_32K                         0x0068 0x02F4 0x0000 0x3 0x0
#define MX6UL_PAD_GPIO1_IO03__USDHC1_CD_B                         0x0068 0x02F4 0x0668 0x4 0x0
#define MX6UL_PAD_GPIO1_IO03__GPIO1_IO03                          0x0068 0x02F4 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO03__CCM_DI0_EXT_CLK                     0x0068 0x02F4 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO03__SRC_TESTER_ACK                      0x0068 0x02F4 0x0000 0x7 0x0
#define MX6UL_PAD_GPIO1_IO03__UART1_DCE_RX                        0x0068 0x02F4 0x0624 0x8 0x1
#define MX6UL_PAD_GPIO1_IO03__UART1_DTE_TX                        0x0068 0x02F4 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO04__ENET1_REF_CLK1                      0x006C 0x02F8 0x0574 0x0 0x1
#define MX6UL_PAD_GPIO1_IO04__PWM3_OUT                            0x006C 0x02F8 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO04__USB_OTG1_PWR                        0x006C 0x02F8 0x0000 0x2 0x0
#define MX6UL_PAD_GPIO1_IO04__REF_CLK_24M                         0x006C 0x02F8 0x0000 0x3 0x0
#define MX6UL_PAD_GPIO1_IO04__USDHC1_RESET_B                      0x006C 0x02F8 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO04__GPIO1_IO04                          0x006C 0x02F8 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO04__ENET2_1588_EVENT0_IN                0x006C 0x02F8 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO04__UART5_DCE_TX                        0x006C 0x02F8 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO04__UART5_DTE_RX                        0x006C 0x02F8 0x0644 0x8 0x2
#define MX6UL_PAD_GPIO1_IO05__ENET2_REF_CLK2                      0x0070 0x02FC 0x057C 0x0 0x1
#define MX6UL_PAD_GPIO1_IO05__PWM4_OUT                            0x0070 0x02FC 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO05__ANATOP_OTG2_ID                      0x0070 0x02FC 0x04BC 0x2 0x0
#define MX6UL_PAD_GPIO1_IO05__CSI_FIELD                           0x0070 0x02FC 0x0530 0x3 0x0
#define MX6UL_PAD_GPIO1_IO05__USDHC1_VSELECT                      0x0070 0x02FC 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO05__GPIO1_IO05                          0x0070 0x02FC 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO05__ENET2_1588_EVENT0_OUT               0x0070 0x02FC 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO05__UART5_DCE_RX                        0x0070 0x02FC 0x0644 0x8 0x3
#define MX6UL_PAD_GPIO1_IO05__UART5_DTE_TX                        0x0070 0x02FC 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO06__ENET1_MDIO                          0x0074 0x0300 0x0578 0x0 0x0
#define MX6UL_PAD_GPIO1_IO06__ENET2_MDIO                          0x0074 0x0300 0x0580 0x1 0x0
#define MX6UL_PAD_GPIO1_IO06__USB_OTG_PWR_WAKE                    0x0074 0x0300 0x0000 0x2 0x0
#define MX6UL_PAD_GPIO1_IO06__CSI_MCLK                            0x0074 0x0300 0x0000 0x3 0x0
#define MX6UL_PAD_GPIO1_IO06__USDHC2_WP                           0x0074 0x0300 0x069C 0x4 0x0
#define MX6UL_PAD_GPIO1_IO06__GPIO1_IO06                          0x0074 0x0300 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO06__CCM_WAIT                            0x0074 0x0300 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO06__CCM_REF_EN_B                        0x0074 0x0300 0x0000 0x7 0x0
#define MX6UL_PAD_GPIO1_IO06__UART1_DCE_CTS                       0x0074 0x0300 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO06__UART1_DTE_RTS                       0x0074 0x0300 0x0620 0x8 0x0
#define MX6UL_PAD_GPIO1_IO07__ENET1_MDC                           0x0078 0x0304 0x0000 0x0 0x0
#define MX6UL_PAD_GPIO1_IO07__ENET2_MDC                           0x0078 0x0304 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO07__USB_OTG_HOST_MODE                   0x0078 0x0304 0x0000 0x2 0x0
#define MX6UL_PAD_GPIO1_IO07__CSI_PIXCLK                          0x0078 0x0304 0x0528 0x3 0x0
#define MX6UL_PAD_GPIO1_IO07__USDHC2_CD_B                         0x0078 0x0304 0x0674 0x4 0x1
#define MX6UL_PAD_GPIO1_IO07__GPIO1_IO07                          0x0078 0x0304 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO07__CCM_STOP                            0x0078 0x0304 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO07__UART1_DCE_RTS                       0x0078 0x0304 0x0620 0x8 0x1
#define MX6UL_PAD_GPIO1_IO07__UART1_DTE_CTS                       0x0078 0x0304 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO08__PWM1_OUT                            0x007C 0x0308 0x0000 0x0 0x0
#define MX6UL_PAD_GPIO1_IO08__WDOG1_WDOG_B                        0x007C 0x0308 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO08__SPDIF_OUT                           0x007C 0x0308 0x0000 0x2 0x0
#define MX6UL_PAD_GPIO1_IO08__CSI_VSYNC                           0x007C 0x0308 0x052C 0x3 0x1
#define MX6UL_PAD_GPIO1_IO08__USDHC2_VSELECT                      0x007C 0x0308 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO08__GPIO1_IO08                          0x007C 0x0308 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO08__CCM_PMIC_RDY                        0x007C 0x0308 0x04C0 0x6 0x1
#define MX6UL_PAD_GPIO1_IO08__UART5_DCE_RTS                       0x007C 0x0308 0x0640 0x8 0x1
#define MX6UL_PAD_GPIO1_IO08__UART5_DTE_CTS                       0x007C 0x0308 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO09__PWM2_OUT                            0x0080 0x030C 0x0000 0x0 0x0
#define MX6UL_PAD_GPIO1_IO09__WDOG1_WDOG_ANY                      0x0080 0x030C 0x0000 0x1 0x0
#define MX6UL_PAD_GPIO1_IO09__SPDIF_IN                            0x0080 0x030C 0x0618 0x2 0x0
#define MX6UL_PAD_GPIO1_IO09__CSI_HSYNC                           0x0080 0x030C 0x0524 0x3 0x1
#define MX6UL_PAD_GPIO1_IO09__USDHC2_RESET_B                      0x0080 0x030C 0x0000 0x4 0x0
#define MX6UL_PAD_GPIO1_IO09__GPIO1_IO09                          0x0080 0x030C 0x0000 0x5 0x0
#define MX6UL_PAD_GPIO1_IO09__USDHC1_RESET_B                      0x0080 0x030C 0x0000 0x6 0x0
#define MX6UL_PAD_GPIO1_IO09__UART5_DCE_CTS                       0x0080 0x030C 0x0000 0x8 0x0
#define MX6UL_PAD_GPIO1_IO09__UART5_DTE_RTS                       0x0080 0x030C 0x0640 0x8 0x2
#define MX6UL_PAD_UART1_TX_DATA__UART1_DCE_TX                     0x0084 0x0310 0x0000 0x0 0x0
#define MX6UL_PAD_UART1_TX_DATA__UART1_DTE_RX                     0x0084 0x0310 0x0624 0x0 0x2
#define MX6UL_PAD_UART1_TX_DATA__ENET1_RDATA02                    0x0084 0x0310 0x0000 0x1 0x0
#define MX6UL_PAD_UART1_TX_DATA__I2C3_SCL                         0x0084 0x0310 0x05B4 0x2 0x0
#define MX6UL_PAD_UART1_TX_DATA__CSI_DATA02                       0x0084 0x0310 0x04C4 0x3 0x1
#define MX6UL_PAD_UART1_TX_DATA__GPT1_COMPARE1                    0x0084 0x0310 0x0000 0x4 0x0
#define MX6UL_PAD_UART1_TX_DATA__GPIO1_IO16                       0x0084 0x0310 0x0000 0x5 0x0
#define MX6UL_PAD_UART1_TX_DATA__SPDIF_OUT                        0x0084 0x0310 0x0000 0x8 0x0
#define MX6UL_PAD_UART1_RX_DATA__UART1_DCE_RX                     0x0088 0x0314 0x0624 0x0 0x3
#define MX6UL_PAD_UART1_RX_DATA__UART1_DTE_TX                     0x0088 0x0314 0x0000 0x0 0x0
#define MX6UL_PAD_UART1_RX_DATA__ENET1_RDATA03                    0x0088 0x0314 0x0000 0x1 0x0
#define MX6UL_PAD_UART1_RX_DATA__I2C3_SDA                         0x0088 0x0314 0x05B8 0x2 0x0
#define MX6UL_PAD_UART1_RX_DATA__CSI_DATA03                       0x0088 0x0314 0x04C8 0x3 0x1
#define MX6UL_PAD_UART1_RX_DATA__GPT1_CLK                         0x0088 0x0314 0x0594 0x4 0x0
#define MX6UL_PAD_UART1_RX_DATA__GPIO1_IO17                       0x0088 0x0314 0x0000 0x5 0x0
#define MX6UL_PAD_UART1_RX_DATA__SPDIF_IN                         0x0088 0x0314 0x0618 0x8 0x1
#define MX6UL_PAD_UART1_CTS_B__UART1_DCE_CTS                      0x008C 0x0318 0x0000 0x0 0x0
#define MX6UL_PAD_UART1_CTS_B__UART1_DTE_RTS                      0x008C 0x0318 0x0620 0x0 0x2
#define MX6UL_PAD_UART1_CTS_B__ENET1_RX_CLK                       0x008C 0x0318 0x0000 0x1 0x0
#define MX6UL_PAD_UART1_CTS_B__USDHC1_WP                          0x008C 0x0318 0x066C 0x2 0x1
#define MX6UL_PAD_UART1_CTS_B__CSI_DATA04                         0x008C 0x0318 0x04D8 0x3 0x0
#define MX6UL_PAD_UART1_CTS_B__ENET2_1588_EVENT1_IN               0x008C 0x0318 0x0000 0x4 0x0
#define MX6UL_PAD_UART1_CTS_B__GPIO1_IO18                         0x008C 0x0318 0x0000 0x5 0x0
#define MX6UL_PAD_UART1_CTS_B__USDHC2_WP                          0x008C 0x0318 0x069C 0x8 0x1
#define MX6UL_PAD_UART1_RTS_B__UART1_DCE_RTS                      0x0090 0x031C 0x0620 0x0 0x3
#define MX6UL_PAD_UART1_RTS_B__UART1_DTE_CTS                      0x0090 0x031C 0x0000 0x0 0x0
#define MX6UL_PAD_UART1_RTS_B__ENET1_TX_ER                        0x0090 0x031C 0x0000 0x1 0x0
#define MX6UL_PAD_UART1_RTS_B__USDHC1_CD_B                        0x0090 0x031C 0x0668 0x2 0x1
#define MX6UL_PAD_UART1_RTS_B__CSI_DATA05                         0x0090 0x031C 0x04CC 0x3 0x1
#define MX6UL_PAD_UART1_RTS_B__ENET2_1588_EVENT1_OUT              0x0090 0x031C 0x0000 0x4 0x0
#define MX6UL_PAD_UART1_RTS_B__GPIO1_IO19                         0x0090 0x031C 0x0000 0x5 0x0
#define MX6UL_PAD_UART1_RTS_B__USDHC2_CD_B                        0x0090 0x031C 0x0674 0x8 0x2
#define MX6UL_PAD_UART2_TX_DATA__UART2_DCE_TX                     0x0094 0x0320 0x0000 0x0 0x0
#define MX6UL_PAD_UART2_TX_DATA__UART2_DTE_RX                     0x0094 0x0320 0x062C 0x0 0x0
#define MX6UL_PAD_UART2_TX_DATA__ENET1_TDATA02                    0x0094 0x0320 0x0000 0x1 0x0
#define MX6UL_PAD_UART2_TX_DATA__I2C4_SCL                         0x0094 0x0320 0x05BC 0x2 0x0
#define MX6UL_PAD_UART2_TX_DATA__CSI_DATA06                       0x0094 0x0320 0x04DC 0x3 0x0
#define MX6UL_PAD_UART2_TX_DATA__GPT1_CAPTURE1                    0x0094 0x0320 0x058C 0x4 0x1
#define MX6UL_PAD_UART2_TX_DATA__GPIO1_IO20                       0x0094 0x0320 0x0000 0x5 0x0
#define MX6UL_PAD_UART2_TX_DATA__ECSPI3_SS0                       0x0094 0x0320 0x0560 0x8 0x0
#define MX6UL_PAD_UART2_RX_DATA__UART2_DCE_RX                     0x0098 0x0324 0x062C 0x0 0x1
#define MX6UL_PAD_UART2_RX_DATA__UART2_DTE_TX                     0x0098 0x0324 0x0000 0x0 0x0
#define MX6UL_PAD_UART2_RX_DATA__ENET1_TDATA03                    0x0098 0x0324 0x0000 0x1 0x0
#define MX6UL_PAD_UART2_RX_DATA__I2C4_SDA                         0x0098 0x0324 0x05C0 0x2 0x0
#define MX6UL_PAD_UART2_RX_DATA__CSI_DATA07                       0x0098 0x0324 0x04E0 0x3 0x0
#define MX6UL_PAD_UART2_RX_DATA__GPT1_CAPTURE2                    0x0098 0x0324 0x0590 0x4 0x0
#define MX6UL_PAD_UART2_RX_DATA__GPIO1_IO21                       0x0098 0x0324 0x0000 0x5 0x0
#define MX6UL_PAD_UART2_RX_DATA__SJC_DONE                         0x0098 0x0324 0x0000 0x7 0x0
#define MX6UL_PAD_UART2_RX_DATA__ECSPI3_SCLK                      0x0098 0x0324 0x0554 0x8 0x0
#define MX6UL_PAD_UART2_CTS_B__UART2_DCE_CTS                      0x009C 0x0328 0x0000 0x0 0x0
#define MX6UL_PAD_UART2_CTS_B__UART2_DTE_RTS                      0x009C 0x0328 0x0628 0x0 0x0
#define MX6UL_PAD_UART2_CTS_B__ENET1_CRS                          0x009C 0x0328 0x0000 0x1 0x0
#define MX6UL_PAD_UART2_CTS_B__FLEXCAN2_TX                        0x009C 0x0328 0x0000 0x2 0x0
#define MX6UL_PAD_UART2_CTS_B__CSI_DATA08                         0x009C 0x0328 0x04E4 0x3 0x0
#define MX6UL_PAD_UART2_CTS_B__GPT1_COMPARE2                      0x009C 0x0328 0x0000 0x4 0x0
#define MX6UL_PAD_UART2_CTS_B__GPIO1_IO22                         0x009C 0x0328 0x0000 0x5 0x0
#define MX6UL_PAD_UART2_CTS_B__SJC_DE_B                           0x009C 0x0328 0x0000 0x7 0x0
#define MX6UL_PAD_UART2_CTS_B__ECSPI3_MOSI                        0x009C 0x0328 0x055C 0x8 0x0
#define MX6UL_PAD_UART2_RTS_B__UART2_DCE_RTS                      0x00A0 0x032C 0x0628 0x0 0x1
#define MX6UL_PAD_UART2_RTS_B__UART2_DTE_CTS                      0x00A0 0x032C 0x0000 0x0 0x0
#define MX6UL_PAD_UART2_RTS_B__ENET1_COL                          0x00A0 0x032C 0x0000 0x1 0x0
#define MX6UL_PAD_UART2_RTS_B__FLEXCAN2_RX                        0x00A0 0x032C 0x0588 0x2 0x0
#define MX6UL_PAD_UART2_RTS_B__CSI_DATA09                         0x00A0 0x032C 0x04E8 0x3 0x0
#define MX6UL_PAD_UART2_RTS_B__GPT1_COMPARE3                      0x00A0 0x032C 0x0000 0x4 0x0
#define MX6UL_PAD_UART2_RTS_B__GPIO1_IO23                         0x00A0 0x032C 0x0000 0x5 0x0
#define MX6UL_PAD_UART2_RTS_B__SJC_FAIL                           0x00A0 0x032C 0x0000 0x7 0x0
#define MX6UL_PAD_UART2_RTS_B__ECSPI3_MISO                        0x00A0 0x032C 0x0558 0x8 0x0
#define MX6UL_PAD_UART3_TX_DATA__UART3_DCE_TX                     0x00A4 0x0330 0x0000 0x0 0x0
#define MX6UL_PAD_UART3_TX_DATA__UART3_DTE_RX                     0x00A4 0x0330 0x0634 0x0 0x0
#define MX6UL_PAD_UART3_TX_DATA__ENET2_RDATA02                    0x00A4 0x0330 0x0000 0x1 0x0
#define MX6UL_PAD_UART3_TX_DATA__SIM1_PORT0_PD                    0x00A4 0x0330 0x0000 0x2 0x0
#define MX6UL_PAD_UART3_TX_DATA__CSI_DATA01                       0x00A4 0x0330 0x04D4 0x3 0x0
#define MX6UL_PAD_UART3_TX_DATA__UART2_DCE_CTS                    0x00A4 0x0330 0x0000 0x4 0x0
#define MX6UL_PAD_UART3_TX_DATA__UART2_DTE_RTS                    0x00A4 0x0330 0x0628 0x4 0x2
#define MX6UL_PAD_UART3_TX_DATA__GPIO1_IO24                       0x00A4 0x0330 0x0000 0x5 0x0
#define MX6UL_PAD_UART3_TX_DATA__SJC_JTAG_ACT                     0x00A4 0x0330 0x0000 0x7 0x0
#define MX6UL_PAD_UART3_TX_DATA__ANATOP_OTG1_ID                   0x00A4 0x0330 0x04B8 0x8 0x1
#define MX6UL_PAD_UART3_RX_DATA__UART3_DCE_RX                     0x00A8 0x0334 0x0634 0x0 0x1
#define MX6UL_PAD_UART3_RX_DATA__UART3_DTE_TX                     0x00A8 0x0334 0x0000 0x0 0x0
#define MX6UL_PAD_UART3_RX_DATA__ENET2_RDATA03                    0x00A8 0x0334 0x0000 0x1 0x0
#define MX6UL_PAD_UART3_RX_DATA__SIM2_PORT0_PD                    0x00A8 0x0334 0x0000 0x2 0x0
#define MX6UL_PAD_UART3_RX_DATA__CSI_DATA00                       0x00A8 0x0334 0x04D0 0x3 0x0
#define MX6UL_PAD_UART3_RX_DATA__UART2_DCE_RTS                    0x00A8 0x0334 0x0628 0x4 0x3
#define MX6UL_PAD_UART3_RX_DATA__UART2_DTE_CTS                    0x00A8 0x0334 0x0000 0x4 0x0
#define MX6UL_PAD_UART3_RX_DATA__GPIO1_IO25                       0x00A8 0x0334 0x0000 0x5 0x0
#define MX6UL_PAD_UART3_RX_DATA__EPIT1_OUT                        0x00A8 0x0334 0x0000 0x8 0x0
#define MX6UL_PAD_UART3_CTS_B__UART3_DCE_CTS                      0x00AC 0x0338 0x0000 0x0 0x0
#define MX6UL_PAD_UART3_CTS_B__UART3_DTE_RTS                      0x00AC 0x0338 0x0630 0x0 0x0
#define MX6UL_PAD_UART3_CTS_B__ENET2_RX_CLK                       0x00AC 0x0338 0x0000 0x1 0x0
#define MX6UL_PAD_UART3_CTS_B__FLEXCAN1_TX                        0x00AC 0x0338 0x0000 0x2 0x0
#define MX6UL_PAD_UART3_CTS_B__CSI_DATA10                         0x00AC 0x0338 0x04EC 0x3 0x0
#define MX6UL_PAD_UART3_CTS_B__ENET1_1588_EVENT1_IN               0x00AC 0x0338 0x0000 0x4 0x0
#define MX6UL_PAD_UART3_CTS_B__GPIO1_IO26                         0x00AC 0x0338 0x0000 0x5 0x0
#define MX6UL_PAD_UART3_CTS_B__EPIT2_OUT                          0x00AC 0x0338 0x0000 0x8 0x0
#define MX6UL_PAD_UART3_RTS_B__UART3_DCE_RTS                      0x00B0 0x033C 0x0630 0x0 0x1
#define MX6UL_PAD_UART3_RTS_B__UART3_DTE_CTS                      0x00B0 0x033C 0x0000 0x0 0x0
#define MX6UL_PAD_UART3_RTS_B__ENET2_TX_ER                        0x00B0 0x033C 0x0000 0x1 0x0
#define MX6UL_PAD_UART3_RTS_B__FLEXCAN1_RX                        0x00B0 0x033C 0x0584 0x2 0x0
#define MX6UL_PAD_UART3_RTS_B__CSI_DATA11                         0x00B0 0x033C 0x04F0 0x3 0x0
#define MX6UL_PAD_UART3_RTS_B__ENET1_1588_EVENT1_OUT              0x00B0 0x033C 0x0000 0x4 0x0
#define MX6UL_PAD_UART3_RTS_B__GPIO1_IO27                         0x00B0 0x033C 0x0000 0x5 0x0
#define MX6UL_PAD_UART3_RTS_B__WDOG1_WDOG_B                       0x00B0 0x033C 0x0000 0x8 0x0
#define MX6UL_PAD_UART4_TX_DATA__UART4_DCE_TX                     0x00B4 0x0340 0x0000 0x0 0x0
#define MX6UL_PAD_UART4_TX_DATA__UART4_DTE_RX                     0x00B4 0x0340 0x063C 0x0 0x0
#define MX6UL_PAD_UART4_TX_DATA__ENET2_TDATA02                    0x00B4 0x0340 0x0000 0x1 0x0
#define MX6UL_PAD_UART4_TX_DATA__I2C1_SCL                         0x00B4 0x0340 0x05A4 0x2 0x1
#define MX6UL_PAD_UART4_TX_DATA__CSI_DATA12                       0x00B4 0x0340 0x04F4 0x3 0x0
#define MX6UL_PAD_UART4_TX_DATA__CSU_CSU_ALARM_AUT02              0x00B4 0x0340 0x0000 0x4 0x0
#define MX6UL_PAD_UART4_TX_DATA__GPIO1_IO28                       0x00B4 0x0340 0x0000 0x5 0x0
#define MX6UL_PAD_UART4_TX_DATA__ECSPI2_SCLK                      0x00B4 0x0340 0x0544 0x8 0x1
#define MX6UL_PAD_UART4_RX_DATA__UART4_DCE_RX                     0x00B8 0x0344 0x063C 0x0 0x1
#define MX6UL_PAD_UART4_RX_DATA__UART4_DTE_TX                     0x00B8 0x0344 0x0000 0x0 0x0
#define MX6UL_PAD_UART4_RX_DATA__ENET2_TDATA03                    0x00B8 0x0344 0x0000 0x1 0x0
#define MX6UL_PAD_UART4_RX_DATA__I2C1_SDA                         0x00B8 0x0344 0x05A8 0x2 0x2
#define MX6UL_PAD_UART4_RX_DATA__CSI_DATA13                       0x00B8 0x0344 0x04F8 0x3 0x0
#define MX6UL_PAD_UART4_RX_DATA__CSU_CSU_ALARM_AUT01              0x00B8 0x0344 0x0000 0x4 0x0
#define MX6UL_PAD_UART4_RX_DATA__GPIO1_IO29                       0x00B8 0x0344 0x0000 0x5 0x0
#define MX6UL_PAD_UART4_RX_DATA__ECSPI2_SS0                       0x00B8 0x0344 0x0550 0x8 0x1
#define MX6UL_PAD_UART5_TX_DATA__GPIO1_IO30                       0x00BC 0x0348 0x0000 0x5 0x0
#define MX6UL_PAD_UART5_TX_DATA__ECSPI2_MOSI                      0x00BC 0x0348 0x054C 0x8 0x0
#define MX6UL_PAD_UART5_TX_DATA__UART5_DCE_TX                     0x00BC 0x0348 0x0000 0x0 0x0
#define MX6UL_PAD_UART5_TX_DATA__UART5_DTE_RX                     0x00BC 0x0348 0x0644 0x0 0x4
#define MX6UL_PAD_UART5_TX_DATA__ENET2_CRS                        0x00BC 0x0348 0x0000 0x1 0x0
#define MX6UL_PAD_UART5_TX_DATA__I2C2_SCL                         0x00BC 0x0348 0x05AC 0x2 0x2
#define MX6UL_PAD_UART5_TX_DATA__CSI_DATA14                       0x00BC 0x0348 0x04FC 0x3 0x0
#define MX6UL_PAD_UART5_TX_DATA__CSU_CSU_ALARM_AUT00              0x00BC 0x0348 0x0000 0x4 0x0
#define MX6UL_PAD_UART5_RX_DATA__UART5_DCE_RX                     0x00C0 0x034C 0x0644 0x0 0x5
#define MX6UL_PAD_UART5_RX_DATA__UART5_DTE_TX                     0x00C0 0x034C 0x0000 0x0 0x0
#define MX6UL_PAD_UART5_RX_DATA__ENET2_COL                        0x00C0 0x034C 0x0000 0x1 0x0
#define MX6UL_PAD_UART5_RX_DATA__I2C2_SDA                         0x00C0 0x034C 0x05B0 0x2 0x2
#define MX6UL_PAD_UART5_RX_DATA__CSI_DATA15                       0x00C0 0x034C 0x0500 0x3 0x0
#define MX6UL_PAD_UART5_RX_DATA__CSU_CSU_INT_DEB                  0x00C0 0x034C 0x0000 0x4 0x0
#define MX6UL_PAD_UART5_RX_DATA__GPIO1_IO31                       0x00C0 0x034C 0x0000 0x5 0x0
#define MX6UL_PAD_UART5_RX_DATA__ECSPI2_MISO                      0x00C0 0x034C 0x0548 0x8 0x1
#define MX6UL_PAD_ENET1_RX_DATA0__ENET1_RDATA00                   0x00C4 0x0350 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__UART4_DCE_RTS                   0x00C4 0x0350 0x0638 0x1 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__UART4_DTE_CTS                   0x00C4 0x0350 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__PWM1_OUT                        0x00C4 0x0350 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__CSI_DATA16                      0x00C4 0x0350 0x0504 0x3 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__FLEXCAN1_TX                     0x00C4 0x0350 0x0000 0x4 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__GPIO2_IO00                      0x00C4 0x0350 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__KPP_ROW00                       0x00C4 0x0350 0x05D0 0x6 0x0
#define MX6UL_PAD_ENET1_RX_DATA0__USDHC1_LCTL                     0x00C4 0x0350 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__ENET1_RDATA01                   0x00C8 0x0354 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__UART4_DCE_CTS                   0x00C8 0x0354 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__UART4_DTE_RTS                   0x00C8 0x0354 0x0638 0x1 0x1
#define MX6UL_PAD_ENET1_RX_DATA1__PWM2_OUT                        0x00C8 0x0354 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__CSI_DATA17                      0x00C8 0x0354 0x0508 0x3 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__FLEXCAN1_RX                     0x00C8 0x0354 0x0584 0x4 0x1
#define MX6UL_PAD_ENET1_RX_DATA1__GPIO2_IO01                      0x00C8 0x0354 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__KPP_COL00                       0x00C8 0x0354 0x05C4 0x6 0x0
#define MX6UL_PAD_ENET1_RX_DATA1__USDHC2_LCTL                     0x00C8 0x0354 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_RX_EN__ENET1_RX_EN                        0x00CC 0x0358 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_RX_EN__UART5_DCE_RTS                      0x00CC 0x0358 0x0640 0x1 0x3
#define MX6UL_PAD_ENET1_RX_EN__UART5_DTE_CTS                      0x00CC 0x0358 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_RX_EN__REF_CLK_32K                        0x00CC 0x0358 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_RX_EN__CSI_DATA18                         0x00CC 0x0358 0x050C 0x3 0x0
#define MX6UL_PAD_ENET1_RX_EN__FLEXCAN2_TX                        0x00CC 0x0358 0x0000 0x4 0x0
#define MX6UL_PAD_ENET1_RX_EN__GPIO2_IO02                         0x00CC 0x0358 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_RX_EN__KPP_ROW01                          0x00CC 0x0358 0x05D4 0x6 0x0
#define MX6UL_PAD_ENET1_RX_EN__USDHC1_VSELECT                     0x00CC 0x0358 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__ENET1_TDATA00                   0x00D0 0x035C 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__UART5_DCE_CTS                   0x00D0 0x035C 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__UART5_DTE_RTS                   0x00D0 0x035C 0x0640 0x1 0x4
#define MX6UL_PAD_ENET1_TX_DATA0__REF_CLK_24M                     0x00D0 0x035C 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__CSI_DATA19                      0x00D0 0x035C 0x0510 0x3 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__FLEXCAN2_RX                     0x00D0 0x035C 0x0588 0x4 0x1
#define MX6UL_PAD_ENET1_TX_DATA0__GPIO2_IO03                      0x00D0 0x035C 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__KPP_COL01                       0x00D0 0x035C 0x05C8 0x6 0x0
#define MX6UL_PAD_ENET1_TX_DATA0__USDHC2_VSELECT                  0x00D0 0x035C 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__ENET1_TDATA01                   0x00D4 0x0360 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__UART6_DCE_CTS                   0x00D4 0x0360 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__UART6_DTE_RTS                   0x00D4 0x0360 0x0648 0x1 0x2
#define MX6UL_PAD_ENET1_TX_DATA1__PWM5_OUT                        0x00D4 0x0360 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__CSI_DATA20                      0x00D4 0x0360 0x0514 0x3 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__ENET2_MDIO                      0x00D4 0x0360 0x0580 0x4 0x1
#define MX6UL_PAD_ENET1_TX_DATA1__GPIO2_IO04                      0x00D4 0x0360 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__KPP_ROW02                       0x00D4 0x0360 0x05D8 0x6 0x0
#define MX6UL_PAD_ENET1_TX_DATA1__WDOG1_WDOG_RST_B_DEB            0x00D4 0x0360 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_TX_EN__ENET1_TX_EN                        0x00D8 0x0364 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_TX_EN__UART6_DCE_RTS                      0x00D8 0x0364 0x0648 0x1 0x3
#define MX6UL_PAD_ENET1_TX_EN__UART6_DTE_CTS                      0x00D8 0x0364 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_TX_EN__PWM6_OUT                           0x00D8 0x0364 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_TX_EN__CSI_DATA21                         0x00D8 0x0364 0x0518 0x3 0x0
#define MX6UL_PAD_ENET1_TX_EN__ENET2_MDC                          0x00D8 0x0364 0x0000 0x4 0x0
#define MX6UL_PAD_ENET1_TX_EN__GPIO2_IO05                         0x00D8 0x0364 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_TX_EN__KPP_COL02                          0x00D8 0x0364 0x05CC 0x6 0x0
#define MX6UL_PAD_ENET1_TX_EN__WDOG2_WDOG_RST_B_DEB               0x00D8 0x0364 0x0000 0x8 0x0
#define MX6UL_PAD_ENET1_TX_CLK__ENET1_TX_CLK                      0x00DC 0x0368 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_TX_CLK__UART7_DCE_CTS                     0x00DC 0x0368 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_TX_CLK__UART7_DTE_RTS                     0x00DC 0x0368 0x0650 0x1 0x0
#define MX6UL_PAD_ENET1_TX_CLK__PWM7_OUT                          0x00DC 0x0368 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_TX_CLK__CSI_DATA22                        0x00DC 0x0368 0x051C 0x3 0x0
#define MX6UL_PAD_ENET1_TX_CLK__ENET1_REF_CLK1                    0x00DC 0x0368 0x0574 0x4 0x2
#define MX6UL_PAD_ENET1_TX_CLK__GPIO2_IO06                        0x00DC 0x0368 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_TX_CLK__KPP_ROW03                         0x00DC 0x0368 0x0000 0x6 0x0
#define MX6UL_PAD_ENET1_TX_CLK__GPT1_CLK                          0x00DC 0x0368 0x0594 0x8 0x1
#define MX6UL_PAD_ENET1_RX_ER__ENET1_RX_ER                        0x00E0 0x036C 0x0000 0x0 0x0
#define MX6UL_PAD_ENET1_RX_ER__UART7_DCE_RTS                      0x00E0 0x036C 0x0650 0x1 0x1
#define MX6UL_PAD_ENET1_RX_ER__UART7_DTE_CTS                      0x00E0 0x036C 0x0000 0x1 0x0
#define MX6UL_PAD_ENET1_RX_ER__PWM8_OUT                           0x00E0 0x036C 0x0000 0x2 0x0
#define MX6UL_PAD_ENET1_RX_ER__CSI_DATA23                         0x00E0 0x036C 0x0520 0x3 0x0
#define MX6UL_PAD_ENET1_RX_ER__EIM_CRE                            0x00E0 0x036C 0x0000 0x4 0x0
#define MX6UL_PAD_ENET1_RX_ER__GPIO2_IO07                         0x00E0 0x036C 0x0000 0x5 0x0
#define MX6UL_PAD_ENET1_RX_ER__KPP_COL03                          0x00E0 0x036C 0x0000 0x6 0x0
#define MX6UL_PAD_ENET1_RX_ER__GPT1_CAPTURE2                      0x00E0 0x036C 0x0590 0x8 0x1
#define MX6UL_PAD_ENET2_RX_DATA0__ENET2_RDATA00                   0x00E4 0x0370 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_RX_DATA0__UART6_DCE_TX                    0x00E4 0x0370 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_RX_DATA0__UART6_DTE_RX                    0x00E4 0x0370 0x064C 0x1 0x1
#define MX6UL_PAD_ENET2_RX_DATA0__SIM1_PORT0_TRXD                 0x00E4 0x0370 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_RX_DATA0__I2C3_SCL                        0x00E4 0x0370 0x05B4 0x3 0x1
#define MX6UL_PAD_ENET2_RX_DATA0__ENET1_MDIO                      0x00E4 0x0370 0x0578 0x4 0x1
#define MX6UL_PAD_ENET2_RX_DATA0__GPIO2_IO08                      0x00E4 0x0370 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_RX_DATA0__KPP_ROW04                       0x00E4 0x0370 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_RX_DATA0__USB_OTG1_PWR                    0x00E4 0x0370 0x0000 0x8 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__ENET2_RDATA01                   0x00E8 0x0374 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__UART6_DCE_RX                    0x00E8 0x0374 0x064C 0x1 0x2
#define MX6UL_PAD_ENET2_RX_DATA1__UART6_DTE_TX                    0x00E8 0x0374 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__SIM1_PORT0_CLK                  0x00E8 0x0374 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__I2C3_SDA                        0x00E8 0x0374 0x05B8 0x3 0x1
#define MX6UL_PAD_ENET2_RX_DATA1__ENET1_MDC                       0x00E8 0x0374 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__GPIO2_IO09                      0x00E8 0x0374 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__KPP_COL04                       0x00E8 0x0374 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_RX_DATA1__USB_OTG1_OC                     0x00E8 0x0374 0x0664 0x8 0x1
#define MX6UL_PAD_ENET2_RX_EN__ENET2_RX_EN                        0x00EC 0x0378 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_RX_EN__UART7_DCE_TX                       0x00EC 0x0378 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_RX_EN__UART7_DTE_RX                       0x00EC 0x0378 0x0654 0x1 0x0
#define MX6UL_PAD_ENET2_RX_EN__SIM1_PORT0_RST_B                   0x00EC 0x0378 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_RX_EN__I2C4_SCL                           0x00EC 0x0378 0x05BC 0x3 0x1
#define MX6UL_PAD_ENET2_RX_EN__EIM_ADDR26                         0x00EC 0x0378 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_RX_EN__GPIO2_IO10                         0x00EC 0x0378 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_RX_EN__KPP_ROW05                          0x00EC 0x0378 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_RX_EN__ENET1_REF_CLK_25M                  0x00EC 0x0378 0x0000 0x8 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__ENET2_TDATA00                   0x00F0 0x037C 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__UART7_DCE_RX                    0x00F0 0x037C 0x0654 0x1 0x1
#define MX6UL_PAD_ENET2_TX_DATA0__UART7_DTE_TX                    0x00F0 0x037C 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__SIM1_PORT0_SVEN                 0x00F0 0x037C 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__I2C4_SDA                        0x00F0 0x037C 0x05C0 0x3 0x1
#define MX6UL_PAD_ENET2_TX_DATA0__EIM_EB_B02                      0x00F0 0x037C 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__GPIO2_IO11                      0x00F0 0x037C 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__KPP_COL05                       0x00F0 0x037C 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_TX_DATA0__REF_CLK_24M                     0x00F0 0x037C 0x0000 0x8 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__ENET2_TDATA01                   0x00F4 0x0380 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__UART8_DCE_TX                    0x00F4 0x0380 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__UART8_DTE_RX                    0x00F4 0x0380 0x065C 0x1 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__SIM2_PORT0_TRXD                 0x00F4 0x0380 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__ECSPI4_SCLK                     0x00F4 0x0380 0x0564 0x3 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__EIM_EB_B03                      0x00F4 0x0380 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__GPIO2_IO12                      0x00F4 0x0380 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__KPP_ROW06                       0x00F4 0x0380 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_TX_DATA1__USB_OTG2_PWR                    0x00F4 0x0380 0x0000 0x8 0x0
#define MX6UL_PAD_ENET2_TX_EN__ENET2_TX_EN                        0x00F8 0x0384 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_TX_EN__UART8_DCE_RX                       0x00F8 0x0384 0x065C 0x1 0x1
#define MX6UL_PAD_ENET2_TX_EN__UART8_DTE_TX                       0x00F8 0x0384 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_TX_EN__SIM2_PORT0_CLK                     0x00F8 0x0384 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_TX_EN__ECSPI4_MOSI                        0x00F8 0x0384 0x056C 0x3 0x0
#define MX6UL_PAD_ENET2_TX_EN__EIM_ACLK_FREERUN                   0x00F8 0x0384 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_TX_EN__GPIO2_IO13                         0x00F8 0x0384 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_TX_EN__KPP_COL06                          0x00F8 0x0384 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_TX_EN__USB_OTG2_OC                        0x00F8 0x0384 0x0660 0x8 0x1
#define MX6UL_PAD_ENET2_TX_CLK__ENET2_TX_CLK                      0x00FC 0x0388 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_TX_CLK__UART8_DCE_CTS                     0x00FC 0x0388 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_TX_CLK__UART8_DTE_RTS                     0x00FC 0x0388 0x0658 0x1 0x0
#define MX6UL_PAD_ENET2_TX_CLK__SIM2_PORT0_RST_B                  0x00FC 0x0388 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_TX_CLK__ECSPI4_MISO                       0x00FC 0x0388 0x0568 0x3 0x0
#define MX6UL_PAD_ENET2_TX_CLK__ENET2_REF_CLK2                    0x00FC 0x0388 0x057C 0x4 0x2
#define MX6UL_PAD_ENET2_TX_CLK__GPIO2_IO14                        0x00FC 0x0388 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_TX_CLK__KPP_ROW07                         0x00FC 0x0388 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_TX_CLK__ANATOP_OTG2_ID                    0x00FC 0x0388 0x04BC 0x8 0x1
#define MX6UL_PAD_ENET2_RX_ER__ENET2_RX_ER                        0x0100 0x038C 0x0000 0x0 0x0
#define MX6UL_PAD_ENET2_RX_ER__UART8_DCE_RTS                      0x0100 0x038C 0x0658 0x1 0x1
#define MX6UL_PAD_ENET2_RX_ER__UART8_DTE_CTS                      0x0100 0x038C 0x0000 0x1 0x0
#define MX6UL_PAD_ENET2_RX_ER__SIM2_PORT0_SVEN                    0x0100 0x038C 0x0000 0x2 0x0
#define MX6UL_PAD_ENET2_RX_ER__ECSPI4_SS0                         0x0100 0x038C 0x0570 0x3 0x0
#define MX6UL_PAD_ENET2_RX_ER__EIM_ADDR25                         0x0100 0x038C 0x0000 0x4 0x0
#define MX6UL_PAD_ENET2_RX_ER__GPIO2_IO15                         0x0100 0x038C 0x0000 0x5 0x0
#define MX6UL_PAD_ENET2_RX_ER__KPP_COL07                          0x0100 0x038C 0x0000 0x6 0x0
#define MX6UL_PAD_ENET2_RX_ER__WDOG1_WDOG_ANY                     0x0100 0x038C 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_CLK__LCDIF_CLK                              0x0104 0x0390 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_CLK__LCDIF_WR_RWN                           0x0104 0x0390 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_CLK__UART4_DCE_TX                           0x0104 0x0390 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_CLK__UART4_DTE_RX                           0x0104 0x0390 0x063C 0x2 0x2
#define MX6UL_PAD_LCD_CLK__SAI3_MCLK                              0x0104 0x0390 0x0600 0x3 0x0
#define MX6UL_PAD_LCD_CLK__EIM_CS2_B                              0x0104 0x0390 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_CLK__GPIO3_IO00                             0x0104 0x0390 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_CLK__WDOG1_WDOG_RST_B_DEB                   0x0104 0x0390 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_ENABLE__LCDIF_ENABLE                        0x0108 0x0394 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_ENABLE__LCDIF_RD_E                          0x0108 0x0394 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_ENABLE__UART4_DCE_RX                        0x0108 0x0394 0x063C 0x2 0x3
#define MX6UL_PAD_LCD_ENABLE__UART4_DTE_TX                        0x0108 0x0394 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_ENABLE__SAI3_TX_SYNC                        0x0108 0x0394 0x060C 0x3 0x0
#define MX6UL_PAD_LCD_ENABLE__EIM_CS3_B                           0x0108 0x0394 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_ENABLE__GPIO3_IO01                          0x0108 0x0394 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_ENABLE__ECSPI2_RDY                          0x0108 0x0394 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_HSYNC__LCDIF_HSYNC                          0x010C 0x0398 0x05DC 0x0 0x0
#define MX6UL_PAD_LCD_HSYNC__LCDIF_RS                             0x010C 0x0398 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_HSYNC__UART4_DCE_CTS                        0x010C 0x0398 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_HSYNC__UART4_DTE_RTS                        0x010C 0x0398 0x0638 0x2 0x2
#define MX6UL_PAD_LCD_HSYNC__SAI3_TX_BCLK                         0x010C 0x0398 0x0608 0x3 0x0
#define MX6UL_PAD_LCD_HSYNC__WDOG3_WDOG_RST_B_DEB                 0x010C 0x0398 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_HSYNC__GPIO3_IO02                           0x010C 0x0398 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_HSYNC__ECSPI2_SS1                           0x010C 0x0398 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_VSYNC__LCDIF_VSYNC                          0x0110 0x039C 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_VSYNC__LCDIF_BUSY                           0x0110 0x039C 0x05DC 0x1 0x1
#define MX6UL_PAD_LCD_VSYNC__UART4_DCE_RTS                        0x0110 0x039C 0x0638 0x2 0x3
#define MX6UL_PAD_LCD_VSYNC__UART4_DTE_CTS                        0x0110 0x039C 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_VSYNC__SAI3_RX_DATA                         0x0110 0x039C 0x0604 0x3 0x0
#define MX6UL_PAD_LCD_VSYNC__WDOG2_WDOG_B                         0x0110 0x039C 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_VSYNC__GPIO3_IO03                           0x0110 0x039C 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_VSYNC__ECSPI2_SS2                           0x0110 0x039C 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_RESET__LCDIF_RESET                          0x0114 0x03A0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_RESET__LCDIF_CS                             0x0114 0x03A0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_RESET__CA7_MX6UL_EVENTI                     0x0114 0x03A0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_RESET__SAI3_TX_DATA                         0x0114 0x03A0 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_RESET__WDOG1_WDOG_ANY                       0x0114 0x03A0 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_RESET__GPIO3_IO04                           0x0114 0x03A0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_RESET__ECSPI2_SS3                           0x0114 0x03A0 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA00__LCDIF_DATA00                        0x0118 0x03A4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA00__PWM1_OUT                            0x0118 0x03A4 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA00__CA7_MX6UL_TRACE0                    0x0118 0x03A4 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA00__ENET1_1588_EVENT2_IN                0x0118 0x03A4 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA00__I2C3_SDA                            0x0118 0x03A4 0x05B8 0x4 0x2
#define MX6UL_PAD_LCD_DATA00__GPIO3_IO05                          0x0118 0x03A4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA00__SRC_BT_CFG00                        0x0118 0x03A4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA00__SAI1_MCLK                           0x0118 0x03A4 0x05E0 0x8 0x1
#define MX6UL_PAD_LCD_DATA01__LCDIF_DATA01                        0x011C 0x03A8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA01__PWM2_OUT                            0x011C 0x03A8 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA01__CA7_MX6UL_TRACE1                    0x011C 0x03A8 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA01__ENET1_1588_EVENT2_OUT               0x011C 0x03A8 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA01__I2C3_SCL                            0x011C 0x03A8 0x05B4 0x4 0x2
#define MX6UL_PAD_LCD_DATA01__GPIO3_IO06                          0x011C 0x03A8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA01__SRC_BT_CFG01                        0x011C 0x03A8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA01__SAI1_TX_SYNC                        0x011C 0x03A8 0x05EC 0x8 0x0
#define MX6UL_PAD_LCD_DATA02__LCDIF_DATA02                        0x0120 0x03AC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA02__PWM3_OUT                            0x0120 0x03AC 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA02__CA7_MX6UL_TRACE2                    0x0120 0x03AC 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA02__ENET1_1588_EVENT3_IN                0x0120 0x03AC 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA02__I2C4_SDA                            0x0120 0x03AC 0x05C0 0x4 0x2
#define MX6UL_PAD_LCD_DATA02__GPIO3_IO07                          0x0120 0x03AC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA02__SRC_BT_CFG02                        0x0120 0x03AC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA02__SAI1_TX_BCLK                        0x0120 0x03AC 0x05E8 0x8 0x0
#define MX6UL_PAD_LCD_DATA03__LCDIF_DATA03                        0x0124 0x03B0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA03__PWM4_OUT                            0x0124 0x03B0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA03__CA7_MX6UL_TRACE3                    0x0124 0x03B0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA03__ENET1_1588_EVENT3_OUT               0x0124 0x03B0 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA03__I2C4_SCL                            0x0124 0x03B0 0x05BC 0x4 0x2
#define MX6UL_PAD_LCD_DATA03__GPIO3_IO08                          0x0124 0x03B0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA03__SRC_BT_CFG03                        0x0124 0x03B0 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA03__SAI1_RX_DATA                        0x0124 0x03B0 0x05E4 0x8 0x0
#define MX6UL_PAD_LCD_DATA04__LCDIF_DATA04                        0x0128 0x03B4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA04__UART8_DCE_CTS                       0x0128 0x03B4 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA04__UART8_DTE_RTS                       0x0128 0x03B4 0x0658 0x1 0x2
#define MX6UL_PAD_LCD_DATA04__CA7_MX6UL_TRACE4                    0x0128 0x03B4 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA04__ENET2_1588_EVENT2_IN                0x0128 0x03B4 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA04__SPDIF_SR_CLK                        0x0128 0x03B4 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA04__GPIO3_IO09                          0x0128 0x03B4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA04__SRC_BT_CFG04                        0x0128 0x03B4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA04__SAI1_TX_DATA                        0x0128 0x03B4 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA05__LCDIF_DATA05                        0x012C 0x03B8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA05__UART8_DCE_RTS                       0x012C 0x03B8 0x0658 0x1 0x3
#define MX6UL_PAD_LCD_DATA05__UART8_DTE_CTS                       0x012C 0x03B8 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA05__CA7_MX6UL_TRACE5                    0x012C 0x03B8 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA05__ENET2_1588_EVENT2_OUT               0x012C 0x03B8 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA05__SPDIF_OUT                           0x012C 0x03B8 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA05__GPIO3_IO10                          0x012C 0x03B8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA05__SRC_BT_CFG05                        0x012C 0x03B8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA05__ECSPI1_SS1                          0x012C 0x03B8 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA06__LCDIF_DATA06                        0x0130 0x03BC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA06__UART7_DCE_CTS                       0x0130 0x03BC 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA06__UART7_DTE_RTS                       0x0130 0x03BC 0x0650 0x1 0x2
#define MX6UL_PAD_LCD_DATA06__CA7_MX6UL_TRACE6                    0x0130 0x03BC 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA06__ENET2_1588_EVENT3_IN                0x0130 0x03BC 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA06__SPDIF_LOCK                          0x0130 0x03BC 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA06__GPIO3_IO11                          0x0130 0x03BC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA06__SRC_BT_CFG06                        0x0130 0x03BC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA06__ECSPI1_SS2                          0x0130 0x03BC 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA07__LCDIF_DATA07                        0x0134 0x03C0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA07__UART7_DCE_RTS                       0x0134 0x03C0 0x0650 0x1 0x3
#define MX6UL_PAD_LCD_DATA07__UART7_DTE_CTS                       0x0134 0x03C0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA07__CA7_MX6UL_TRACE7                    0x0134 0x03C0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA07__ENET2_1588_EVENT3_OUT               0x0134 0x03C0 0x0000 0x3 0x0
#define MX6UL_PAD_LCD_DATA07__SPDIF_EXT_CLK                       0x0134 0x03C0 0x061C 0x4 0x0
#define MX6UL_PAD_LCD_DATA07__GPIO3_IO12                          0x0134 0x03C0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA07__SRC_BT_CFG07                        0x0134 0x03C0 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA07__ECSPI1_SS3                          0x0134 0x03C0 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA08__LCDIF_DATA08                        0x0138 0x03C4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA08__SPDIF_IN                            0x0138 0x03C4 0x0618 0x1 0x2
#define MX6UL_PAD_LCD_DATA08__CA7_MX6UL_TRACE8                    0x0138 0x03C4 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA08__CSI_DATA16                          0x0138 0x03C4 0x0504 0x3 0x1
#define MX6UL_PAD_LCD_DATA08__EIM_DATA00                          0x0138 0x03C4 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA08__GPIO3_IO13                          0x0138 0x03C4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA08__SRC_BT_CFG08                        0x0138 0x03C4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA08__FLEXCAN1_TX                         0x0138 0x03C4 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA09__LCDIF_DATA09                        0x013C 0x03C8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA09__SAI3_MCLK                           0x013C 0x03C8 0x0600 0x1 0x1
#define MX6UL_PAD_LCD_DATA09__CA7_MX6UL_TRACE9                    0x013C 0x03C8 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA09__CSI_DATA17                          0x013C 0x03C8 0x0508 0x3 0x1
#define MX6UL_PAD_LCD_DATA09__EIM_DATA01                          0x013C 0x03C8 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA09__GPIO3_IO14                          0x013C 0x03C8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA09__SRC_BT_CFG09                        0x013C 0x03C8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA09__FLEXCAN1_RX                         0x013C 0x03C8 0x0584 0x8 0x2
#define MX6UL_PAD_LCD_DATA10__LCDIF_DATA10                        0x0140 0x03CC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA10__SAI3_RX_SYNC                        0x0140 0x03CC 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA10__CA7_MX6UL_TRACE10                   0x0140 0x03CC 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA10__CSI_DATA18                          0x0140 0x03CC 0x050C 0x3 0x1
#define MX6UL_PAD_LCD_DATA10__EIM_DATA02                          0x0140 0x03CC 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA10__GPIO3_IO15                          0x0140 0x03CC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA10__SRC_BT_CFG10                        0x0140 0x03CC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA10__FLEXCAN2_TX                         0x0140 0x03CC 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA11__LCDIF_DATA11                        0x0144 0x03D0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA11__SAI3_RX_BCLK                        0x0144 0x03D0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA11__CA7_MX6UL_TRACE11                   0x0144 0x03D0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA11__CSI_DATA19                          0x0144 0x03D0 0x0510 0x3 0x1
#define MX6UL_PAD_LCD_DATA11__EIM_DATA03                          0x0144 0x03D0 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA11__GPIO3_IO16                          0x0144 0x03D0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA11__SRC_BT_CFG11                        0x0144 0x03D0 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA11__FLEXCAN2_RX                         0x0144 0x03D0 0x0588 0x8 0x2
#define MX6UL_PAD_LCD_DATA12__LCDIF_DATA12                        0x0148 0x03D4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA12__SAI3_TX_SYNC                        0x0148 0x03D4 0x060C 0x1 0x1
#define MX6UL_PAD_LCD_DATA12__CA7_MX6UL_TRACE12                   0x0148 0x03D4 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA12__CSI_DATA20                          0x0148 0x03D4 0x0514 0x3 0x1
#define MX6UL_PAD_LCD_DATA12__EIM_DATA04                          0x0148 0x03D4 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA12__GPIO3_IO17                          0x0148 0x03D4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA12__SRC_BT_CFG12                        0x0148 0x03D4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA12__ECSPI1_RDY                          0x0148 0x03D4 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA13__LCDIF_DATA13                        0x014C 0x03D8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA13__SAI3_TX_BCLK                        0x014C 0x03D8 0x0608 0x1 0x1
#define MX6UL_PAD_LCD_DATA13__CA7_MX6UL_TRACE13                   0x014C 0x03D8 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA13__CSI_DATA21                          0x014C 0x03D8 0x0518 0x3 0x1
#define MX6UL_PAD_LCD_DATA13__EIM_DATA05                          0x014C 0x03D8 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA13__GPIO3_IO18                          0x014C 0x03D8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA13__SRC_BT_CFG13                        0x014C 0x03D8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA13__USDHC2_RESET_B                      0x014C 0x03D8 0x0000 0x8 0x0
#define MX6UL_PAD_LCD_DATA14__LCDIF_DATA14                        0x0150 0x03DC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA14__SAI3_RX_DATA                        0x0150 0x03DC 0x0604 0x1 0x1
#define MX6UL_PAD_LCD_DATA14__CA7_MX6UL_TRACE14                   0x0150 0x03DC 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA14__CSI_DATA22                          0x0150 0x03DC 0x051C 0x3 0x1
#define MX6UL_PAD_LCD_DATA14__EIM_DATA06                          0x0150 0x03DC 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA14__GPIO3_IO19                          0x0150 0x03DC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA14__SRC_BT_CFG14                        0x0150 0x03DC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA14__USDHC2_DATA4                        0x0150 0x03DC 0x068C 0x8 0x0
#define MX6UL_PAD_LCD_DATA15__LCDIF_DATA15                        0x0154 0x03E0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA15__SAI3_TX_DATA                        0x0154 0x03E0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA15__CA7_MX6UL_TRACE15                   0x0154 0x03E0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA15__CSI_DATA23                          0x0154 0x03E0 0x0520 0x3 0x1
#define MX6UL_PAD_LCD_DATA15__EIM_DATA07                          0x0154 0x03E0 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA15__GPIO3_IO20                          0x0154 0x03E0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA15__SRC_BT_CFG15                        0x0154 0x03E0 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA15__USDHC2_DATA5                        0x0154 0x03E0 0x0690 0x8 0x0
#define MX6UL_PAD_LCD_DATA16__LCDIF_DATA16                        0x0158 0x03E4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA16__UART7_DCE_TX                        0x0158 0x03E4 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA16__UART7_DTE_RX                        0x0158 0x03E4 0x0654 0x1 0x2
#define MX6UL_PAD_LCD_DATA16__CA7_MX6UL_TRACE_CLK                 0x0158 0x03E4 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA16__CSI_DATA01                          0x0158 0x03E4 0x04D4 0x3 0x1
#define MX6UL_PAD_LCD_DATA16__EIM_DATA08                          0x0158 0x03E4 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA16__GPIO3_IO21                          0x0158 0x03E4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA16__SRC_BT_CFG24                        0x0158 0x03E4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA16__USDHC2_DATA6                        0x0158 0x03E4 0x0694 0x8 0x0
#define MX6UL_PAD_LCD_DATA17__LCDIF_DATA17                        0x015C 0x03E8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA17__UART7_DCE_RX                        0x015C 0x03E8 0x0654 0x1 0x3
#define MX6UL_PAD_LCD_DATA17__UART7_DTE_TX                        0x015C 0x03E8 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA17__CA7_MX6UL_TRACE_CTL                 0x015C 0x03E8 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA17__CSI_DATA00                          0x015C 0x03E8 0x04D0 0x3 0x1
#define MX6UL_PAD_LCD_DATA17__EIM_DATA09                          0x015C 0x03E8 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA17__GPIO3_IO22                          0x015C 0x03E8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA17__SRC_BT_CFG25                        0x015C 0x03E8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA17__USDHC2_DATA7                        0x015C 0x03E8 0x0698 0x8 0x0
#define MX6UL_PAD_LCD_DATA18__LCDIF_DATA18                        0x0160 0x03EC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA18__PWM5_OUT                            0x0160 0x03EC 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA18__CA7_MX6UL_EVENTO                    0x0160 0x03EC 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA18__CSI_DATA10                          0x0160 0x03EC 0x04EC 0x3 0x1
#define MX6UL_PAD_LCD_DATA18__EIM_DATA10                          0x0160 0x03EC 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA18__GPIO3_IO23                          0x0160 0x03EC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA18__SRC_BT_CFG26                        0x0160 0x03EC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA18__USDHC2_CMD                          0x0160 0x03EC 0x0678 0x8 0x1
#define MX6UL_PAD_LCD_DATA19__EIM_DATA11                          0x0164 0x03F0 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA19__GPIO3_IO24                          0x0164 0x03F0 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA19__SRC_BT_CFG27                        0x0164 0x03F0 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA19__USDHC2_CLK                          0x0164 0x03F0 0x0670 0x8 0x1
#define MX6UL_PAD_LCD_DATA19__LCDIF_DATA19                        0x0164 0x03F0 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA19__PWM6_OUT                            0x0164 0x03F0 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA19__WDOG1_WDOG_ANY                      0x0164 0x03F0 0x0000 0x2 0x0
#define MX6UL_PAD_LCD_DATA19__CSI_DATA11                          0x0164 0x03F0 0x04F0 0x3 0x1
#define MX6UL_PAD_LCD_DATA20__EIM_DATA12                          0x0168 0x03F4 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA20__GPIO3_IO25                          0x0168 0x03F4 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA20__SRC_BT_CFG28                        0x0168 0x03F4 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA20__USDHC2_DATA0                        0x0168 0x03F4 0x067C 0x8 0x1
#define MX6UL_PAD_LCD_DATA20__LCDIF_DATA20                        0x0168 0x03F4 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA20__UART8_DCE_TX                        0x0168 0x03F4 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA20__UART8_DTE_RX                        0x0168 0x03F4 0x065C 0x1 0x2
#define MX6UL_PAD_LCD_DATA20__ECSPI1_SCLK                         0x0168 0x03F4 0x0534 0x2 0x0
#define MX6UL_PAD_LCD_DATA20__CSI_DATA12                          0x0168 0x03F4 0x04F4 0x3 0x1
#define MX6UL_PAD_LCD_DATA21__LCDIF_DATA21                        0x016C 0x03F8 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA21__UART8_DCE_RX                        0x016C 0x03F8 0x065C 0x1 0x3
#define MX6UL_PAD_LCD_DATA21__UART8_DTE_TX                        0x016C 0x03F8 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA21__ECSPI1_SS0                          0x016C 0x03F8 0x0540 0x2 0x0
#define MX6UL_PAD_LCD_DATA21__CSI_DATA13                          0x016C 0x03F8 0x04F8 0x3 0x1
#define MX6UL_PAD_LCD_DATA21__EIM_DATA13                          0x016C 0x03F8 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA21__GPIO3_IO26                          0x016C 0x03F8 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA21__SRC_BT_CFG29                        0x016C 0x03F8 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA21__USDHC2_DATA1                        0x016C 0x03F8 0x0680 0x8 0x1
#define MX6UL_PAD_LCD_DATA22__LCDIF_DATA22                        0x0170 0x03FC 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA22__MQS_RIGHT                           0x0170 0x03FC 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA22__ECSPI1_MOSI                         0x0170 0x03FC 0x053C 0x2 0x0
#define MX6UL_PAD_LCD_DATA22__CSI_DATA14                          0x0170 0x03FC 0x04FC 0x3 0x1
#define MX6UL_PAD_LCD_DATA22__EIM_DATA14                          0x0170 0x03FC 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA22__GPIO3_IO27                          0x0170 0x03FC 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA22__SRC_BT_CFG30                        0x0170 0x03FC 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA22__USDHC2_DATA2                        0x0170 0x03FC 0x0684 0x8 0x0
#define MX6UL_PAD_LCD_DATA23__LCDIF_DATA23                        0x0174 0x0400 0x0000 0x0 0x0
#define MX6UL_PAD_LCD_DATA23__MQS_LEFT                            0x0174 0x0400 0x0000 0x1 0x0
#define MX6UL_PAD_LCD_DATA23__ECSPI1_MISO                         0x0174 0x0400 0x0538 0x2 0x0
#define MX6UL_PAD_LCD_DATA23__CSI_DATA15                          0x0174 0x0400 0x0500 0x3 0x1
#define MX6UL_PAD_LCD_DATA23__EIM_DATA15                          0x0174 0x0400 0x0000 0x4 0x0
#define MX6UL_PAD_LCD_DATA23__GPIO3_IO28                          0x0174 0x0400 0x0000 0x5 0x0
#define MX6UL_PAD_LCD_DATA23__SRC_BT_CFG31                        0x0174 0x0400 0x0000 0x6 0x0
#define MX6UL_PAD_LCD_DATA23__USDHC2_DATA3                        0x0174 0x0400 0x0688 0x8 0x1
#define MX6UL_PAD_NAND_RE_B__RAWNAND_RE_B                         0x0178 0x0404 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_RE_B__USDHC2_CLK                           0x0178 0x0404 0x0670 0x1 0x2
#define MX6UL_PAD_NAND_RE_B__QSPI_B_SCLK                          0x0178 0x0404 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_RE_B__KPP_ROW00                            0x0178 0x0404 0x05D0 0x3 0x1
#define MX6UL_PAD_NAND_RE_B__EIM_EB_B00                           0x0178 0x0404 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_RE_B__GPIO4_IO00                           0x0178 0x0404 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_RE_B__ECSPI3_SS2                           0x0178 0x0404 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_WE_B__RAWNAND_WE_B                         0x017C 0x0408 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_WE_B__USDHC2_CMD                           0x017C 0x0408 0x0678 0x1 0x2
#define MX6UL_PAD_NAND_WE_B__QSPI_B_SS0_B                         0x017C 0x0408 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_WE_B__KPP_COL00                            0x017C 0x0408 0x05C4 0x3 0x1
#define MX6UL_PAD_NAND_WE_B__EIM_EB_B01                           0x017C 0x0408 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_WE_B__GPIO4_IO01                           0x017C 0x0408 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_WE_B__ECSPI3_SS3                           0x017C 0x0408 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA00__RAWNAND_DATA00                     0x0180 0x040C 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA00__USDHC2_DATA0                       0x0180 0x040C 0x067C 0x1 0x2
#define MX6UL_PAD_NAND_DATA00__QSPI_B_SS1_B                       0x0180 0x040C 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA00__KPP_ROW01                          0x0180 0x040C 0x05D4 0x3 0x1
#define MX6UL_PAD_NAND_DATA00__EIM_AD08                           0x0180 0x040C 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA00__GPIO4_IO02                         0x0180 0x040C 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA00__ECSPI4_RDY                         0x0180 0x040C 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA01__RAWNAND_DATA01                     0x0184 0x0410 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA01__USDHC2_DATA1                       0x0184 0x0410 0x0680 0x1 0x2
#define MX6UL_PAD_NAND_DATA01__QSPI_B_DQS                         0x0184 0x0410 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA01__KPP_COL01                          0x0184 0x0410 0x05C8 0x3 0x1
#define MX6UL_PAD_NAND_DATA01__EIM_AD09                           0x0184 0x0410 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA01__GPIO4_IO03                         0x0184 0x0410 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA01__ECSPI4_SS1                         0x0184 0x0410 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA02__RAWNAND_DATA02                     0x0188 0x0414 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA02__USDHC2_DATA2                       0x0188 0x0414 0x0684 0x1 0x1
#define MX6UL_PAD_NAND_DATA02__QSPI_B_DATA00                      0x0188 0x0414 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA02__KPP_ROW02                          0x0188 0x0414 0x05D8 0x3 0x1
#define MX6UL_PAD_NAND_DATA02__EIM_AD10                           0x0188 0x0414 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA02__GPIO4_IO04                         0x0188 0x0414 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA02__ECSPI4_SS2                         0x0188 0x0414 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA03__RAWNAND_DATA03                     0x018C 0x0418 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA03__USDHC2_DATA3                       0x018C 0x0418 0x0688 0x1 0x2
#define MX6UL_PAD_NAND_DATA03__QSPI_B_DATA01                      0x018C 0x0418 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA03__KPP_COL02                          0x018C 0x0418 0x05CC 0x3 0x1
#define MX6UL_PAD_NAND_DATA03__EIM_AD11                           0x018C 0x0418 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA03__GPIO4_IO05                         0x018C 0x0418 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA03__ECSPI4_SS3                         0x018C 0x0418 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA04__RAWNAND_DATA04                     0x0190 0x041C 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA04__USDHC2_DATA4                       0x0190 0x041C 0x068C 0x1 0x1
#define MX6UL_PAD_NAND_DATA04__QSPI_B_DATA02                      0x0190 0x041C 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA04__ECSPI4_SCLK                        0x0190 0x041C 0x0564 0x3 0x1
#define MX6UL_PAD_NAND_DATA04__EIM_AD12                           0x0190 0x041C 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA04__GPIO4_IO06                         0x0190 0x041C 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA04__UART2_DCE_TX                       0x0190 0x041C 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA04__UART2_DTE_RX                       0x0190 0x041C 0x062C 0x8 0x2
#define MX6UL_PAD_NAND_DATA05__RAWNAND_DATA05                     0x0194 0x0420 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA05__USDHC2_DATA5                       0x0194 0x0420 0x0690 0x1 0x1
#define MX6UL_PAD_NAND_DATA05__QSPI_B_DATA03                      0x0194 0x0420 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA05__ECSPI4_MOSI                        0x0194 0x0420 0x056C 0x3 0x1
#define MX6UL_PAD_NAND_DATA05__EIM_AD13                           0x0194 0x0420 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA05__GPIO4_IO07                         0x0194 0x0420 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA05__UART2_DCE_RX                       0x0194 0x0420 0x062C 0x8 0x3
#define MX6UL_PAD_NAND_DATA05__UART2_DTE_TX                       0x0194 0x0420 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA06__RAWNAND_DATA06                     0x0198 0x0424 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA06__USDHC2_DATA6                       0x0198 0x0424 0x0694 0x1 0x1
#define MX6UL_PAD_NAND_DATA06__SAI2_RX_BCLK                       0x0198 0x0424 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA06__ECSPI4_MISO                        0x0198 0x0424 0x0568 0x3 0x1
#define MX6UL_PAD_NAND_DATA06__EIM_AD14                           0x0198 0x0424 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA06__GPIO4_IO08                         0x0198 0x0424 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA06__UART2_DCE_CTS                      0x0198 0x0424 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DATA06__UART2_DTE_RTS                      0x0198 0x0424 0x0628 0x8 0x4
#define MX6UL_PAD_NAND_DATA07__RAWNAND_DATA07                     0x019C 0x0428 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DATA07__USDHC2_DATA7                       0x019C 0x0428 0x0698 0x1 0x1
#define MX6UL_PAD_NAND_DATA07__QSPI_A_SS1_B                       0x019C 0x0428 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DATA07__ECSPI4_SS0                         0x019C 0x0428 0x0570 0x3 0x1
#define MX6UL_PAD_NAND_DATA07__EIM_AD15                           0x019C 0x0428 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DATA07__GPIO4_IO09                         0x019C 0x0428 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DATA07__UART2_DCE_RTS                      0x019C 0x0428 0x0628 0x8 0x5
#define MX6UL_PAD_NAND_DATA07__UART2_DTE_CTS                      0x019C 0x0428 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_ALE__RAWNAND_ALE                           0x01A0 0x042C 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_ALE__USDHC2_RESET_B                        0x01A0 0x042C 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_ALE__QSPI_A_DQS                            0x01A0 0x042C 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_ALE__PWM3_OUT                              0x01A0 0x042C 0x0000 0x3 0x0
#define MX6UL_PAD_NAND_ALE__EIM_ADDR17                            0x01A0 0x042C 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_ALE__GPIO4_IO10                            0x01A0 0x042C 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_ALE__ECSPI3_SS1                            0x01A0 0x042C 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_WP_B__RAWNAND_WP_B                         0x01A4 0x0430 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_WP_B__USDHC1_RESET_B                       0x01A4 0x0430 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_WP_B__QSPI_A_SCLK                          0x01A4 0x0430 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_WP_B__PWM4_OUT                             0x01A4 0x0430 0x0000 0x3 0x0
#define MX6UL_PAD_NAND_WP_B__EIM_BCLK                             0x01A4 0x0430 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_WP_B__GPIO4_IO11                           0x01A4 0x0430 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_WP_B__ECSPI3_RDY                           0x01A4 0x0430 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_READY_B__RAWNAND_READY_B                   0x01A8 0x0434 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_READY_B__USDHC1_DATA4                      0x01A8 0x0434 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_READY_B__QSPI_A_DATA00                     0x01A8 0x0434 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_READY_B__ECSPI3_SS0                        0x01A8 0x0434 0x0560 0x3 0x1
#define MX6UL_PAD_NAND_READY_B__EIM_CS1_B                         0x01A8 0x0434 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_READY_B__GPIO4_IO12                        0x01A8 0x0434 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_READY_B__UART3_DCE_TX                      0x01A8 0x0434 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_READY_B__UART3_DTE_RX                      0x01A8 0x0434 0x0634 0x8 0x2
#define MX6UL_PAD_NAND_CE0_B__RAWNAND_CE0_B                       0x01AC 0x0438 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_CE0_B__USDHC1_DATA5                        0x01AC 0x0438 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_CE0_B__QSPI_A_DATA01                       0x01AC 0x0438 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_CE0_B__ECSPI3_SCLK                         0x01AC 0x0438 0x0554 0x3 0x1
#define MX6UL_PAD_NAND_CE0_B__EIM_DTACK_B                         0x01AC 0x0438 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_CE0_B__GPIO4_IO13                          0x01AC 0x0438 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_CE0_B__UART3_DCE_RX                        0x01AC 0x0438 0x0634 0x8 0x3
#define MX6UL_PAD_NAND_CE0_B__UART3_DTE_TX                        0x01AC 0x0438 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_CE1_B__RAWNAND_CE1_B                       0x01B0 0x043C 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_CE1_B__USDHC1_DATA6                        0x01B0 0x043C 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_CE1_B__QSPI_A_DATA02                       0x01B0 0x043C 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_CE1_B__ECSPI3_MOSI                         0x01B0 0x043C 0x055C 0x3 0x1
#define MX6UL_PAD_NAND_CE1_B__EIM_ADDR18                          0x01B0 0x043C 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_CE1_B__GPIO4_IO14                          0x01B0 0x043C 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_CE1_B__UART3_DCE_CTS                       0x01B0 0x043C 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_CE1_B__UART3_DTE_RTS                       0x01B0 0x043C 0x0630 0x8 0x2
#define MX6UL_PAD_NAND_CLE__RAWNAND_CLE                           0x01B4 0x0440 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_CLE__USDHC1_DATA7                          0x01B4 0x0440 0x0000 0x1 0x0
#define MX6UL_PAD_NAND_CLE__QSPI_A_DATA03                         0x01B4 0x0440 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_CLE__ECSPI3_MISO                           0x01B4 0x0440 0x0558 0x3 0x1
#define MX6UL_PAD_NAND_CLE__EIM_ADDR16                            0x01B4 0x0440 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_CLE__GPIO4_IO15                            0x01B4 0x0440 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_CLE__UART3_DCE_RTS                         0x01B4 0x0440 0x0630 0x8 0x3
#define MX6UL_PAD_NAND_CLE__UART3_DTE_CTS                         0x01B4 0x0440 0x0000 0x8 0x0
#define MX6UL_PAD_NAND_DQS__RAWNAND_DQS                           0x01B8 0x0444 0x0000 0x0 0x0
#define MX6UL_PAD_NAND_DQS__CSI_FIELD                             0x01B8 0x0444 0x0530 0x1 0x1
#define MX6UL_PAD_NAND_DQS__QSPI_A_SS0_B                          0x01B8 0x0444 0x0000 0x2 0x0
#define MX6UL_PAD_NAND_DQS__PWM5_OUT                              0x01B8 0x0444 0x0000 0x3 0x0
#define MX6UL_PAD_NAND_DQS__EIM_WAIT                              0x01B8 0x0444 0x0000 0x4 0x0
#define MX6UL_PAD_NAND_DQS__GPIO4_IO16                            0x01B8 0x0444 0x0000 0x5 0x0
#define MX6UL_PAD_NAND_DQS__SDMA_EXT_EVENT01                      0x01B8 0x0444 0x0614 0x6 0x1
#define MX6UL_PAD_NAND_DQS__SPDIF_EXT_CLK                         0x01B8 0x0444 0x061C 0x8 0x1
#define MX6UL_PAD_SD1_CMD__USDHC1_CMD                             0x01BC 0x0448 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_CMD__GPT2_COMPARE1                          0x01BC 0x0448 0x0000 0x1 0x0
#define MX6UL_PAD_SD1_CMD__SAI2_RX_SYNC                           0x01BC 0x0448 0x0000 0x2 0x0
#define MX6UL_PAD_SD1_CMD__SPDIF_OUT                              0x01BC 0x0448 0x0000 0x3 0x0
#define MX6UL_PAD_SD1_CMD__EIM_ADDR19                             0x01BC 0x0448 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_CMD__GPIO2_IO16                             0x01BC 0x0448 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_CMD__SDMA_EXT_EVENT00                       0x01BC 0x0448 0x0610 0x6 0x2
#define MX6UL_PAD_SD1_CMD__USB_OTG1_PWR                           0x01BC 0x0448 0x0000 0x8 0x0
#define MX6UL_PAD_SD1_CLK__USDHC1_CLK                             0x01C0 0x044C 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_CLK__GPT2_COMPARE2                          0x01C0 0x044C 0x0000 0x1 0x0
#define MX6UL_PAD_SD1_CLK__SAI2_MCLK                              0x01C0 0x044C 0x05F0 0x2 0x1
#define MX6UL_PAD_SD1_CLK__SPDIF_IN                               0x01C0 0x044C 0x0618 0x3 0x3
#define MX6UL_PAD_SD1_CLK__EIM_ADDR20                             0x01C0 0x044C 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_CLK__GPIO2_IO17                             0x01C0 0x044C 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_CLK__USB_OTG1_OC                            0x01C0 0x044C 0x0664 0x8 0x2
#define MX6UL_PAD_SD1_DATA0__USDHC1_DATA0                         0x01C4 0x0450 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_DATA0__GPT2_COMPARE3                        0x01C4 0x0450 0x0000 0x1 0x0
#define MX6UL_PAD_SD1_DATA0__SAI2_TX_SYNC                         0x01C4 0x0450 0x05FC 0x2 0x1
#define MX6UL_PAD_SD1_DATA0__FLEXCAN1_TX                          0x01C4 0x0450 0x0000 0x3 0x0
#define MX6UL_PAD_SD1_DATA0__EIM_ADDR21                           0x01C4 0x0450 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_DATA0__GPIO2_IO18                           0x01C4 0x0450 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_DATA0__ANATOP_OTG1_ID                       0x01C4 0x0450 0x04B8 0x8 0x2
#define MX6UL_PAD_SD1_DATA1__USDHC1_DATA1                         0x01C8 0x0454 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_DATA1__GPT2_CLK                             0x01C8 0x0454 0x05A0 0x1 0x1
#define MX6UL_PAD_SD1_DATA1__SAI2_TX_BCLK                         0x01C8 0x0454 0x05F8 0x2 0x1
#define MX6UL_PAD_SD1_DATA1__FLEXCAN1_RX                          0x01C8 0x0454 0x0584 0x3 0x3
#define MX6UL_PAD_SD1_DATA1__EIM_ADDR22                           0x01C8 0x0454 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_DATA1__GPIO2_IO19                           0x01C8 0x0454 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_DATA1__USB_OTG2_PWR                         0x01C8 0x0454 0x0000 0x8 0x0
#define MX6UL_PAD_SD1_DATA2__USDHC1_DATA2                         0x01CC 0x0458 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_DATA2__GPT2_CAPTURE1                        0x01CC 0x0458 0x0598 0x1 0x1
#define MX6UL_PAD_SD1_DATA2__SAI2_RX_DATA                         0x01CC 0x0458 0x05F4 0x2 0x1
#define MX6UL_PAD_SD1_DATA2__FLEXCAN2_TX                          0x01CC 0x0458 0x0000 0x3 0x0
#define MX6UL_PAD_SD1_DATA2__EIM_ADDR23                           0x01CC 0x0458 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_DATA2__GPIO2_IO20                           0x01CC 0x0458 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_DATA2__CCM_CLKO1                            0x01CC 0x0458 0x0000 0x6 0x0
#define MX6UL_PAD_SD1_DATA2__USB_OTG2_OC                          0x01CC 0x0458 0x0660 0x8 0x2
#define MX6UL_PAD_SD1_DATA3__USDHC1_DATA3                         0x01D0 0x045C 0x0000 0x0 0x0
#define MX6UL_PAD_SD1_DATA3__GPT2_CAPTURE2                        0x01D0 0x045C 0x059C 0x1 0x1
#define MX6UL_PAD_SD1_DATA3__SAI2_TX_DATA                         0x01D0 0x045C 0x0000 0x2 0x0
#define MX6UL_PAD_SD1_DATA3__FLEXCAN2_RX                          0x01D0 0x045C 0x0588 0x3 0x3
#define MX6UL_PAD_SD1_DATA3__EIM_ADDR24                           0x01D0 0x045C 0x0000 0x4 0x0
#define MX6UL_PAD_SD1_DATA3__GPIO2_IO21                           0x01D0 0x045C 0x0000 0x5 0x0
#define MX6UL_PAD_SD1_DATA3__CCM_CLKO2                            0x01D0 0x045C 0x0000 0x6 0x0
#define MX6UL_PAD_SD1_DATA3__ANATOP_OTG2_ID                       0x01D0 0x045C 0x04BC 0x8 0x2
#define MX6UL_PAD_CSI_MCLK__CSI_MCLK                              0x01D4 0x0460 0x0000 0x0 0x0
#define MX6UL_PAD_CSI_MCLK__USDHC2_CD_B                           0x01D4 0x0460 0x0674 0x1 0x0
#define MX6UL_PAD_CSI_MCLK__RAWNAND_CE2_B                         0x01D4 0x0460 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_MCLK__I2C1_SDA                              0x01D4 0x0460 0x05A8 0x3 0x0
#define MX6UL_PAD_CSI_MCLK__EIM_CS0_B                             0x01D4 0x0460 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_MCLK__GPIO4_IO17                            0x01D4 0x0460 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_MCLK__SNVS_HP_VIO_5_CTL                     0x01D4 0x0460 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_MCLK__UART6_DCE_TX                          0x01D4 0x0460 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_MCLK__UART6_DTE_RX                          0x01D4 0x0460 0x064C 0x8 0x0
#define MX6UL_PAD_CSI_PIXCLK__CSI_PIXCLK                          0x01D8 0x0464 0x0528 0x0 0x1
#define MX6UL_PAD_CSI_PIXCLK__USDHC2_WP                           0x01D8 0x0464 0x069C 0x1 0x2
#define MX6UL_PAD_CSI_PIXCLK__RAWNAND_CE3_B                       0x01D8 0x0464 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_PIXCLK__I2C1_SCL                            0x01D8 0x0464 0x05A4 0x3 0x2
#define MX6UL_PAD_CSI_PIXCLK__EIM_OE                              0x01D8 0x0464 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_PIXCLK__GPIO4_IO18                          0x01D8 0x0464 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_PIXCLK__SNVS_HP_VIO_5                       0x01D8 0x0464 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_PIXCLK__UART6_DCE_RX                        0x01D8 0x0464 0x064C 0x8 0x3
#define MX6UL_PAD_CSI_PIXCLK__UART6_DTE_TX                        0x01D8 0x0464 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_VSYNC__CSI_VSYNC                            0x01DC 0x0468 0x052C 0x0 0x0
#define MX6UL_PAD_CSI_VSYNC__USDHC2_CLK                           0x01DC 0x0468 0x0670 0x1 0x0
#define MX6UL_PAD_CSI_VSYNC__SIM1_PORT1_CLK                       0x01DC 0x0468 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_VSYNC__I2C2_SDA                             0x01DC 0x0468 0x05B0 0x3 0x0
#define MX6UL_PAD_CSI_VSYNC__EIM_RW                               0x01DC 0x0468 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_VSYNC__GPIO4_IO19                           0x01DC 0x0468 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_VSYNC__PWM7_OUT                             0x01DC 0x0468 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_VSYNC__UART6_DCE_RTS                        0x01DC 0x0468 0x0648 0x8 0x0
#define MX6UL_PAD_CSI_VSYNC__UART6_DTE_CTS                        0x01DC 0x0468 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_HSYNC__CSI_HSYNC                            0x01E0 0x046C 0x0524 0x0 0x0
#define MX6UL_PAD_CSI_HSYNC__USDHC2_CMD                           0x01E0 0x046C 0x0678 0x1 0x0
#define MX6UL_PAD_CSI_HSYNC__SIM1_PORT1_PD                        0x01E0 0x046C 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_HSYNC__I2C2_SCL                             0x01E0 0x046C 0x05AC 0x3 0x0
#define MX6UL_PAD_CSI_HSYNC__EIM_LBA_B                            0x01E0 0x046C 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_HSYNC__GPIO4_IO20                           0x01E0 0x046C 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_HSYNC__PWM8_OUT                             0x01E0 0x046C 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_HSYNC__UART6_DCE_CTS                        0x01E0 0x046C 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_HSYNC__UART6_DTE_RTS                        0x01E0 0x046C 0x0648 0x8 0x1
#define MX6UL_PAD_CSI_DATA00__CSI_DATA02                          0x01E4 0x0470 0x04C4 0x0 0x0
#define MX6UL_PAD_CSI_DATA00__USDHC2_DATA0                        0x01E4 0x0470 0x067C 0x1 0x0
#define MX6UL_PAD_CSI_DATA00__SIM1_PORT1_RST_B                    0x01E4 0x0470 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA00__ECSPI2_SCLK                         0x01E4 0x0470 0x0544 0x3 0x0
#define MX6UL_PAD_CSI_DATA00__EIM_AD00                            0x01E4 0x0470 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA00__GPIO4_IO21                          0x01E4 0x0470 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA00__SRC_INT_BOOT                        0x01E4 0x0470 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_DATA00__UART5_DCE_TX                        0x01E4 0x0470 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_DATA00__UART5_DTE_RX                        0x01E4 0x0470 0x0644 0x8 0x0
#define MX6UL_PAD_CSI_DATA01__CSI_DATA03                          0x01E8 0x0474 0x04C8 0x0 0x0
#define MX6UL_PAD_CSI_DATA01__USDHC2_DATA1                        0x01E8 0x0474 0x0680 0x1 0x0
#define MX6UL_PAD_CSI_DATA01__SIM1_PORT1_SVEN                     0x01E8 0x0474 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA01__ECSPI2_SS0                          0x01E8 0x0474 0x0550 0x3 0x0
#define MX6UL_PAD_CSI_DATA01__EIM_AD01                            0x01E8 0x0474 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA01__GPIO4_IO22                          0x01E8 0x0474 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA01__SAI1_MCLK                           0x01E8 0x0474 0x05E0 0x6 0x0
#define MX6UL_PAD_CSI_DATA01__UART5_DCE_RX                        0x01E8 0x0474 0x0644 0x8 0x1
#define MX6UL_PAD_CSI_DATA01__UART5_DTE_TX                        0x01E8 0x0474 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_DATA02__CSI_DATA04                          0x01EC 0x0478 0x04D8 0x0 0x1
#define MX6UL_PAD_CSI_DATA02__USDHC2_DATA2                        0x01EC 0x0478 0x0684 0x1 0x2
#define MX6UL_PAD_CSI_DATA02__SIM1_PORT1_TRXD                     0x01EC 0x0478 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA02__ECSPI2_MOSI                         0x01EC 0x0478 0x054C 0x3 0x1
#define MX6UL_PAD_CSI_DATA02__EIM_AD02                            0x01EC 0x0478 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA02__GPIO4_IO23                          0x01EC 0x0478 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA02__SAI1_RX_SYNC                        0x01EC 0x0478 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_DATA02__UART5_DCE_RTS                       0x01EC 0x0478 0x0640 0x8 0x5
#define MX6UL_PAD_CSI_DATA02__UART5_DTE_CTS                       0x01EC 0x0478 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_DATA03__CSI_DATA05                          0x01F0 0x047C 0x04CC 0x0 0x0
#define MX6UL_PAD_CSI_DATA03__USDHC2_DATA3                        0x01F0 0x047C 0x0688 0x1 0x0
#define MX6UL_PAD_CSI_DATA03__SIM2_PORT1_PD                       0x01F0 0x047C 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA03__ECSPI2_MISO                         0x01F0 0x047C 0x0548 0x3 0x0
#define MX6UL_PAD_CSI_DATA03__EIM_AD03                            0x01F0 0x047C 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA03__GPIO4_IO24                          0x01F0 0x047C 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA03__SAI1_RX_BCLK                        0x01F0 0x047C 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_DATA03__UART5_DCE_CTS                       0x01F0 0x047C 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_DATA03__UART5_DTE_RTS                       0x01F0 0x047C 0x0640 0x8 0x0
#define MX6UL_PAD_CSI_DATA04__CSI_DATA06                          0x01F4 0x0480 0x04DC 0x0 0x1
#define MX6UL_PAD_CSI_DATA04__USDHC2_DATA4                        0x01F4 0x0480 0x068C 0x1 0x2
#define MX6UL_PAD_CSI_DATA04__SIM2_PORT1_CLK                      0x01F4 0x0480 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA04__ECSPI1_SCLK                         0x01F4 0x0480 0x0534 0x3 0x1
#define MX6UL_PAD_CSI_DATA04__EIM_AD04                            0x01F4 0x0480 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA04__GPIO4_IO25                          0x01F4 0x0480 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA04__SAI1_TX_SYNC                        0x01F4 0x0480 0x05EC 0x6 0x1
#define MX6UL_PAD_CSI_DATA04__USDHC1_WP                           0x01F4 0x0480 0x066C 0x8 0x2
#define MX6UL_PAD_CSI_DATA05__CSI_DATA07                          0x01F8 0x0484 0x04E0 0x0 0x1
#define MX6UL_PAD_CSI_DATA05__USDHC2_DATA5                        0x01F8 0x0484 0x0690 0x1 0x2
#define MX6UL_PAD_CSI_DATA05__SIM2_PORT1_RST_B                    0x01F8 0x0484 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA05__ECSPI1_SS0                          0x01F8 0x0484 0x0540 0x3 0x1
#define MX6UL_PAD_CSI_DATA05__EIM_AD05                            0x01F8 0x0484 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA05__GPIO4_IO26                          0x01F8 0x0484 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA05__SAI1_TX_BCLK                        0x01F8 0x0484 0x05E8 0x6 0x1
#define MX6UL_PAD_CSI_DATA05__USDHC1_CD_B                         0x01F8 0x0484 0x0668 0x8 0x2
#define MX6UL_PAD_CSI_DATA06__CSI_DATA08                          0x01FC 0x0488 0x04E4 0x0 0x1
#define MX6UL_PAD_CSI_DATA06__USDHC2_DATA6                        0x01FC 0x0488 0x0694 0x1 0x2
#define MX6UL_PAD_CSI_DATA06__SIM2_PORT1_SVEN                     0x01FC 0x0488 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA06__ECSPI1_MOSI                         0x01FC 0x0488 0x053C 0x3 0x1
#define MX6UL_PAD_CSI_DATA06__EIM_AD06                            0x01FC 0x0488 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA06__GPIO4_IO27                          0x01FC 0x0488 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA06__SAI1_RX_DATA                        0x01FC 0x0488 0x05E4 0x6 0x1
#define MX6UL_PAD_CSI_DATA06__USDHC1_RESET_B                      0x01FC 0x0488 0x0000 0x8 0x0
#define MX6UL_PAD_CSI_DATA07__CSI_DATA09                          0x0200 0x048C 0x04E8 0x0 0x1
#define MX6UL_PAD_CSI_DATA07__USDHC2_DATA7                        0x0200 0x048C 0x0698 0x1 0x2
#define MX6UL_PAD_CSI_DATA07__SIM2_PORT1_TRXD                     0x0200 0x048C 0x0000 0x2 0x0
#define MX6UL_PAD_CSI_DATA07__ECSPI1_MISO                         0x0200 0x048C 0x0538 0x3 0x1
#define MX6UL_PAD_CSI_DATA07__EIM_AD07                            0x0200 0x048C 0x0000 0x4 0x0
#define MX6UL_PAD_CSI_DATA07__GPIO4_IO28                          0x0200 0x048C 0x0000 0x5 0x0
#define MX6UL_PAD_CSI_DATA07__SAI1_TX_DATA                        0x0200 0x048C 0x0000 0x6 0x0
#define MX6UL_PAD_CSI_DATA07__USDHC1_VSELECT                      0x0200 0x048C 0x0000 0x8 0x0

#endif /* __DTS_IMX6UL_PINFUNC_H */
